/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class ValueString
extends Value {
    public static final ValueString EMPTY = new ValueString("");
    protected final String value;
    private TypeInfo type;

    protected ValueString(String value) {
        this.value = value;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return StringUtils.quoteStringSQL(builder, this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueString && this.value.equals(((ValueString)other).value);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return mode.compareString(this.value, ((ValueString)o).value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.value);
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 94;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return this.getNew(this.value.substring(0, p));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int length = this.value.length();
            this.type = type = new TypeInfo(this.getValueType(), length, 0, length, null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 13;
    }

    public static Value get(String s2) {
        return ValueString.get(s2, false);
    }

    public static Value get(String s2, boolean treatEmptyStringsAsNull) {
        if (s2.isEmpty()) {
            return treatEmptyStringsAsNull ? ValueNull.INSTANCE : EMPTY;
        }
        ValueString obj = new ValueString(StringUtils.cache(s2));
        if (s2.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return ValueString.cache(obj);
    }

    protected Value getNew(String s2) {
        return ValueString.get(s2);
    }
}

