/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.store.FileStoreInputStream;
import org.gridgain.internal.h2.store.FileStoreOutputStream;
import org.gridgain.internal.h2.store.LobStorageInterface;
import org.gridgain.internal.h2.store.RangeReader;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLob;

public class ValueLobDb
extends Value {
    private final int valueType;
    private TypeInfo type;
    private final int tableId;
    private final long lobId;
    private final byte[] hmac;
    private final byte[] small;
    private final DataHandler handler;
    private final long precision;
    private final String fileName;
    private final FileStore tempFile;
    private int hash;
    private boolean isRecoveryReference;

    private ValueLobDb(int type, DataHandler handler, int tableId, long lobId, byte[] hmac, long precision) {
        this.valueType = type;
        this.handler = handler;
        this.tableId = tableId;
        this.lobId = lobId;
        this.hmac = hmac;
        this.precision = precision;
        this.small = null;
        this.fileName = null;
        this.tempFile = null;
    }

    private ValueLobDb(int type, byte[] small, long precision) {
        this.valueType = type;
        this.small = small;
        this.precision = precision;
        this.lobId = 0L;
        this.hmac = null;
        this.handler = null;
        this.fileName = null;
        this.tempFile = null;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler handler, Reader in, long remaining) throws IOException {
        this.valueType = 16;
        this.handler = handler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(handler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long tmpPrecision = 0L;
        try (FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, null, null);){
            char[] buff = new char[4096];
            while (true) {
                int len = ValueLobDb.getBufferSize(this.handler, false, remaining);
                if ((len = IOUtils.readFully(in, buff, len)) == 0) {
                    break;
                }
                byte[] data = new String(buff, 0, len).getBytes(StandardCharsets.UTF_8);
                out.write(data);
                tmpPrecision += (long)len;
            }
        }
        this.precision = tmpPrecision;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler handler, byte[] buff, int len, InputStream in, long remaining) throws IOException {
        this.valueType = 15;
        this.handler = handler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(handler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long tmpPrecision = 0L;
        boolean compress = this.handler.getLobCompressionAlgorithm(15) != null;
        try (FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, null, null);){
            do {
                tmpPrecision += (long)len;
                out.write(buff, 0, len);
                if ((remaining -= (long)len) <= 0L) {
                    break;
                }
                len = ValueLobDb.getBufferSize(this.handler, compress, remaining);
            } while ((len = IOUtils.readFully(in, buff, len)) > 0);
        }
        this.precision = tmpPrecision;
        this.tableId = 0;
    }

    private static String createTempLobFileName(DataHandler handler) throws IOException {
        String path = handler.getDatabasePath();
        if (path.isEmpty()) {
            path = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(path, ".temp.db", true);
    }

    public static ValueLobDb create(int type, DataHandler handler, int tableId, long id, byte[] hmac, long precision) {
        return new ValueLobDb(type, handler, tableId, id, hmac, precision);
    }

    @Override
    protected Value convertTo(int t2, Mode mode, Object column, ExtTypeInfo extTypeInfo) {
        if (t2 == this.valueType) {
            return this;
        }
        if (t2 == 16) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createClob(this.getReader(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(t2, this.small);
            }
        } else if (t2 == 15) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createBlob(this.getInputStream(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(t2, this.small);
            }
        }
        return super.convertTo(t2, mode, column, null);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.small == null && this.tableId >= 0;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(this);
        }
    }

    @Override
    public Value copy(DataHandler database, int tableId) {
        if (this.small == null) {
            return this.handler.getLobStorage().copyLob(this, tableId, this.precision);
        }
        if (this.small.length > database.getMaxLengthInplaceLob()) {
            LobStorageInterface s2 = database.getLobStorage();
            Value v = this.valueType == 15 ? s2.createBlob(this.getInputStream(), this.precision) : s2.createClob(this.getReader(), this.precision);
            Value v2 = v.copy(database, tableId);
            v.remove();
            return v2;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = new TypeInfo(this.valueType, this.precision, 0, MathUtils.convertLongToInt(this.precision), null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public String getString() {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.valueType == 16) {
                if (this.small != null) {
                    return new String(this.small, StandardCharsets.UTF_8);
                }
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), len);
            return StringUtils.convertBytesToHex(buff);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.valueType == 16) {
            return super.getBytes();
        }
        if (this.small != null) {
            return Utils.cloneByteArray(this.small);
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.valueType == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.valueType == 16 ? this.getString().hashCode() : (this.small != null ? Utils.getByteArrayHash(this.small) : Utils.getByteArrayHash(this.getBytes()));
        }
        return this.hash;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        if (v instanceof ValueLobDb) {
            ValueLobDb v2 = (ValueLobDb)v;
            if (v == this) {
                return 0;
            }
            if (this.lobId == v2.lobId && this.small == null && v2.small == null) {
                return 0;
            }
        }
        return ValueLob.compare(this, v);
    }

    @Override
    public Object getObject() {
        if (this.valueType == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long oneBasedOffset, long length) {
        return ValueLob.rangeReader(this.getReader(), oneBasedOffset, length, this.valueType == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore store = this.handler.openFile(this.fileName, "r", true);
            boolean alwaysClose = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(store, this.handler, false, alwaysClose), 4096);
        }
        long byteCount = this.valueType == 15 ? this.precision : -1L;
        try {
            return this.handler.getLobStorage().getInputStream(this, this.hmac, byteCount);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public InputStream getInputStream(long oneBasedOffset, long length) {
        InputStream inputStream;
        long byteCount;
        if (this.small != null) {
            return super.getInputStream(oneBasedOffset, length);
        }
        if (this.fileName != null) {
            FileStore store = this.handler.openFile(this.fileName, "r", true);
            boolean alwaysClose = SysProperties.lobCloseBetweenReads;
            byteCount = store.length();
            inputStream = new BufferedInputStream(new FileStoreInputStream(store, this.handler, false, alwaysClose), 4096);
        } else {
            byteCount = this.valueType == 15 ? this.precision : -1L;
            try {
                inputStream = this.handler.getLobStorage().getInputStream(this, this.hmac, byteCount);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.toString());
            }
        }
        return ValueLob.rangeInputStream(inputStream, oneBasedOffset, length, byteCount);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.precision;
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.valueType == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        if (this.valueType == 16) {
            StringUtils.quoteStringSQL(builder, this.getString());
        } else {
            builder.append("X'");
            StringUtils.convertBytesToHex(builder, this.getBytes()).append('\'');
        }
        return builder;
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.precision <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder buff = new StringBuilder();
        if (this.valueType == 16) {
            buff.append("SPACE(").append(this.precision);
        } else {
            buff.append("CAST(REPEAT('00', ").append(this.precision).append(") AS BINARY");
        }
        buff.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return buff.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueLobDb)) {
            return false;
        }
        ValueLobDb otherLob = (ValueLobDb)other;
        if (this.hashCode() != otherLob.hashCode()) {
            return false;
        }
        return this.compareTypeSafe((Value)other, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 127;
        }
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        return this;
    }

    @Override
    public ValueLobDb copyToResult() {
        if (this.handler == null) {
            return this;
        }
        LobStorageInterface s2 = this.handler.getLobStorage();
        if (s2.isReadOnly()) {
            return this;
        }
        return s2.copyLob(this, -3, this.precision);
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader in, long length, DataHandler handler) {
        if (length >= 0L) {
            try {
                in = new RangeReader(in, 0L, length);
            }
            catch (IOException e) {
                throw DbException.convert(e);
            }
        }
        BufferedReader reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in, 4096);
        try {
            char[] buff;
            int len;
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                String data = IOUtils.readStringAndClose(reader, -1);
                buff = data.toCharArray();
                len = buff.length;
            } else {
                buff = new char[len];
                reader.mark(len);
                len = IOUtils.readFully(reader, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = new String(buff, 0, len).getBytes(StandardCharsets.UTF_8);
                return ValueLobDb.createSmallLob(16, small, len);
            }
            reader.reset();
            return new ValueLobDb(handler, reader, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream in, long length, DataHandler handler) {
        try {
            byte[] buff;
            int len;
            boolean compress;
            long remaining = Long.MAX_VALUE;
            boolean bl = compress = handler.getLobCompressionAlgorithm(15) != null;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                buff = IOUtils.readBytesAndClose(in, -1);
                len = buff.length;
            } else {
                buff = Utils.newBytes(len);
                len = IOUtils.readFully(in, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = Utils.copyBytes(buff, len);
                return ValueLobDb.createSmallLob(15, small, small.length);
            }
            return new ValueLobDb(handler, buff, len, in, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private static int getBufferSize(DataHandler handler, boolean compress, long remaining) {
        long m4;
        if (remaining < 0L || remaining > Integer.MAX_VALUE) {
            remaining = Integer.MAX_VALUE;
        }
        int inplace = handler.getMaxLengthInplaceLob();
        long l = m4 = compress ? 131072L : 4096L;
        if (m4 < remaining && m4 <= (long)inplace) {
            m4 = Math.min(remaining, (long)inplace + 1L);
            m4 = MathUtils.roundUpLong(m4, 4096L);
        }
        m4 = Math.min(remaining, m4);
        if ((m4 = (long)MathUtils.convertLongToInt(m4)) < 0L) {
            m4 = Integer.MAX_VALUE;
        }
        return (int)m4;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        ValueLobDb lob;
        if (this.precision <= precision) {
            return this;
        }
        if (this.valueType == 16) {
            if (this.handler == null) {
                try {
                    int p = MathUtils.convertLongToInt(precision);
                    String s2 = IOUtils.readStringAndClose(this.getReader(), p);
                    byte[] data = s2.getBytes(StandardCharsets.UTF_8);
                    lob = ValueLobDb.createSmallLob(this.valueType, data, s2.length());
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, null);
                }
            } else {
                lob = ValueLobDb.createTempClob(this.getReader(), precision, this.handler);
            }
        } else if (this.handler == null) {
            try {
                int p = MathUtils.convertLongToInt(precision);
                byte[] data = IOUtils.readBytesAndClose(this.getInputStream(), p);
                lob = ValueLobDb.createSmallLob(this.valueType, data, data.length);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        } else {
            lob = ValueLobDb.createTempBlob(this.getInputStream(), precision, this.handler);
        }
        return lob;
    }

    public static ValueLobDb createSmallLob(int type, byte[] small) {
        int precision = type == 16 ? new String(small, StandardCharsets.UTF_8).length() : small.length;
        return ValueLobDb.createSmallLob(type, small, precision);
    }

    public static ValueLobDb createSmallLob(int type, byte[] small, long precision) {
        return new ValueLobDb(type, small, precision);
    }

    public void setRecoveryReference(boolean isRecoveryReference) {
        this.isRecoveryReference = isRecoveryReference;
    }

    public boolean isRecoveryReference() {
        return this.isRecoveryReference;
    }
}

