/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBytes;

public class ValueJavaObject
extends ValueBytes {
    private static final ValueJavaObject EMPTY = new ValueJavaObject(Utils.EMPTY_BYTES, null);
    private final DataHandler dataHandler;

    protected ValueJavaObject(byte[] v, DataHandler dataHandler) {
        super(v);
        this.dataHandler = dataHandler;
    }

    public static ValueJavaObject getNoCopy(Object javaObject, byte[] b, DataHandler dataHandler) {
        ValueJavaObject obj;
        if (b != null && b.length == 0) {
            return EMPTY;
        }
        if (SysProperties.serializeJavaObject) {
            if (b == null) {
                b = JdbcUtils.serialize(javaObject, dataHandler);
            }
            obj = new ValueJavaObject(b, dataHandler);
        } else {
            obj = new NotSerialized(javaObject, b, dataHandler);
        }
        if (b == null || b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueJavaObject)ValueJavaObject.cache(obj);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JAVA_OBJECT;
    }

    @Override
    public int getValueType() {
        return 19;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        Object obj = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
        prep.setObject(parameterIndex, obj, 2000);
    }

    @Override
    protected DataHandler getDataHandler() {
        return this.dataHandler;
    }

    private static class NotSerialized
    extends ValueJavaObject {
        private Object javaObject;

        NotSerialized(Object javaObject, byte[] v, DataHandler dataHandler) {
            super(v, dataHandler);
            this.javaObject = javaObject;
        }

        @Override
        public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
            prep.setObject(parameterIndex, this.getObject(), 2000);
        }

        @Override
        public byte[] getBytesNoCopy() {
            if (this.value == null) {
                this.value = JdbcUtils.serialize(this.javaObject, this.getDataHandler());
            }
            return this.value;
        }

        @Override
        public int compareTypeSafe(Value v, CompareMode mode) {
            int h2;
            Object o1 = this.getObject();
            Object o2 = v.getObject();
            boolean o1Comparable = o1 instanceof Comparable;
            boolean o2Comparable = o2 instanceof Comparable;
            if (o1Comparable && o2Comparable && Utils.haveCommonComparableSuperclass(o1.getClass(), o2.getClass())) {
                Comparable c1 = (Comparable)o1;
                return c1.compareTo(o2);
            }
            if (o1.getClass() != o2.getClass()) {
                if (o1Comparable != o2Comparable) {
                    return o1Comparable ? -1 : 1;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
            int h1 = this.hashCode();
            if (h1 == (h2 = v.hashCode())) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return Bits.compareNotNullSigned(this.getBytesNoCopy(), v.getBytesNoCopy());
            }
            return h1 > h2 ? 1 : -1;
        }

        @Override
        public TypeInfo getType() {
            TypeInfo type = this.type;
            if (type == null) {
                String string = this.getString();
                this.type = type = NotSerialized.createType(string);
            }
            return type;
        }

        private static TypeInfo createType(String string) {
            return new TypeInfo(19, 0L, 0, string.length(), null);
        }

        @Override
        public String getString() {
            String str = this.getObject().toString();
            if (this.type == null) {
                this.type = NotSerialized.createType(str);
            }
            return str;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.getObject().hashCode();
            }
            return this.hash;
        }

        @Override
        public Object getObject() {
            if (this.javaObject == null) {
                this.javaObject = JdbcUtils.deserialize(this.value, this.getDataHandler());
            }
            return this.javaObject;
        }

        @Override
        public int getMemory() {
            int mem = 40;
            if (this.javaObject != null) {
                mem *= 2;
            }
            return mem;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof NotSerialized)) {
                return false;
            }
            return this.getObject().equals(((NotSerialized)other).getObject());
        }

        @Override
        public Value convertPrecision(long precision, boolean force) {
            return this;
        }
    }
}

