/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public abstract class ValueCollectionBase
extends Value {
    final Value[] values;
    private TypeInfo type;
    private int hash;
    private int memory;

    ValueCollectionBase(Value[] values) {
        this.values = values;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h2 = this.getValueType();
        for (Value v : this.values) {
            h2 = h2 * 31 + v.hashCode();
        }
        this.hash = h2;
        return h2;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            long precision = 0L;
            long displaySize = 0L;
            for (Value v : this.values) {
                TypeInfo t2 = v.getType();
                precision += t2.getPrecision();
                displaySize += (long)t2.getDisplaySize();
            }
            this.type = type = new TypeInfo(this.getValueType(), precision, 0, MathUtils.convertLongToInt(displaySize), null);
        }
        return type;
    }

    @Override
    public int compareWithNull(Value v, boolean forEquality, Mode databaseMode, CompareMode compareMode) {
        if (v == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        ValueCollectionBase l = this;
        int leftType = l.getValueType();
        int rightType = v.getValueType();
        if (rightType != 17 && rightType != 39) {
            throw v.getDataConversionError(leftType);
        }
        ValueCollectionBase r = (ValueCollectionBase)v;
        Value[] leftArray = l.values;
        int leftLength = leftArray.length;
        Value[] rightArray = r.values;
        int rightLength = rightArray.length;
        if (leftLength != rightLength) {
            if (leftType == 39 || rightType == 39) {
                throw DbException.get(21002);
            }
            if (forEquality) {
                return 1;
            }
        }
        if (forEquality) {
            boolean hasNull = false;
            for (int i = 0; i < leftLength; ++i) {
                Value v1 = leftArray[i];
                Value v2 = rightArray[i];
                int comp = v1.compareWithNull(v2, forEquality, databaseMode, compareMode);
                if (comp == 0) continue;
                if (comp != Integer.MIN_VALUE) {
                    return comp;
                }
                hasNull = true;
            }
            return hasNull ? Integer.MIN_VALUE : 0;
        }
        int len = Math.min(leftLength, rightLength);
        for (int i = 0; i < len; ++i) {
            Value v1 = leftArray[i];
            Value v2 = rightArray[i];
            int comp = v1.compareWithNull(v2, forEquality, databaseMode, compareMode);
            if (comp == 0) continue;
            return comp;
        }
        return Integer.compare(leftLength, rightLength);
    }

    @Override
    public boolean containsNull() {
        for (Value v : this.values) {
            if (!v.containsNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMemory() {
        if (this.memory == 0) {
            this.memory = 72;
            for (Value v : this.values) {
                this.memory += v.getMemory() + 8;
            }
        }
        return this.memory;
    }
}

