/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.geometry.EWKBUtils;
import org.gridgain.internal.h2.util.geometry.GeometryUtils;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public final class JTSUtils {
    public static final boolean M_IS_SUPPORTED;
    static final Method CREATE;
    private static final Method GET_MEASURES;

    public static Geometry ewkb2geometry(byte[] ewkb) {
        GeometryUtils.DimensionSystemTarget dimensionTarget = new GeometryUtils.DimensionSystemTarget();
        EWKBUtils.parseEWKB(ewkb, dimensionTarget);
        return JTSUtils.ewkb2geometry(ewkb, dimensionTarget.getDimensionSystem());
    }

    public static Geometry ewkb2geometry(byte[] ewkb, int dimensionSystem) {
        GeometryTarget target = new GeometryTarget(dimensionSystem);
        EWKBUtils.parseEWKB(ewkb, target);
        return target.getGeometry();
    }

    public static byte[] geometry2ewkb(Geometry geometry) {
        GeometryUtils.DimensionSystemTarget dimensionTarget = new GeometryUtils.DimensionSystemTarget();
        JTSUtils.parseGeometry(geometry, dimensionTarget);
        return JTSUtils.geometry2ewkb(geometry, dimensionTarget.getDimensionSystem());
    }

    public static byte[] geometry2ewkb(Geometry geometry, int dimensionSystem) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EWKBUtils.EWKBTarget target = new EWKBUtils.EWKBTarget(output, dimensionSystem);
        JTSUtils.parseGeometry(geometry, target);
        return output.toByteArray();
    }

    public static void parseGeometry(Geometry geometry, GeometryUtils.Target target) {
        JTSUtils.parseGeometry(geometry, target, 0);
    }

    private static void parseGeometry(Geometry geometry, GeometryUtils.Target target, int parentType) {
        if (parentType == 0) {
            target.init(geometry.getSRID());
        }
        if (geometry instanceof Point) {
            if (parentType != 0 && parentType != 4 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            target.startPoint();
            Point p = (Point)geometry;
            if (p.isEmpty()) {
                target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
            } else {
                CoordinateSequence sequence = p.getCoordinateSequence();
                JTSUtils.addCoordinate(sequence, target, 0, 1, JTSUtils.getMeasures(sequence));
            }
        } else if (geometry instanceof LineString) {
            if (parentType != 0 && parentType != 5 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            LineString ls = (LineString)geometry;
            CoordinateSequence cs = ls.getCoordinateSequence();
            int numPoints = cs.size();
            if (numPoints < 0 || numPoints == 1) {
                throw new IllegalArgumentException();
            }
            target.startLineString(numPoints);
            int measures = JTSUtils.getMeasures(cs);
            for (int i = 0; i < numPoints; ++i) {
                JTSUtils.addCoordinate(cs, target, i, numPoints, measures);
            }
        } else if (geometry instanceof Polygon) {
            if (parentType != 0 && parentType != 6 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            Polygon p = (Polygon)geometry;
            int numInner = p.getNumInteriorRing();
            if (numInner < 0) {
                throw new IllegalArgumentException();
            }
            CoordinateSequence cs = p.getExteriorRing().getCoordinateSequence();
            int size = cs.size();
            if (size < 0 || size >= 1 && size <= 3) {
                throw new IllegalArgumentException();
            }
            if (size == 0 && numInner > 0) {
                throw new IllegalArgumentException();
            }
            target.startPolygon(numInner, size);
            if (size > 0) {
                int measures = JTSUtils.getMeasures(cs);
                JTSUtils.addRing(cs, target, size, measures);
                for (int i = 0; i < numInner; ++i) {
                    cs = p.getInteriorRingN(i).getCoordinateSequence();
                    size = cs.size();
                    if (size < 0 || size >= 1 && size <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(size);
                    JTSUtils.addRing(cs, target, size, measures);
                }
                target.endNonEmptyPolygon();
            }
        } else if (geometry instanceof GeometryCollection) {
            if (parentType != 0 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            GeometryCollection gc = (GeometryCollection)geometry;
            int type = gc instanceof MultiPoint ? 4 : (gc instanceof MultiLineString ? 5 : (gc instanceof MultiPolygon ? 6 : 7));
            int numItems = gc.getNumGeometries();
            if (numItems < 0) {
                throw new IllegalArgumentException();
            }
            target.startCollection(type, numItems);
            for (int i = 0; i < numItems; ++i) {
                GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
                JTSUtils.parseGeometry(gc.getGeometryN(i), innerTarget, type);
                target.endCollectionItem(innerTarget, i, numItems);
            }
            target.endCollection(type);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void addRing(CoordinateSequence sequence, GeometryUtils.Target target, int size, int measures) {
        if (size >= 4) {
            double startX = GeometryUtils.toCanonicalDouble(sequence.getX(0));
            double startY = GeometryUtils.toCanonicalDouble(sequence.getY(0));
            JTSUtils.addCoordinate(sequence, target, 0, size, startX, startY, measures);
            for (int i = 1; i < size - 1; ++i) {
                JTSUtils.addCoordinate(sequence, target, i, size, measures);
            }
            double endX = GeometryUtils.toCanonicalDouble(sequence.getX(size - 1));
            double endY = GeometryUtils.toCanonicalDouble(sequence.getY(size - 1));
            if (startX != endX || startY != endY) {
                throw new IllegalArgumentException();
            }
            JTSUtils.addCoordinate(sequence, target, size - 1, size, endX, endY, measures);
        }
    }

    private static void addCoordinate(CoordinateSequence sequence, GeometryUtils.Target target, int index, int total, int measures) {
        JTSUtils.addCoordinate(sequence, target, index, total, GeometryUtils.toCanonicalDouble(sequence.getX(index)), GeometryUtils.toCanonicalDouble(sequence.getY(index)), measures);
    }

    private static void addCoordinate(CoordinateSequence sequence, GeometryUtils.Target target, int index, int total, double x, double y, int measures) {
        double m4;
        double z;
        int d = sequence.getDimension();
        if (M_IS_SUPPORTED) {
            z = (d -= measures) > 2 ? GeometryUtils.toCanonicalDouble(sequence.getOrdinate(index, 2)) : Double.NaN;
            m4 = measures >= 1 ? GeometryUtils.toCanonicalDouble(sequence.getOrdinate(index, d)) : Double.NaN;
        } else {
            z = d >= 3 ? GeometryUtils.toCanonicalDouble(sequence.getOrdinate(index, 2)) : Double.NaN;
            m4 = d >= 4 ? GeometryUtils.toCanonicalDouble(sequence.getOrdinate(index, 3)) : Double.NaN;
        }
        target.addCoordinate(x, y, z, m4, index, total);
    }

    private static int getMeasures(CoordinateSequence sequence) {
        int m4;
        if (M_IS_SUPPORTED) {
            try {
                m4 = (Integer)GET_MEASURES.invoke((Object)sequence, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw DbException.convert(e);
            }
        } else {
            m4 = 0;
        }
        return m4;
    }

    private JTSUtils() {
    }

    static {
        Method getMeasures;
        Method create;
        try {
            create = CoordinateSequenceFactory.class.getMethod("create", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            getMeasures = CoordinateSequence.class.getMethod("getMeasures", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            create = null;
            getMeasures = null;
        }
        M_IS_SUPPORTED = create != null;
        CREATE = create;
        GET_MEASURES = getMeasures;
    }

    public static final class GeometryTarget
    extends GeometryUtils.Target {
        private final int dimensionSystem;
        private GeometryFactory factory;
        private int type;
        private CoordinateSequence coordinates;
        private CoordinateSequence[] innerCoordinates;
        private int innerOffset;
        private Geometry[] subgeometries;

        public GeometryTarget(int dimensionSystem) {
            this.dimensionSystem = dimensionSystem;
        }

        private GeometryTarget(int dimensionSystem, GeometryFactory factory) {
            this.dimensionSystem = dimensionSystem;
            this.factory = factory;
        }

        @Override
        protected void init(int srid) {
            this.factory = new GeometryFactory(new PrecisionModel(), srid, (this.dimensionSystem & 2) != 0 ? PackedCoordinateSequenceFactory.DOUBLE_FACTORY : CoordinateArraySequenceFactory.instance());
        }

        @Override
        protected void startPoint() {
            this.type = 1;
            this.initCoordinates(1);
            this.innerOffset = -1;
        }

        @Override
        protected void startLineString(int numPoints) {
            this.type = 2;
            this.initCoordinates(numPoints);
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.type = 3;
            this.initCoordinates(numPoints);
            this.innerCoordinates = new CoordinateSequence[numInner];
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.innerCoordinates[++this.innerOffset] = this.createCoordinates(numInner);
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.type = type;
            switch (type) {
                case 4: {
                    this.subgeometries = new Point[numItems];
                    break;
                }
                case 5: {
                    this.subgeometries = new LineString[numItems];
                    break;
                }
                case 6: {
                    this.subgeometries = new Polygon[numItems];
                    break;
                }
                case 7: {
                    this.subgeometries = new Geometry[numItems];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            return new GeometryTarget(this.dimensionSystem, this.factory);
        }

        @Override
        protected void endCollectionItem(GeometryUtils.Target target, int index, int total) {
            this.subgeometries[index] = ((GeometryTarget)target).getGeometry();
        }

        private void initCoordinates(int numPoints) {
            this.coordinates = this.createCoordinates(numPoints);
        }

        private CoordinateSequence createCoordinates(int numPoints) {
            if ((this.dimensionSystem & 2) != 0) {
                if (M_IS_SUPPORTED) {
                    try {
                        return (CoordinateSequence)CREATE.invoke((Object)this.factory.getCoordinateSequenceFactory(), numPoints, 4, 1);
                    }
                    catch (ReflectiveOperationException e) {
                        throw DbException.convert(e);
                    }
                }
                return this.factory.getCoordinateSequenceFactory().create(numPoints, 4);
            }
            return this.factory.getCoordinateSequenceFactory().create(numPoints, 3);
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m4, int index, int total) {
            if (this.type == 1 && Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z) && Double.isNaN(m4)) {
                this.coordinates = this.createCoordinates(0);
                return;
            }
            CoordinateSequence coordinates = this.innerOffset < 0 ? this.coordinates : this.innerCoordinates[this.innerOffset];
            coordinates.setOrdinate(index, 0, GeometryUtils.checkFinite(x));
            coordinates.setOrdinate(index, 1, GeometryUtils.checkFinite(y));
            coordinates.setOrdinate(index, 2, (this.dimensionSystem & 1) != 0 ? GeometryUtils.checkFinite(z) : Double.NaN);
            if ((this.dimensionSystem & 2) != 0) {
                coordinates.setOrdinate(index, 3, GeometryUtils.checkFinite(m4));
            }
        }

        Geometry getGeometry() {
            switch (this.type) {
                case 1: {
                    return new Point(this.coordinates, this.factory);
                }
                case 2: {
                    return new LineString(this.coordinates, this.factory);
                }
                case 3: {
                    LinearRing shell = new LinearRing(this.coordinates, this.factory);
                    int innerCount = this.innerCoordinates.length;
                    LinearRing[] holes = new LinearRing[innerCount];
                    for (int i = 0; i < innerCount; ++i) {
                        holes[i] = new LinearRing(this.innerCoordinates[i], this.factory);
                    }
                    return new Polygon(shell, holes, this.factory);
                }
                case 4: {
                    return new MultiPoint((Point[])this.subgeometries, this.factory);
                }
                case 5: {
                    return new MultiLineString((LineString[])this.subgeometries, this.factory);
                }
                case 6: {
                    return new MultiPolygon((Polygon[])this.subgeometries, this.factory);
                }
                case 7: {
                    return new GeometryCollection(this.subgeometries, this.factory);
                }
            }
            throw new IllegalStateException();
        }
    }
}

