/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.MathUtils;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static long lastGC;
    private static final HashMap<String, byte[]> RESOURCES;

    private Utils() {
    }

    public static int indexOf(byte[] bytes, byte[] pattern, int start) {
        if (pattern.length == 0) {
            return start;
        }
        if (start > bytes.length) {
            return -1;
        }
        int last = bytes.length - pattern.length + 1;
        int patternLen = pattern.length;
        while (start < last) {
            block5: {
                for (int i = 0; i < patternLen; ++i) {
                    if (bytes[start + i] == pattern[i]) {
                        continue;
                    }
                    break block5;
                }
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static int getByteArrayHash(byte[] value) {
        int len;
        int h2 = len = value.length;
        if (len < 50) {
            for (int i = 0; i < len; ++i) {
                h2 = 31 * h2 + value[i];
            }
        } else {
            int i;
            int step = len / 16;
            for (i = 0; i < 4; ++i) {
                h2 = 31 * h2 + value[i];
                h2 = 31 * h2 + value[--len];
            }
            for (i = 4 + step; i < len; i += step) {
                h2 = 31 * h2 + value[i];
            }
        }
        return h2;
    }

    public static boolean compareSecure(byte[] test, byte[] good) {
        if (test == null || good == null) {
            return test == null && good == null;
        }
        int len = test.length;
        if (len != good.length) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int bits = 0;
        for (int i = 0; i < len; ++i) {
            bits |= test[i] ^ good[i];
        }
        return bits == 0;
    }

    public static byte[] copy(byte[] source, byte[] target) {
        int len = source.length;
        if (len > target.length) {
            target = new byte[len];
        }
        System.arraycopy(source, 0, target, 0, len);
        return target;
    }

    public static byte[] newBytes(int len) {
        if (len == 0) {
            return EMPTY_BYTES;
        }
        try {
            return new byte[len];
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Requested memory: " + len);
            e2.initCause(e);
            throw e2;
        }
    }

    public static byte[] copyBytes(byte[] bytes, int len) {
        if (len == 0) {
            return EMPTY_BYTES;
        }
        try {
            return Arrays.copyOf(bytes, len);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Requested memory: " + len);
            e2.initCause(e);
            throw e2;
        }
    }

    public static byte[] cloneByteArray(byte[] b) {
        if (b == null) {
            return null;
        }
        int len = b.length;
        if (len == 0) {
            return EMPTY_BYTES;
        }
        return Arrays.copyOf(b, len);
    }

    public static int getMemoryUsed() {
        Utils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.totalMemory() - rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static int getMemoryFree() {
        Utils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static long getMemoryMax() {
        long max = Runtime.getRuntime().maxMemory();
        return max / 1024L;
    }

    public static long getGarbageCollectionTime() {
        long totalGCTime = 0L;
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionTime = gcMXBean.getCollectionTime();
            if (collectionTime <= 0L) continue;
            totalGCTime += collectionTime;
        }
        return totalGCTime;
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long time = System.nanoTime();
        if (lastGC + TimeUnit.MILLISECONDS.toNanos(50L) < time) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long now = runtime.totalMemory();
                if (now == total) {
                    lastGC = System.nanoTime();
                    break;
                }
                total = now;
            }
        }
    }

    public static int[] newIntArray(int len) {
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[len];
    }

    public static <T> ArrayList<T> newSmallArrayList() {
        return new ArrayList(4);
    }

    public static long[] newLongArray(int len) {
        if (len == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[len];
    }

    public static <X> void sortTopN(X[] array, int offset, int limit, Comparator<? super X> comp) {
        Utils.partitionTopN(array, offset, limit, comp);
        Arrays.sort(array, offset, (int)Math.min((long)offset + (long)limit, (long)array.length), comp);
    }

    private static <X> void partitionTopN(X[] array, int offset, int limit, Comparator<? super X> comp) {
        Utils.partialQuickSort(array, 0, array.length - 1, comp, offset, offset + limit - 1);
    }

    private static <X> void partialQuickSort(X[] array, int low, int high, Comparator<? super X> comp, int start, int end) {
        if (low > end || high < start || low > start && high < end) {
            return;
        }
        if (low == high) {
            return;
        }
        int i = low;
        int j = high;
        int p = low + MathUtils.randomInt(high - low);
        X pivot = array[p];
        int m4 = low + high >>> 1;
        X temp = array[m4];
        array[m4] = pivot;
        array[p] = temp;
        while (i <= j) {
            while (comp.compare(array[i], pivot) < 0) {
                ++i;
            }
            while (comp.compare(array[j], pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            temp = array[i];
            array[i++] = array[j];
            array[j--] = temp;
        }
        if (low < j) {
            Utils.partialQuickSort(array, low, j, comp, start, end);
        }
        if (i < high) {
            Utils.partialQuickSort(array, i, high, comp, start, end);
        }
    }

    public static boolean haveCommonComparableSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> top2;
        Class<?> top1;
        if (c1 == c2 || c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1)) {
            return true;
        }
        do {
            top1 = c1;
        } while (Comparable.class.isAssignableFrom(c1 = c1.getSuperclass()));
        do {
            top2 = c2;
        } while (Comparable.class.isAssignableFrom(c2 = c2.getSuperclass()));
        return top1 == top2;
    }

    public static byte[] getResource(String name) throws IOException {
        byte[] data = RESOURCES.get(name);
        if (data == null && (data = Utils.loadResource(name)) != null) {
            RESOURCES.put(name, data);
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadResource(String name) throws IOException {
        InputStream in = Utils.class.getResourceAsStream("data.zip");
        if (in == null) {
            in = Utils.class.getResourceAsStream(name);
            if (in != null) return IOUtils.readBytesAndClose(in, 0);
            return null;
        }
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            while (true) {
                ZipEntry entry;
                if ((entry = zipIn.getNextEntry()) == null) {
                    return null;
                }
                String entryName = entry.getName();
                if (!entryName.startsWith("/")) {
                    entryName = "/" + entryName;
                }
                if (entryName.equals(name)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy(zipIn, out);
                    zipIn.closeEntry();
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object callStaticMethod(String classAndMethod, Object ... params) throws Exception {
        int lastDot = classAndMethod.lastIndexOf(46);
        String className = classAndMethod.substring(0, lastDot);
        String methodName = classAndMethod.substring(lastDot + 1);
        return Utils.callMethod(null, Class.forName(className), methodName, params);
    }

    public static Object callMethod(Object instance, String methodName, Object ... params) throws Exception {
        return Utils.callMethod(instance, instance.getClass(), methodName, params);
    }

    private static Object callMethod(Object instance, Class<?> clazz, String methodName, Object ... params) throws Exception {
        Method best = null;
        int bestMatch = 0;
        boolean isStatic = instance == null;
        for (Method m4 : clazz.getMethods()) {
            int p;
            if (Modifier.isStatic(m4.getModifiers()) != isStatic || !m4.getName().equals(methodName) || (p = Utils.match(m4.getParameterTypes(), params)) <= bestMatch) continue;
            bestMatch = p;
            best = m4;
        }
        if (best == null) {
            throw new NoSuchMethodException(methodName);
        }
        return best.invoke(instance, params);
    }

    public static Object newInstance(String className, Object ... params) throws Exception {
        Constructor<?> best = null;
        int bestMatch = 0;
        for (Constructor<?> c : Class.forName(className).getConstructors()) {
            int p = Utils.match(c.getParameterTypes(), params);
            if (p <= bestMatch) continue;
            bestMatch = p;
            best = c;
        }
        if (best == null) {
            throw new NoSuchMethodException(className);
        }
        return best.newInstance(params);
    }

    private static int match(Class<?>[] params, Object[] values) {
        int len = params.length;
        if (len == values.length) {
            int points = 1;
            for (int i = 0; i < len; ++i) {
                Class<?> vc;
                Class<?> pc = Utils.getNonPrimitiveClass(params[i]);
                Object v = values[i];
                Class<?> clazz = vc = v == null ? null : v.getClass();
                if (pc == vc) {
                    ++points;
                    continue;
                }
                if (vc == null || pc.isAssignableFrom(vc)) continue;
                return 0;
            }
            return points;
        }
        return 0;
    }

    public static Object getStaticField(String classAndField) throws Exception {
        int lastDot = classAndField.lastIndexOf(46);
        String className = classAndField.substring(0, lastDot);
        String fieldName = classAndField.substring(lastDot + 1);
        return Class.forName(className).getField(fieldName).get(null);
    }

    public static Object getField(Object instance, String fieldName) throws Exception {
        return instance.getClass().getField(fieldName).get(instance);
    }

    public static boolean isClassPresent(String fullyQualifiedClassName) {
        try {
            Class.forName(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean parseBoolean(String value, boolean defaultValue, boolean throwException) {
        if (value == null) {
            return defaultValue;
        }
        switch (value.length()) {
            case 1: {
                if (value.equals("1") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("y")) {
                    return true;
                }
                if (!value.equals("0") && !value.equalsIgnoreCase("f") && !value.equalsIgnoreCase("n")) break;
                return false;
            }
            case 2: {
                if (!value.equalsIgnoreCase("no")) break;
                return false;
            }
            case 3: {
                if (!value.equalsIgnoreCase("yes")) break;
                return true;
            }
            case 4: {
                if (!value.equalsIgnoreCase("true")) break;
                return true;
            }
            case 5: {
                if (!value.equalsIgnoreCase("false")) break;
                return false;
            }
        }
        if (throwException) {
            throw new IllegalArgumentException(value);
        }
        return defaultValue;
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    public static int getProperty(String key, int defaultValue) {
        String s2 = Utils.getProperty(key, null);
        if (s2 != null) {
            try {
                return Integer.decode(s2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(Utils.getProperty(key, null), defaultValue, false);
    }

    public static int scaleForAvailableMemory(int value) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory != Long.MAX_VALUE) {
            return (int)((long)value * maxMemory / 0x40000000L);
        }
        try {
            OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getTotalPhysicalMemorySize", new Class[0]);
            long physicalMemorySize = ((Number)method.invoke((Object)mxBean, new Object[0])).longValue();
            return (int)((long)value * physicalMemorySize / 0x40000000L);
        }
        catch (Exception exception) {
            return value;
        }
    }

    static {
        RESOURCES = new HashMap();
    }

    public static interface ClassFactory {
        public boolean match(String var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

