/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import org.gridgain.internal.h2.api.CustomDataTypesHandler;
import org.gridgain.internal.h2.api.JavaObjectSerializer;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class JdbcUtils {
    public static JavaObjectSerializer serializer;
    public static CustomDataTypesHandler customDataTypesHandler;
    private static final String[] DRIVERS;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static ArrayList<Utils.ClassFactory> userClassFactories;
    private static String[] allowedClassNamePrefixes;

    private JdbcUtils() {
    }

    public static void addClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().add(classFactory);
    }

    public static void removeClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().remove(classFactory);
    }

    private static ArrayList<Utils.ClassFactory> getUserClassFactories() {
        if (userClassFactories == null) {
            userClassFactories = new ArrayList();
        }
        return userClassFactories;
    }

    public static <Z> Class<Z> loadUserClass(String className) {
        if (allowedClassNames == null) {
            String s2 = SysProperties.ALLOWED_CLASSES;
            String[] prefixes = new ArrayList();
            int allowAll = 0;
            HashSet<String> classNames = new HashSet<String>();
            for (String p : StringUtils.arraySplit(s2, ',', true)) {
                if (p.equals("*")) {
                    allowAll = 1;
                    continue;
                }
                if (p.endsWith("*")) {
                    prefixes.add(p.substring(0, p.length() - 1));
                    continue;
                }
                classNames.add(p);
            }
            allowedClassNamePrefixes = prefixes.toArray(new String[0]);
            allowAllClasses = allowAll;
            allowedClassNames = classNames;
        }
        if (!allowAllClasses && !allowedClassNames.contains(className)) {
            boolean allowed = false;
            for (String s3 : allowedClassNamePrefixes) {
                if (!className.startsWith(s3)) continue;
                allowed = true;
            }
            if (!allowed) {
                throw DbException.get(90134, className);
            }
        }
        for (Utils.ClassFactory classFactory : JdbcUtils.getUserClassFactories()) {
            if (!classFactory.match(className)) continue;
            try {
                Class<?> userClass = classFactory.loadClass(className);
                if (userClass == null) continue;
                return userClass;
            }
            catch (Exception e) {
                throw DbException.get(90086, e, className);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e2) {
                throw DbException.get(90086, e, className);
            }
        }
        catch (NoClassDefFoundError e) {
            throw DbException.get(90086, e, className);
        }
        catch (Error e) {
            throw DbException.get(50000, e, className);
        }
    }

    public static void closeSilently(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String driver, String url, String user, String password) throws SQLException {
        Properties prop = new Properties();
        if (user != null) {
            prop.setProperty("user", user);
        }
        if (password != null) {
            prop.setProperty("password", password);
        }
        return JdbcUtils.getConnection(driver, url, prop);
    }

    public static Connection getConnection(String driver, String url, Properties prop) throws SQLException {
        if (StringUtils.isNullOrEmpty(driver)) {
            JdbcUtils.load(url);
        } else {
            Class d = JdbcUtils.loadUserClass(driver);
            try {
                if (Driver.class.isAssignableFrom(d)) {
                    Driver driverInstance = (Driver)d.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Connection connection = driverInstance.connect(url, prop);
                    if (connection != null) {
                        return connection;
                    }
                    throw new SQLException("Driver " + driver + " is not suitable for " + url, "08001");
                }
                if (Context.class.isAssignableFrom(d)) {
                    Context context = (Context)d.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DataSource ds = (DataSource)context.lookup(url);
                    String user = prop.getProperty("user");
                    String password = prop.getProperty("password");
                    if (StringUtils.isNullOrEmpty(user) && StringUtils.isNullOrEmpty(password)) {
                        return ds.getConnection();
                    }
                    return ds.getConnection(user, password);
                }
            }
            catch (Exception e) {
                throw DbException.toSQLException(e);
            }
        }
        return DriverManager.getConnection(url, prop);
    }

    public static String getDriver(String url) {
        if (url.startsWith("jdbc:")) {
            url = url.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String prefix = DRIVERS[i];
                if (!url.startsWith(prefix)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String url) {
        String driver = JdbcUtils.getDriver(url);
        if (driver != null) {
            JdbcUtils.loadUserClass(driver);
        }
    }

    public static byte[] serialize(Object obj, DataHandler dataHandler) {
        try {
            JavaObjectSerializer handlerSerializer = null;
            if (dataHandler != null) {
                handlerSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (handlerSerializer != null) {
                return handlerSerializer.serialize(obj);
            }
            if (serializer != null) {
                return serializer.serialize(obj);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw DbException.get(90026, e, e.toString());
        }
    }

    public static Object deserialize(byte[] data, DataHandler dataHandler) {
        try {
            ObjectInputStream is;
            JavaObjectSerializer dbJavaObjectSerializer = null;
            if (dataHandler != null) {
                dbJavaObjectSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (dbJavaObjectSerializer != null) {
                return dbJavaObjectSerializer.deserialize(data);
            }
            if (serializer != null) {
                return serializer.deserialize(data);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                is = new ObjectInputStream(in){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(desc.getName(), true, loader);
                        }
                        catch (ClassNotFoundException e) {
                            return super.resolveClass(desc);
                        }
                    }
                };
            } else {
                is = new ObjectInputStream(in);
            }
            return is.readObject();
        }
        catch (Throwable e) {
            throw DbException.get(90027, e, e.toString());
        }
    }

    static {
        String customTypeHandlerClass;
        DRIVERS = new String[]{"gg-h2:", "org.gridgain.internal.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "com.ibm.db2.jcc.DB2Driver", "derby:net:", "org.apache.derby.jdbc.ClientDriver", "derby://", "org.apache.derby.jdbc.ClientDriver", "derby:", "org.apache.derby.jdbc.EmbeddedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};
        userClassFactories = new ArrayList();
        String clazz = SysProperties.JAVA_OBJECT_SERIALIZER;
        if (clazz != null) {
            try {
                serializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
        }
        if ((customTypeHandlerClass = SysProperties.CUSTOM_DATA_TYPES_HANDLER) != null) {
            try {
                customDataTypesHandler = (CustomDataTypesHandler)JdbcUtils.loadUserClass(customTypeHandlerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
        }
    }
}

