/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.math.BigInteger;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.ValueInterval;

public class IntervalUtils {
    private static final BigInteger NANOS_PER_SECOND_BI = BigInteger.valueOf(1000000000L);
    private static final BigInteger NANOS_PER_MINUTE_BI = BigInteger.valueOf(60000000000L);
    private static final BigInteger NANOS_PER_HOUR_BI = BigInteger.valueOf(3600000000000L);
    public static final BigInteger NANOS_PER_DAY_BI = BigInteger.valueOf(86400000000000L);
    private static final BigInteger MONTHS_PER_YEAR_BI = BigInteger.valueOf(12L);
    private static final BigInteger HOURS_PER_DAY_BI = BigInteger.valueOf(24L);
    private static final BigInteger MINUTES_PER_DAY_BI = BigInteger.valueOf(1440L);
    private static final BigInteger MINUTES_PER_HOUR_BI = BigInteger.valueOf(60L);
    private static final BigInteger LEADING_MIN = BigInteger.valueOf(-999999999999999999L);
    private static final BigInteger LEADING_MAX = BigInteger.valueOf(999999999999999999L);

    private IntervalUtils() {
    }

    public static ValueInterval parseFormattedInterval(IntervalQualifier qualifier, String s2) {
        int j;
        int i = 0;
        if (!s2.regionMatches(true, i = IntervalUtils.skipWS(s2, i), "INTERVAL", 0, 8)) {
            return IntervalUtils.parseInterval(qualifier, false, s2);
        }
        i = IntervalUtils.skipWS(s2, i + 8);
        boolean negative = false;
        char ch = s2.charAt(i);
        if (ch == '-') {
            negative = true;
            i = IntervalUtils.skipWS(s2, i + 1);
            ch = s2.charAt(i);
        } else if (ch == '+') {
            i = IntervalUtils.skipWS(s2, i + 1);
            ch = s2.charAt(i);
        }
        if (ch != '\'') {
            throw new IllegalArgumentException(s2);
        }
        int start = ++i;
        int l = s2.length();
        while (true) {
            if (i == l) {
                throw new IllegalArgumentException(s2);
            }
            if (s2.charAt(i) == '\'') break;
            ++i;
        }
        String v = s2.substring(start, i);
        i = IntervalUtils.skipWS(s2, i + 1);
        if (s2.regionMatches(true, i, "YEAR", 0, 4)) {
            j = IntervalUtils.skipWSEnd(s2, i += 4);
            if (j == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.YEAR, negative, v);
            }
            if (j > i && s2.regionMatches(true, j, "TO", 0, 2) && (i = IntervalUtils.skipWS(s2, j += 2)) > j && s2.regionMatches(true, i, "MONTH", 0, 5) && IntervalUtils.skipWSEnd(s2, i + 5) == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.YEAR_TO_MONTH, negative, v);
            }
        } else if (s2.regionMatches(true, i, "MONTH", 0, 5) && IntervalUtils.skipWSEnd(s2, i + 5) == l) {
            return IntervalUtils.parseInterval(IntervalQualifier.MONTH, negative, v);
        }
        if (s2.regionMatches(true, i, "DAY", 0, 3)) {
            j = IntervalUtils.skipWSEnd(s2, i += 3);
            if (j == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.DAY, negative, v);
            }
            if (j > i && s2.regionMatches(true, j, "TO", 0, 2) && (i = IntervalUtils.skipWS(s2, j += 2)) > j) {
                if (s2.regionMatches(true, i, "HOUR", 0, 4)) {
                    if (IntervalUtils.skipWSEnd(s2, i + 4) == l) {
                        return IntervalUtils.parseInterval(IntervalQualifier.DAY_TO_HOUR, negative, v);
                    }
                } else if (s2.regionMatches(true, i, "MINUTE", 0, 6)) {
                    if (IntervalUtils.skipWSEnd(s2, i + 6) == l) {
                        return IntervalUtils.parseInterval(IntervalQualifier.DAY_TO_MINUTE, negative, v);
                    }
                } else if (s2.regionMatches(true, i, "SECOND", 0, 6) && IntervalUtils.skipWSEnd(s2, i + 6) == l) {
                    return IntervalUtils.parseInterval(IntervalQualifier.DAY_TO_SECOND, negative, v);
                }
            }
        }
        if (s2.regionMatches(true, i, "HOUR", 0, 4)) {
            j = IntervalUtils.skipWSEnd(s2, i += 4);
            if (j == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.HOUR, negative, v);
            }
            if (j > i && s2.regionMatches(true, j, "TO", 0, 2) && (i = IntervalUtils.skipWS(s2, j += 2)) > j) {
                if (s2.regionMatches(true, i, "MINUTE", 0, 6)) {
                    if (IntervalUtils.skipWSEnd(s2, i + 6) == l) {
                        return IntervalUtils.parseInterval(IntervalQualifier.HOUR_TO_MINUTE, negative, v);
                    }
                } else if (s2.regionMatches(true, i, "SECOND", 0, 6) && IntervalUtils.skipWSEnd(s2, i + 6) == l) {
                    return IntervalUtils.parseInterval(IntervalQualifier.HOUR_TO_SECOND, negative, v);
                }
            }
        }
        if (s2.regionMatches(true, i, "MINUTE", 0, 6)) {
            j = IntervalUtils.skipWSEnd(s2, i += 6);
            if (j == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.MINUTE, negative, v);
            }
            if (j > i && s2.regionMatches(true, j, "TO", 0, 2) && (i = IntervalUtils.skipWS(s2, j += 2)) > j && s2.regionMatches(true, i, "SECOND", 0, 6) && IntervalUtils.skipWSEnd(s2, i + 6) == l) {
                return IntervalUtils.parseInterval(IntervalQualifier.MINUTE_TO_SECOND, negative, v);
            }
        }
        if (s2.regionMatches(true, i, "SECOND", 0, 6) && IntervalUtils.skipWSEnd(s2, i + 6) == l) {
            return IntervalUtils.parseInterval(IntervalQualifier.SECOND, negative, v);
        }
        throw new IllegalArgumentException(s2);
    }

    private static int skipWS(String s2, int i) {
        int l = s2.length();
        while (true) {
            if (i == l) {
                throw new IllegalArgumentException(s2);
            }
            if (!Character.isWhitespace(s2.charAt(i))) {
                return i;
            }
            ++i;
        }
    }

    private static int skipWSEnd(String s2, int i) {
        int l = s2.length();
        while (i != l) {
            if (!Character.isWhitespace(s2.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static ValueInterval parseInterval(IntervalQualifier qualifier, boolean negative, String s2) {
        long remaining;
        long leading;
        switch (qualifier) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: {
                leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                remaining = 0L;
                break;
            }
            case SECOND: {
                int dot = s2.indexOf(46);
                if (dot < 0) {
                    leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                    remaining = 0L;
                    break;
                }
                leading = IntervalUtils.parseIntervalLeading(s2, 0, dot, negative);
                remaining = DateTimeUtils.parseNanos(s2, dot + 1, s2.length());
                break;
            }
            case YEAR_TO_MONTH: {
                return IntervalUtils.parseInterval2(qualifier, s2, '-', 11, negative);
            }
            case DAY_TO_HOUR: {
                return IntervalUtils.parseInterval2(qualifier, s2, ' ', 23, negative);
            }
            case DAY_TO_MINUTE: {
                int space = s2.indexOf(32);
                if (space < 0) {
                    leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                    remaining = 0L;
                    break;
                }
                leading = IntervalUtils.parseIntervalLeading(s2, 0, space, negative);
                int colon = s2.indexOf(58, space + 1);
                if (colon < 0) {
                    remaining = IntervalUtils.parseIntervalRemaining(s2, space + 1, s2.length(), 23) * 60L;
                    break;
                }
                remaining = IntervalUtils.parseIntervalRemaining(s2, space + 1, colon, 23) * 60L + IntervalUtils.parseIntervalRemaining(s2, colon + 1, s2.length(), 59);
                break;
            }
            case DAY_TO_SECOND: {
                int space = s2.indexOf(32);
                if (space < 0) {
                    leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                    remaining = 0L;
                    break;
                }
                leading = IntervalUtils.parseIntervalLeading(s2, 0, space, negative);
                int colon = s2.indexOf(58, space + 1);
                if (colon < 0) {
                    remaining = IntervalUtils.parseIntervalRemaining(s2, space + 1, s2.length(), 23) * 3600000000000L;
                    break;
                }
                int colon2 = s2.indexOf(58, colon + 1);
                if (colon2 < 0) {
                    remaining = IntervalUtils.parseIntervalRemaining(s2, space + 1, colon, 23) * 3600000000000L + IntervalUtils.parseIntervalRemaining(s2, colon + 1, s2.length(), 59) * 60000000000L;
                    break;
                }
                remaining = IntervalUtils.parseIntervalRemaining(s2, space + 1, colon, 23) * 3600000000000L + IntervalUtils.parseIntervalRemaining(s2, colon + 1, colon2, 59) * 60000000000L + IntervalUtils.parseIntervalRemainingSeconds(s2, colon2 + 1);
                break;
            }
            case HOUR_TO_MINUTE: {
                return IntervalUtils.parseInterval2(qualifier, s2, ':', 59, negative);
            }
            case HOUR_TO_SECOND: {
                int colon = s2.indexOf(58);
                if (colon < 0) {
                    leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                    remaining = 0L;
                    break;
                }
                leading = IntervalUtils.parseIntervalLeading(s2, 0, colon, negative);
                int colon2 = s2.indexOf(58, colon + 1);
                if (colon2 < 0) {
                    remaining = IntervalUtils.parseIntervalRemaining(s2, colon + 1, s2.length(), 59) * 60000000000L;
                    break;
                }
                remaining = IntervalUtils.parseIntervalRemaining(s2, colon + 1, colon2, 59) * 60000000000L + IntervalUtils.parseIntervalRemainingSeconds(s2, colon2 + 1);
                break;
            }
            case MINUTE_TO_SECOND: {
                int dash = s2.indexOf(58);
                if (dash < 0) {
                    leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
                    remaining = 0L;
                    break;
                }
                leading = IntervalUtils.parseIntervalLeading(s2, 0, dash, negative);
                remaining = IntervalUtils.parseIntervalRemainingSeconds(s2, dash + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        boolean bl = negative = leading < 0L;
        if (negative) {
            leading = leading != Long.MIN_VALUE ? -leading : 0L;
        }
        return ValueInterval.from(qualifier, negative, leading, remaining);
    }

    private static ValueInterval parseInterval2(IntervalQualifier qualifier, String s2, char ch, int max, boolean negative) {
        long remaining;
        long leading;
        int dash = s2.indexOf(ch, 1);
        if (dash < 0) {
            leading = IntervalUtils.parseIntervalLeading(s2, 0, s2.length(), negative);
            remaining = 0L;
        } else {
            leading = IntervalUtils.parseIntervalLeading(s2, 0, dash, negative);
            remaining = IntervalUtils.parseIntervalRemaining(s2, dash + 1, s2.length(), max);
        }
        boolean bl = negative = leading < 0L;
        if (negative) {
            leading = leading != Long.MIN_VALUE ? -leading : 0L;
        }
        return ValueInterval.from(qualifier, negative, leading, remaining);
    }

    private static long parseIntervalLeading(String s2, int start, int end, boolean negative) {
        long leading = Long.parseLong(s2.substring(start, end));
        if (leading == 0L) {
            return negative ^ s2.charAt(start) == '-' ? Long.MIN_VALUE : 0L;
        }
        return negative ? -leading : leading;
    }

    private static long parseIntervalRemaining(String s2, int start, int end, int max) {
        int v = StringUtils.parseUInt31(s2, start, end);
        if (v > max) {
            throw new IllegalArgumentException(s2);
        }
        return v;
    }

    private static long parseIntervalRemainingSeconds(String s2, int start) {
        int nanos;
        int seconds;
        int dot = s2.indexOf(46, start + 1);
        if (dot < 0) {
            seconds = StringUtils.parseUInt31(s2, start, s2.length());
            nanos = 0;
        } else {
            seconds = StringUtils.parseUInt31(s2, start, dot);
            nanos = DateTimeUtils.parseNanos(s2, dot + 1, s2.length());
        }
        if (seconds > 59) {
            throw new IllegalArgumentException(s2);
        }
        return (long)seconds * 1000000000L + (long)nanos;
    }

    public static StringBuilder appendInterval(StringBuilder buff, IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        buff.append("INTERVAL '");
        if (negative) {
            buff.append('-');
        }
        switch (qualifier) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: {
                buff.append(leading);
                break;
            }
            case SECOND: {
                buff.append(leading);
                IntervalUtils.appendNanos(buff, remaining);
                break;
            }
            case YEAR_TO_MONTH: {
                buff.append(leading).append('-').append(remaining);
                break;
            }
            case DAY_TO_HOUR: {
                buff.append(leading).append(' ');
                StringUtils.appendZeroPadded(buff, 2, remaining);
                break;
            }
            case DAY_TO_MINUTE: {
                buff.append(leading).append(' ');
                StringUtils.appendZeroPadded(buff, 2, remaining / 60L);
                buff.append(':');
                StringUtils.appendZeroPadded(buff, 2, remaining % 60L);
                break;
            }
            case DAY_TO_SECOND: {
                long nanos = remaining % 60000000000L;
                buff.append(leading).append(' ');
                StringUtils.appendZeroPadded(buff, 2, (remaining /= 60000000000L) / 60L);
                buff.append(':');
                StringUtils.appendZeroPadded(buff, 2, remaining % 60L);
                buff.append(':');
                IntervalUtils.appendSecondsWithNanos(buff, nanos);
                break;
            }
            case HOUR_TO_MINUTE: {
                buff.append(leading).append(':');
                StringUtils.appendZeroPadded(buff, 2, remaining);
                break;
            }
            case HOUR_TO_SECOND: {
                buff.append(leading).append(':');
                StringUtils.appendZeroPadded(buff, 2, remaining / 60000000000L);
                buff.append(':');
                IntervalUtils.appendSecondsWithNanos(buff, remaining % 60000000000L);
                break;
            }
            case MINUTE_TO_SECOND: {
                buff.append(leading).append(':');
                IntervalUtils.appendSecondsWithNanos(buff, remaining);
            }
        }
        return buff.append("' ").append((Object)qualifier);
    }

    private static void appendSecondsWithNanos(StringBuilder buff, long nanos) {
        StringUtils.appendZeroPadded(buff, 2, nanos / 1000000000L);
        IntervalUtils.appendNanos(buff, nanos % 1000000000L);
    }

    private static void appendNanos(StringBuilder buff, long nanos) {
        if (nanos > 0L) {
            buff.append('.');
            StringUtils.appendZeroPadded(buff, 9, nanos);
            DateTimeUtils.stripTrailingZeroes(buff);
        }
    }

    public static BigInteger intervalToAbsolute(ValueInterval interval) {
        BigInteger r;
        switch (interval.getQualifier()) {
            case YEAR: {
                r = BigInteger.valueOf(interval.getLeading()).multiply(MONTHS_PER_YEAR_BI);
                break;
            }
            case MONTH: {
                r = BigInteger.valueOf(interval.getLeading());
                break;
            }
            case DAY: {
                r = BigInteger.valueOf(interval.getLeading()).multiply(NANOS_PER_DAY_BI);
                break;
            }
            case HOUR: {
                r = BigInteger.valueOf(interval.getLeading()).multiply(NANOS_PER_HOUR_BI);
                break;
            }
            case MINUTE: {
                r = BigInteger.valueOf(interval.getLeading()).multiply(NANOS_PER_MINUTE_BI);
                break;
            }
            case SECOND: {
                r = IntervalUtils.intervalToAbsolute(interval, NANOS_PER_SECOND_BI);
                break;
            }
            case YEAR_TO_MONTH: {
                r = IntervalUtils.intervalToAbsolute(interval, MONTHS_PER_YEAR_BI);
                break;
            }
            case DAY_TO_HOUR: {
                r = IntervalUtils.intervalToAbsolute(interval, HOURS_PER_DAY_BI, NANOS_PER_HOUR_BI);
                break;
            }
            case DAY_TO_MINUTE: {
                r = IntervalUtils.intervalToAbsolute(interval, MINUTES_PER_DAY_BI, NANOS_PER_MINUTE_BI);
                break;
            }
            case DAY_TO_SECOND: {
                r = IntervalUtils.intervalToAbsolute(interval, NANOS_PER_DAY_BI);
                break;
            }
            case HOUR_TO_MINUTE: {
                r = IntervalUtils.intervalToAbsolute(interval, MINUTES_PER_HOUR_BI, NANOS_PER_MINUTE_BI);
                break;
            }
            case HOUR_TO_SECOND: {
                r = IntervalUtils.intervalToAbsolute(interval, NANOS_PER_HOUR_BI);
                break;
            }
            case MINUTE_TO_SECOND: {
                r = IntervalUtils.intervalToAbsolute(interval, NANOS_PER_MINUTE_BI);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return interval.isNegative() ? r.negate() : r;
    }

    private static BigInteger intervalToAbsolute(ValueInterval interval, BigInteger multiplier, BigInteger totalMultiplier) {
        return IntervalUtils.intervalToAbsolute(interval, multiplier).multiply(totalMultiplier);
    }

    private static BigInteger intervalToAbsolute(ValueInterval interval, BigInteger multiplier) {
        return BigInteger.valueOf(interval.getLeading()).multiply(multiplier).add(BigInteger.valueOf(interval.getRemaining()));
    }

    public static ValueInterval intervalFromAbsolute(IntervalQualifier qualifier, BigInteger absolute) {
        switch (qualifier) {
            case YEAR: {
                return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(absolute.divide(MONTHS_PER_YEAR_BI)), 0L);
            }
            case MONTH: {
                return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(absolute), 0L);
            }
            case DAY: {
                return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(absolute.divide(NANOS_PER_DAY_BI)), 0L);
            }
            case HOUR: {
                return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(absolute.divide(NANOS_PER_HOUR_BI)), 0L);
            }
            case MINUTE: {
                return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(absolute.divide(NANOS_PER_MINUTE_BI)), 0L);
            }
            case SECOND: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute, NANOS_PER_SECOND_BI);
            }
            case YEAR_TO_MONTH: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute, MONTHS_PER_YEAR_BI);
            }
            case DAY_TO_HOUR: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute.divide(NANOS_PER_HOUR_BI), HOURS_PER_DAY_BI);
            }
            case DAY_TO_MINUTE: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute.divide(NANOS_PER_MINUTE_BI), MINUTES_PER_DAY_BI);
            }
            case DAY_TO_SECOND: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute, NANOS_PER_DAY_BI);
            }
            case HOUR_TO_MINUTE: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute.divide(NANOS_PER_MINUTE_BI), MINUTES_PER_HOUR_BI);
            }
            case HOUR_TO_SECOND: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute, NANOS_PER_HOUR_BI);
            }
            case MINUTE_TO_SECOND: {
                return IntervalUtils.intervalFromAbsolute(qualifier, absolute, NANOS_PER_MINUTE_BI);
            }
        }
        throw new IllegalArgumentException();
    }

    private static ValueInterval intervalFromAbsolute(IntervalQualifier qualifier, BigInteger absolute, BigInteger divisor) {
        BigInteger[] dr = absolute.divideAndRemainder(divisor);
        return ValueInterval.from(qualifier, absolute.signum() < 0, IntervalUtils.leadingExact(dr[0]), Math.abs(dr[1].longValue()));
    }

    private static long leadingExact(BigInteger absolute) {
        if (absolute.compareTo(LEADING_MAX) > 0 || absolute.compareTo(LEADING_MIN) < 0) {
            throw DbException.get(22003, absolute.toString());
        }
        return Math.abs(absolute.longValue());
    }

    public static boolean validateInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        long bound;
        if (qualifier == null) {
            throw new NullPointerException();
        }
        if (leading == 0L && remaining == 0L) {
            return false;
        }
        switch (qualifier) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: {
                bound = 1L;
                break;
            }
            case SECOND: {
                bound = 1000000000L;
                break;
            }
            case YEAR_TO_MONTH: {
                bound = 12L;
                break;
            }
            case DAY_TO_HOUR: {
                bound = 24L;
                break;
            }
            case DAY_TO_MINUTE: {
                bound = 1440L;
                break;
            }
            case DAY_TO_SECOND: {
                bound = 86400000000000L;
                break;
            }
            case HOUR_TO_MINUTE: {
                bound = 60L;
                break;
            }
            case HOUR_TO_SECOND: {
                bound = 3600000000000L;
                break;
            }
            case MINUTE_TO_SECOND: {
                bound = 60000000000L;
                break;
            }
            default: {
                throw DbException.getInvalidValueException("interval", (Object)qualifier);
            }
        }
        if (leading < 0L || leading >= 1000000000000000000L) {
            throw DbException.getInvalidValueException("interval", Long.toString(leading));
        }
        if (remaining < 0L || remaining >= bound) {
            throw DbException.getInvalidValueException("interval", Long.toString(remaining));
        }
        return negative;
    }

    public static long yearsFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        if (qualifier == IntervalQualifier.YEAR || qualifier == IntervalQualifier.YEAR_TO_MONTH) {
            long v = leading;
            if (negative) {
                v = -v;
            }
            return v;
        }
        return 0L;
    }

    public static long monthsFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        long v;
        if (qualifier == IntervalQualifier.MONTH) {
            v = leading;
        } else if (qualifier == IntervalQualifier.YEAR_TO_MONTH) {
            v = remaining;
        } else {
            return 0L;
        }
        if (negative) {
            v = -v;
        }
        return v;
    }

    public static long daysFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        switch (qualifier) {
            case DAY: 
            case DAY_TO_HOUR: 
            case DAY_TO_MINUTE: 
            case DAY_TO_SECOND: {
                long v = leading;
                if (negative) {
                    v = -v;
                }
                return v;
            }
        }
        return 0L;
    }

    public static long hoursFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        long v;
        switch (qualifier) {
            case HOUR: 
            case HOUR_TO_MINUTE: 
            case HOUR_TO_SECOND: {
                v = leading;
                break;
            }
            case DAY_TO_HOUR: {
                v = remaining;
                break;
            }
            case DAY_TO_MINUTE: {
                v = remaining / 60L;
                break;
            }
            case DAY_TO_SECOND: {
                v = remaining / 3600000000000L;
                break;
            }
            default: {
                return 0L;
            }
        }
        if (negative) {
            v = -v;
        }
        return v;
    }

    public static long minutesFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        long v;
        switch (qualifier) {
            case MINUTE: 
            case MINUTE_TO_SECOND: {
                v = leading;
                break;
            }
            case DAY_TO_MINUTE: {
                v = remaining % 60L;
                break;
            }
            case DAY_TO_SECOND: {
                v = remaining / 60000000000L % 60L;
                break;
            }
            case HOUR_TO_MINUTE: {
                v = remaining;
                break;
            }
            case HOUR_TO_SECOND: {
                v = remaining / 60000000000L;
                break;
            }
            default: {
                return 0L;
            }
        }
        if (negative) {
            v = -v;
        }
        return v;
    }

    public static long nanosFromInterval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        long v;
        switch (qualifier) {
            case SECOND: {
                v = leading * 1000000000L + remaining;
                break;
            }
            case DAY_TO_SECOND: 
            case HOUR_TO_SECOND: {
                v = remaining % 60000000000L;
                break;
            }
            case MINUTE_TO_SECOND: {
                v = remaining;
                break;
            }
            default: {
                return 0L;
            }
        }
        if (negative) {
            v = -v;
        }
        return v;
    }
}

