/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.HashIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.NonUniqueHashIndex;
import org.gridgain.internal.h2.index.PageBtreeIndex;
import org.gridgain.internal.h2.index.PageDataIndex;
import org.gridgain.internal.h2.index.PageDelegateIndex;
import org.gridgain.internal.h2.index.ScanIndex;
import org.gridgain.internal.h2.index.SpatialTreeIndex;
import org.gridgain.internal.h2.index.TreeIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.RegularTable;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;

public class PageStoreTable
extends RegularTable {
    private Index scanIndex;
    private long rowCount;
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private long lastModificationId;
    private final PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;

    public PageStoreTable(CreateTableData data) {
        super(data);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        if (data.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, data.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(data.persistData), data.create, data.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.mainIndex = null;
            this.scanIndex = new ScanIndex(this, data.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(data.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace(7);
    }

    @Override
    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.scanIndex.getRow(session, key);
    }

    @Override
    public void addRow(Session session, Row row) {
        int i;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            int size = this.indexes.size();
            for (i = 0; i < size; ++i) {
                Index index = this.indexes.get(i);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable e) {
            try {
                while (--i >= 0) {
                    Index index = this.indexes.get(i);
                    index.remove(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not undo operation");
                throw e2;
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    private void checkRowCount(Session session, Index index, int offset) {
        long rc;
        if (SysProperties.CHECK && !(index instanceof PageDelegateIndex) && (rc = index.getRowCount(session)) != this.rowCount + (long)offset) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)offset) + " got " + rc + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index idx : this.indexes) {
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        BaseIndex index;
        boolean isSessionTemporary;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn c : cols) {
                Column column = c.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int mainIndexColumn = this.database.isStarting() && this.database.getPageStore().getRootPageId(indexId) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L || this.mainIndex.getMainIndexColumn() != -1 ? -1 : PageStoreTable.getMainIndexColumn(indexType, cols));
            if (mainIndexColumn != -1) {
                this.mainIndex.setMainIndexColumn(mainIndexColumn);
                index = new PageDelegateIndex(this, indexId, indexName, indexType, this.mainIndex, create, session);
            } else {
                index = indexType.isSpatial() ? new SpatialTreeIndex(this, indexId, indexName, cols, indexType, true, create, session) : new PageBtreeIndex(this, indexId, indexName, cols, indexType, create, session);
            }
        } else if (indexType.isHash()) {
            if (cols.length != 1) {
                throw DbException.getUnsupportedException("hash indexes may index only one column");
            }
            index = indexType.isUnique() ? new HashIndex(this, indexId, indexName, cols, indexType) : new NonUniqueHashIndex(this, indexId, indexName, cols, indexType);
        } else {
            index = indexType.isSpatial() ? new SpatialTreeIndex(this, indexId, indexName, cols, indexType, false, true, session) : new TreeIndex(this, indexId, indexName, cols, indexType);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long remaining;
                Index scan = this.getScanIndex(session);
                long total = remaining = scan.getRowCount(session);
                Cursor cursor = scan.find(session, null, null);
                long i = 0L;
                int bufferSize = (int)Math.min(this.rowCount, (long)this.database.getMaxMemoryRows());
                ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
                String n = this.getName() + ":" + index.getName();
                int t2 = MathUtils.convertLongToInt(total);
                while (cursor.next()) {
                    this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t2);
                    Row row = cursor.get();
                    buffer.add(row);
                    if (buffer.size() >= bufferSize) {
                        PageStoreTable.addRowsToIndex(session, buffer, index);
                    }
                    --remaining;
                }
                PageStoreTable.addRowsToIndex(session, buffer, index);
                if (remaining != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
                }
            }
            catch (DbException e) {
                this.getSchema().freeUniqueName(indexName);
                try {
                    index.remove(session);
                }
                catch (DbException e2) {
                    this.trace.error(e2, "could not remove index");
                    throw e2;
                }
                throw e;
            }
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row) {
        int i;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable e) {
            try {
                while (++i < this.indexes.size()) {
                    Index index = this.indexes.get(i);
                    index.add(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not undo operation");
                throw e2;
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        session.markTableForAnalyze(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        int lockMode = this.database.getLockMode();
        if (lockMode == 0) {
            return this.lockExclusiveSession != null;
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (!exclusive && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        Database database = this.database;
        synchronized (database) {
            if (!exclusive && this.lockSharedSessions.contains(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, lockMode, exclusive);
            }
            finally {
                session.setWaitForLock(null, null);
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private void doLock1(Session session, int lockMode, boolean exclusive) {
        this.traceLock(session, exclusive, "requesting for");
        long max = 0L;
        boolean checkDeadlock = false;
        while (this.waitingSessions.getFirst() != session || !this.doLock2(session, lockMode, exclusive)) {
            if (checkDeadlock) {
                ArrayList<Session> sessions = this.checkDeadlock(session, null, null);
                if (sessions != null) {
                    throw DbException.get(40001, PageStoreTable.getDeadlockDetails(sessions, exclusive));
                }
            } else {
                checkDeadlock = true;
            }
            long now = System.nanoTime();
            if (max == 0L) {
                max = now + TimeUnit.MILLISECONDS.toNanos(session.getLockTimeout());
            } else if (now >= max) {
                this.traceLock(session, exclusive, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long sleep;
                this.traceLock(session, exclusive, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long free = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long free2 = Runtime.getRuntime().freeMemory();
                        if (free == free2) break;
                    }
                }
                if ((sleep = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(max - now))) == 0L) {
                    sleep = 1L;
                }
                this.database.wait(sleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session, int lockMode, boolean exclusive) {
        if (exclusive) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session, exclusive, "added for");
                    session.addLock(this);
                    this.lockExclusiveSession = session;
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, exclusive, "add (upgraded) for ");
                    this.lockExclusiveSession = session;
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (lockMode == 3 && !this.database.isMultiThreaded()) {
                return true;
            }
            if (!this.lockSharedSessions.containsKey(session)) {
                this.traceLock(session, exclusive, "ok");
                session.addLock(this);
                this.lockSharedSessions.put(session, session);
            }
            return true;
        }
        return false;
    }

    private void traceLock(Session session, boolean exclusive, String s2) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session.getId(), exclusive ? "exclusive write lock" : "shared read lock", s2, this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session s2) {
        if (this.database != null) {
            this.traceLock(s2, this.lockExclusiveSession == s2, "unlock");
            if (this.lockExclusiveSession == s2) {
                this.lockSharedSessions.remove(s2);
                this.lockExclusiveSession = null;
            }
            Database database = this.database;
            synchronized (database) {
                if (!this.lockSharedSessions.isEmpty()) {
                    this.lockSharedSessions.remove(s2);
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public void setRowCount(long count) {
        this.rowCount = count;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)obj;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusiveSession = null;
        this.lockSharedSessions.clear();
        this.invalidate();
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.scanIndex.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.scanIndex.getDiskSpaceUsed();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }
}

