/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;

public class IndexColumn {
    public String columnName;
    public Column column;
    public int sortType = 0;

    public static StringBuilder writeColumns(StringBuilder builder, IndexColumn[] columns, boolean alwaysQuote) {
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            columns[i].getSQL(builder, alwaysQuote);
        }
        return builder;
    }

    public static StringBuilder writeColumns(StringBuilder builder, IndexColumn[] columns, String separator, String suffix, boolean alwaysQuote) {
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            columns[i].getSQL(builder, alwaysQuote).append(suffix);
        }
        return builder;
    }

    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        SortOrder.typeToString(this.column.getSQL(builder, alwaysQuote), this.sortType);
        return builder;
    }

    public static IndexColumn[] wrap(Column[] columns) {
        IndexColumn[] list = new IndexColumn[columns.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new IndexColumn();
            list[i].column = columns[i];
        }
        return list;
    }

    public static void mapColumns(IndexColumn[] indexColumns, Table table) {
        for (IndexColumn col : indexColumns) {
            col.column = table.getColumn(col.columnName);
        }
    }

    public String toString() {
        return this.getSQL(new StringBuilder("IndexColumn "), false).toString();
    }
}

