/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.StreamStore;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.store.CountingReaderInputStream;
import org.gridgain.internal.h2.store.LobStorageInterface;
import org.gridgain.internal.h2.store.RangeInputStream;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLobDb;

public class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    private boolean init;
    private final Object nextLobIdSync = new Object();
    private long nextLobId;
    private MVMap<Long, Object[]> lobMap;
    private MVMap<Object[], Boolean> refMap;
    private StreamStore streamStore;

    public LobStorageMap(Database database) {
        this.database = database;
    }

    @Override
    public void init() {
        Long last;
        if (this.init) {
            return;
        }
        this.init = true;
        MVTableEngine.Store s2 = this.database.getStore();
        MVStore mvStore = s2 == null ? MVStore.open(null) : s2.getMvStore();
        this.lobMap = mvStore.openMap("lobMap");
        this.refMap = mvStore.openMap("lobRef");
        MVMap<Long, byte[]> dataMap = mvStore.openMap("lobData");
        this.streamStore = new StreamStore(dataMap);
        if (this.database.isReadOnly()) {
            return;
        }
        if (dataMap.isEmpty()) {
            return;
        }
        long lastUsedKey = -1L;
        for (Map.Entry<Long, Object[]> e : this.lobMap.entrySet()) {
            long lobId = e.getKey();
            Object[] v = e.getValue();
            byte[] id = (byte[])v[0];
            long max = this.streamStore.getMaxBlockKey(id);
            if (max == -1L || max <= lastUsedKey) continue;
            lastUsedKey = max;
        }
        while ((last = dataMap.lastKey()) != null && last > lastUsedKey) {
            dataMap.remove(last);
        }
        last = dataMap.lastKey();
        if (last != null) {
            this.streamStore.setNextKey(last + 1L);
        }
    }

    @Override
    public Value createBlob(InputStream in, long maxLength) {
        this.init();
        int type = 15;
        try {
            if (maxLength != -1L && maxLength <= (long)this.database.getMaxLengthInplaceLob()) {
                byte[] small = new byte[(int)maxLength];
                int len = IOUtils.readFully(in, small, (int)maxLength);
                if ((long)len > maxLength) {
                    throw new IllegalStateException("len > blobLength, " + len + " > " + maxLength);
                }
                if (len < small.length) {
                    small = Arrays.copyOf(small, len);
                }
                return ValueLobDb.createSmallLob(type, small);
            }
            if (maxLength != -1L) {
                in = new RangeInputStream(in, 0L, maxLength);
            }
            return this.createLob(in, type);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    @Override
    public Value createClob(Reader reader, long maxLength) {
        this.init();
        int type = 16;
        try {
            if (maxLength != -1L && maxLength * 3L <= (long)this.database.getMaxLengthInplaceLob()) {
                char[] small = new char[(int)maxLength];
                int len = IOUtils.readFully(reader, small, (int)maxLength);
                if ((long)len > maxLength) {
                    throw new IllegalStateException("len > blobLength, " + len + " > " + maxLength);
                }
                byte[] utf8 = new String(small, 0, len).getBytes(StandardCharsets.UTF_8);
                if (utf8.length > this.database.getMaxLengthInplaceLob()) {
                    throw new IllegalStateException("len > maxinplace, " + utf8.length + " > " + this.database.getMaxLengthInplaceLob());
                }
                return ValueLobDb.createSmallLob(type, utf8);
            }
            if (maxLength < 0L) {
                maxLength = Long.MAX_VALUE;
            }
            CountingReaderInputStream in = new CountingReaderInputStream(reader, maxLength);
            ValueLobDb lob = this.createLob(in, type);
            lob = ValueLobDb.create(type, this.database, lob.getTableId(), lob.getLobId(), null, in.getLength());
            return lob;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private ValueLobDb createLob(InputStream in, int type) throws IOException {
        byte[] streamStoreId;
        try {
            streamStoreId = this.streamStore.put(in);
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        long lobId = this.generateLobId();
        long length = this.streamStore.length(streamStoreId);
        int tableId = -2;
        Object[] value = new Object[]{streamStoreId, tableId, length, 0};
        this.lobMap.put(lobId, value);
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.put(key, Boolean.TRUE);
        ValueLobDb lob = ValueLobDb.create(type, this.database, tableId, lobId, null, length);
        return lob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateLobId() {
        Object object = this.nextLobIdSync;
        synchronized (object) {
            if (this.nextLobId == 0L) {
                Long id = this.lobMap.lastKey();
                this.nextLobId = id == null ? 1L : id + 1L;
            }
            return this.nextLobId++;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb old, int tableId, long length) {
        this.init();
        int type = old.getValueType();
        long oldLobId = old.getLobId();
        long oldLength = old.getType().getPrecision();
        if (oldLength != length) {
            throw DbException.throwInternalError("Length is different");
        }
        Object[] value = this.lobMap.get(oldLobId);
        value = (Object[])value.clone();
        byte[] streamStoreId = (byte[])value[0];
        long lobId = this.generateLobId();
        value[1] = tableId;
        this.lobMap.put(lobId, value);
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.put(key, Boolean.TRUE);
        ValueLobDb lob = ValueLobDb.create(type, this.database, tableId, lobId, null, length);
        return lob;
    }

    @Override
    public InputStream getInputStream(ValueLobDb lob, byte[] hmac, long byteCount) throws IOException {
        this.init();
        Object[] value = this.lobMap.get(lob.getLobId());
        if (value == null) {
            if (lob.getTableId() == -3 || lob.getTableId() == -1) {
                throw DbException.get(90039, lob.getLobId() + "/" + lob.getTableId());
            }
            throw DbException.throwInternalError("Lob not found: " + lob.getLobId() + "/" + lob.getTableId());
        }
        byte[] streamStoreId = (byte[])value[0];
        return this.streamStore.get(streamStoreId);
    }

    @Override
    public void removeAllForTable(int tableId) {
        this.init();
        if (this.database.getStore().getMvStore().isClosed()) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (Map.Entry<Long, Object[]> e : this.lobMap.entrySet()) {
            Object[] value = e.getValue();
            int t2 = (Integer)value[1];
            if (t2 != tableId) continue;
            list.add(e.getKey());
        }
        Iterator<Map.Entry<Long, Object>> iterator = list.iterator();
        while (iterator.hasNext()) {
            long lobId = (Long)((Object)iterator.next());
            this.removeLob(tableId, lobId);
        }
        if (tableId == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    @Override
    public void removeLob(ValueLobDb lob) {
        this.init();
        int tableId = lob.getTableId();
        long lobId = lob.getLobId();
        this.removeLob(tableId, lobId);
    }

    private void removeLob(int tableId, long lobId) {
        byte[] s2;
        Object[] value = this.lobMap.remove(lobId);
        if (value == null) {
            return;
        }
        byte[] streamStoreId = (byte[])value[0];
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.remove(key);
        key = new Object[]{streamStoreId, 0L};
        value = this.refMap.ceilingKey(key);
        boolean hasMoreEntries = false;
        if (value != null && Arrays.equals(streamStoreId, s2 = (byte[])value[0])) {
            hasMoreEntries = true;
        }
        if (!hasMoreEntries) {
            this.streamStore.remove(streamStoreId);
        }
    }

    private static void trace(String op) {
        System.out.println("[" + Thread.currentThread().getName() + "] LOB " + op);
    }
}

