/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCollecting;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCount;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataDefault;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.SimpleResult;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueJavaObject;
import org.gridgain.internal.h2.value.ValueLob;
import org.gridgain.internal.h2.value.ValueLobDb;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueStringFixed;
import org.gridgain.internal.h2.value.ValueStringIgnoreCase;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;
import org.gridgain.internal.h2.value.ValueUuid;

public class Data {
    public static final int LENGTH_INT = 4;
    public static final int LENGTH_LONG = 8;
    private static final byte NULL = 0;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte INT = 4;
    private static final byte LONG = 5;
    private static final byte DECIMAL = 6;
    private static final byte DOUBLE = 7;
    private static final byte FLOAT = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte BYTES = 12;
    private static final byte STRING = 13;
    private static final byte STRING_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte RESULT_SET = 18;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte STRING_FIXED = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte LONG_0_7 = 48;
    private static final byte DECIMAL_0_1 = 56;
    private static final byte DECIMAL_SMALL_0 = 58;
    private static final byte DECIMAL_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte FLOAT_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte LONG_NEG = 67;
    private static final byte STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final int CUSTOM_DATA_TYPE = 135;
    private static final int AGG_DATA_COUNT = 136;
    private static final int AGG_DATA_DEFAULT = 137;
    private static final int AGG_DATA_COLLECTION = 138;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private byte[] data;
    private int pos;
    private final DataHandler handler;
    private final boolean storeLocalTime;
    private CompareMode cmp;

    private Data(DataHandler handler, byte[] data, boolean storeLocalTime) {
        this.handler = handler;
        this.data = data;
        this.storeLocalTime = storeLocalTime;
    }

    public void setCompareMode(CompareMode cmp) {
        this.cmp = cmp;
    }

    public void setInt(int pos, int x) {
        Bits.writeInt(this.data, pos, x);
    }

    public void writeInt(int x) {
        Bits.writeInt(this.data, this.pos, x);
        this.pos += 4;
    }

    public int readInt() {
        int x = Bits.readInt(this.data, this.pos);
        this.pos += 4;
        return x;
    }

    public static int getStringLen(String s2) {
        int len = s2.length();
        return Data.getStringWithoutLengthLen(s2, len) + Data.getVarIntLen(len);
    }

    private static int getStringWithoutLengthLen(String s2, int len) {
        int plus = 0;
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c >= '\u0800') {
                plus += 2;
                continue;
            }
            if (c < '\u0080') continue;
            ++plus;
        }
        return len + plus;
    }

    public String readString() {
        int len = this.readVarInt();
        return this.readString(len);
    }

    private String readString(int len) {
        byte[] buff = this.data;
        int p = this.pos;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int x;
            chars[i] = (x = buff[p++] & 0xFF) < 128 ? (char)x : (x >= 224 ? (char)(((x & 0xF) << 12) + ((buff[p++] & 0x3F) << 6) + (buff[p++] & 0x3F)) : (char)(((x & 0x1F) << 6) + (buff[p++] & 0x3F)));
        }
        this.pos = p;
        return new String(chars);
    }

    public void writeString(String s2) {
        int len = s2.length();
        this.writeVarInt(len);
        this.writeStringWithoutLength(s2, len);
    }

    private void writeStringWithoutLength(String s2, int len) {
        int p = this.pos;
        byte[] buff = this.data;
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(c >> 6 & 0x3F);
                buff[p++] = (byte)(c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(c & 0x3F);
        }
        this.pos = p;
    }

    private void writeStringWithoutLength(char[] chars, int len) {
        int p = this.pos;
        byte[] buff = this.data;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(c >> 6 & 0x3F);
                buff[p++] = (byte)(c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(c & 0x3F);
        }
        this.pos = p;
    }

    public static Data create(DataHandler handler, int capacity, boolean storeLocalTime) {
        return new Data(handler, new byte[capacity], storeLocalTime);
    }

    public static Data create(DataHandler handler, byte[] buff, boolean storeLocalTime) {
        return new Data(handler, buff, storeLocalTime);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] buff, int off, int len) {
        System.arraycopy(buff, off, this.data, this.pos, len);
        this.pos += len;
    }

    public void read(byte[] buff, int off, int len) {
        System.arraycopy(this.data, this.pos, buff, off, len);
        this.pos += len;
    }

    public void writeByte(byte x) {
        this.data[this.pos++] = x;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        long x = Bits.readLong(this.data, this.pos);
        this.pos += 8;
        return x;
    }

    public void writeLong(long x) {
        Bits.writeLong(this.data, this.pos, x);
        this.pos += 8;
    }

    public void writeValue(Object o) {
        int start = this.pos;
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v == ValueNull.INSTANCE) {
                this.data[this.pos++] = 0;
                return;
            }
            int type = v.getValueType();
            switch (type) {
                case 1: {
                    this.writeByte(v.getBoolean() ? (byte)65 : 64);
                    break;
                }
                case 2: {
                    this.writeByte((byte)2);
                    this.writeByte(v.getByte());
                    break;
                }
                case 3: {
                    this.writeByte((byte)3);
                    this.writeShortInt(v.getShort());
                    break;
                }
                case 4: 
                case 25: {
                    int x = v.getInt();
                    if (x < 0) {
                        this.writeByte((byte)66);
                        this.writeVarInt(-x);
                        break;
                    }
                    if (x < 16) {
                        this.writeByte((byte)(32 + x));
                        break;
                    }
                    this.writeByte(type == 4 ? (byte)4 : 25);
                    this.writeVarInt(x);
                    break;
                }
                case 5: {
                    long x = v.getLong();
                    if (x < 0L) {
                        this.writeByte((byte)67);
                        this.writeVarLong(-x);
                        break;
                    }
                    if (x < 8L) {
                        this.writeByte((byte)(48L + x));
                        break;
                    }
                    this.writeByte((byte)5);
                    this.writeVarLong(x);
                    break;
                }
                case 6: {
                    BigDecimal x = v.getBigDecimal();
                    if (BigDecimal.ZERO.equals(x)) {
                        this.writeByte((byte)56);
                        break;
                    }
                    if (BigDecimal.ONE.equals(x)) {
                        this.writeByte((byte)57);
                        break;
                    }
                    int scale = x.scale();
                    BigInteger b = x.unscaledValue();
                    int bits = b.bitLength();
                    if (bits <= 63) {
                        if (scale == 0) {
                            this.writeByte((byte)58);
                            this.writeVarLong(b.longValue());
                            break;
                        }
                        this.writeByte((byte)59);
                        this.writeVarInt(scale);
                        this.writeVarLong(b.longValue());
                        break;
                    }
                    this.writeByte((byte)6);
                    this.writeVarInt(scale);
                    byte[] bytes = b.toByteArray();
                    this.writeVarInt(bytes.length);
                    this.write(bytes, 0, bytes.length);
                    break;
                }
                case 9: {
                    if (this.storeLocalTime) {
                        this.writeByte((byte)-124);
                        ValueTime t2 = (ValueTime)v;
                        long nanos = t2.getNanos();
                        long millis = nanos / 1000000L;
                        this.writeVarLong(millis);
                        this.writeVarLong(nanos -= millis * 1000000L);
                        break;
                    }
                    this.writeByte((byte)9);
                    this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
                    break;
                }
                case 10: {
                    if (this.storeLocalTime) {
                        this.writeByte((byte)-123);
                        long x = ((ValueDate)v).getDateValue();
                        this.writeVarLong(x);
                        break;
                    }
                    this.writeByte((byte)10);
                    long x = DateTimeUtils.getTimeLocalWithoutDst(v.getDate());
                    this.writeVarLong(x / 60000L);
                    break;
                }
                case 11: {
                    if (this.storeLocalTime) {
                        this.writeByte((byte)-122);
                        ValueTimestamp ts = (ValueTimestamp)v;
                        long dateValue = ts.getDateValue();
                        this.writeVarLong(dateValue);
                        long nanos = ts.getTimeNanos();
                        long millis = nanos / 1000000L;
                        this.writeVarLong(millis);
                        this.writeVarLong(nanos -= millis * 1000000L);
                        break;
                    }
                    Timestamp ts = v.getTimestamp();
                    this.writeByte((byte)11);
                    this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(ts));
                    this.writeVarInt(ts.getNanos() % 1000000);
                    break;
                }
                case 24: {
                    ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                    this.writeByte((byte)24);
                    this.writeVarLong(ts.getDateValue());
                    this.writeVarLong(ts.getTimeNanos());
                    this.writeVarInt(ts.getTimeZoneOffsetMins());
                    break;
                }
                case 19: 
                case 22: {
                    this.writeByte(type == 22 ? (byte)22 : 19);
                    byte[] b = v.getBytesNoCopy();
                    int len = b.length;
                    this.writeVarInt(len);
                    this.write(b, 0, len);
                    break;
                }
                case 12: {
                    byte[] b = v.getBytesNoCopy();
                    int len = b.length;
                    if (len < 32) {
                        this.writeByte((byte)(100 + len));
                        this.write(b, 0, len);
                        break;
                    }
                    this.writeByte((byte)12);
                    this.writeVarInt(len);
                    this.write(b, 0, len);
                    break;
                }
                case 20: {
                    this.writeByte((byte)20);
                    ValueUuid uuid = (ValueUuid)v;
                    this.writeLong(uuid.getHigh());
                    this.writeLong(uuid.getLow());
                    break;
                }
                case 13: {
                    String s2 = v.getString();
                    int len = s2.length();
                    if (len < 32) {
                        this.writeByte((byte)(68 + len));
                        this.writeStringWithoutLength(s2, len);
                        break;
                    }
                    this.writeByte((byte)13);
                    this.writeString(s2);
                    break;
                }
                case 14: {
                    this.writeByte((byte)14);
                    this.writeString(v.getString());
                    break;
                }
                case 21: {
                    this.writeByte((byte)21);
                    this.writeString(v.getString());
                    break;
                }
                case 7: {
                    double x = v.getDouble();
                    if (x == 1.0) {
                        this.writeByte((byte)61);
                        break;
                    }
                    long d = Double.doubleToLongBits(x);
                    if (d == 0L) {
                        this.writeByte((byte)60);
                        break;
                    }
                    this.writeByte((byte)7);
                    this.writeVarLong(Long.reverse(d));
                    break;
                }
                case 8: {
                    float x = v.getFloat();
                    if (x == 1.0f) {
                        this.writeByte((byte)63);
                        break;
                    }
                    int f = Float.floatToIntBits(x);
                    if (f == 0) {
                        this.writeByte((byte)62);
                        break;
                    }
                    this.writeByte((byte)8);
                    this.writeVarInt(Integer.reverse(f));
                    break;
                }
                case 15: 
                case 16: {
                    this.writeByte(type == 15 ? (byte)15 : 16);
                    if (v instanceof ValueLob) {
                        ValueLob lob = (ValueLob)v;
                        byte[] small = lob.getSmall();
                        if (small == null) {
                            int t3 = -1;
                            if (!lob.isLinkedToTable()) {
                                t3 = -2;
                            }
                            this.writeVarInt(t3);
                            this.writeVarInt(lob.getTableId());
                            this.writeVarInt(lob.getObjectId());
                            this.writeVarLong(lob.getType().getPrecision());
                            this.writeByte((byte)(lob.isCompressed() ? 1 : 0));
                            if (t3 != -2) break;
                            this.writeString(lob.getFileName());
                            break;
                        }
                        this.writeVarInt(small.length);
                        this.write(small, 0, small.length);
                        break;
                    }
                    ValueLobDb lob = (ValueLobDb)v;
                    byte[] small = lob.getSmall();
                    if (small == null) {
                        this.writeVarInt(-3);
                        this.writeVarInt(lob.getTableId());
                        this.writeVarLong(lob.getLobId());
                        this.writeVarLong(lob.getType().getPrecision());
                        break;
                    }
                    this.writeVarInt(small.length);
                    this.write(small, 0, small.length);
                    break;
                }
                case 17: 
                case 39: {
                    this.writeByte(type == 17 ? (byte)17 : 27);
                    Value[] list = ((ValueCollectionBase)v).getList();
                    this.writeVarInt(list.length);
                    for (Value x : list) {
                        this.writeValue(x);
                    }
                    break;
                }
                case 18: {
                    this.writeByte((byte)18);
                    ResultInterface result = ((ValueResultSet)v).getResult();
                    result.reset();
                    int columnCount = result.getVisibleColumnCount();
                    this.writeVarInt(columnCount);
                    for (int i = 0; i < columnCount; ++i) {
                        this.writeString(result.getAlias(i));
                        this.writeString(result.getColumnName(i));
                        TypeInfo columnType = result.getColumnType(i);
                        this.writeVarInt(columnType.getValueType());
                        this.writeVarLong(columnType.getPrecision());
                        this.writeVarInt(columnType.getScale());
                    }
                    while (result.next()) {
                        this.writeByte((byte)1);
                        Value[] row = result.currentRow();
                        for (int i = 0; i < columnCount; ++i) {
                            this.writeValue(row[i]);
                        }
                    }
                    this.writeByte((byte)0);
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 26;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeByte((byte)26);
                    this.writeByte((byte)ordinal);
                    this.writeVarLong(interval.getLeading());
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 26;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeByte((byte)26);
                    this.writeByte((byte)ordinal);
                    this.writeVarLong(interval.getLeading());
                    this.writeVarLong(interval.getRemaining());
                    break;
                }
                default: {
                    if (JdbcUtils.customDataTypesHandler != null) {
                        byte[] b = v.getBytesNoCopy();
                        this.writeByte((byte)-121);
                        this.writeVarInt(type);
                        this.writeVarInt(b.length);
                        this.write(b, 0, b.length);
                        break;
                    }
                    DbException.throwInternalError("type=" + v.getValueType());
                }
            }
            assert (this.pos - start == this.getValueLen(v)) : "value size error: got " + (this.pos - start) + " expected " + this.getValueLen(v);
        } else if (o instanceof AggregateDataCount) {
            AggregateDataCount a = (AggregateDataCount)o;
            this.writeByte((byte)-120);
            this.writeByte(a.isAll() ? (byte)65 : 64);
            this.writeLong(a.count());
        } else if (o instanceof AggregateDataDefault) {
            AggregateDataDefault a = (AggregateDataDefault)o;
            this.writeByte((byte)-119);
            this.writeInt(a.aggregateType().ordinal());
            this.writeInt(a.dataType());
            this.writeLong(a.count());
            this.writeValue(a.value() == null ? ValueNull.INSTANCE : a.value());
            this.writeLong(Double.doubleToLongBits(a.mean()));
            this.writeLong(Double.doubleToLongBits(a.m2()));
        } else if (o instanceof AggregateDataCollecting) {
            AggregateDataCollecting a = (AggregateDataCollecting)o;
            this.writeByte((byte)-118);
            this.writeByte(a.isDistinct() ? (byte)65 : 64);
            this.writeValue(a.getSharedArgument() == null ? ValueNull.INSTANCE : a.getSharedArgument());
            Collection<Value> values = a.values();
            if (values == null) {
                this.writeInt(0);
            } else {
                this.writeInt(values.size());
                for (Value v : values) {
                    this.writeValue(v);
                }
            }
        } else {
            throw DbException.throwInternalError("unknown type=" + o.getClass());
        }
    }

    public Object readValue() {
        int type = this.data[this.pos++] & 0xFF;
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: 
            case 25: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int scale = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), scale));
            }
            case 6: {
                int scale = this.readVarInt();
                int len = this.readVarInt();
                byte[] buff = Utils.newBytes(len);
                this.read(buff, 0, len);
                BigInteger b = new BigInteger(buff);
                return ValueDecimal.get(new BigDecimal(b, scale));
            }
            case 133: {
                return ValueDate.fromDateValue(this.readVarLong());
            }
            case 10: {
                long x = this.readVarLong() * 60000L;
                return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(x));
            }
            case 132: {
                long nanos = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTime.fromNanos(nanos);
            }
            case 9: {
                return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()));
            }
            case 134: {
                long dateValue = this.readVarLong();
                long nanos = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
            }
            case 11: {
                return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()), this.readVarInt() % 1000000);
            }
            case 24: {
                long dateValue = this.readVarLong();
                long nanos = this.readVarLong();
                short tz = (short)this.readVarInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tz);
            }
            case 12: {
                int len = this.readVarInt();
                byte[] b = Utils.newBytes(len);
                this.read(b, 0, len);
                return ValueBytes.getNoCopy(b);
            }
            case 22: {
                int len = this.readVarInt();
                byte[] b = Utils.newBytes(len);
                this.read(b, 0, len);
                return ValueGeometry.get(b);
            }
            case 19: {
                int len = this.readVarInt();
                byte[] b = Utils.newBytes(len);
                this.read(b, 0, len);
                return ValueJavaObject.getNoCopy(null, b, this.handler);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.ZERO;
            }
            case 63: {
                return ValueFloat.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int smallLen = this.readVarInt();
                if (smallLen >= 0) {
                    byte[] small = Utils.newBytes(smallLen);
                    this.read(small, 0, smallLen);
                    return ValueLobDb.createSmallLob(type == 15 ? 15 : 16, small);
                }
                if (smallLen == -3) {
                    int tableId = this.readVarInt();
                    long lobId = this.readVarLong();
                    long precision = this.readVarLong();
                    return ValueLobDb.create(type == 15 ? 15 : 16, this.handler, tableId, lobId, null, precision);
                }
                int tableId = this.readVarInt();
                int objectId = this.readVarInt();
                long precision = 0L;
                boolean compression = false;
                if (smallLen == -1 || smallLen == -2) {
                    precision = this.readVarLong();
                    boolean bl = compression = this.readByte() == 1;
                }
                if (smallLen == -2) {
                    String filename = this.readString();
                    return ValueLob.openUnlinked(type == 15 ? 15 : 16, this.handler, tableId, objectId, precision, compression, filename);
                }
                return ValueLob.openLinked(type == 15 ? 15 : 16, this.handler, tableId, objectId, precision, compression);
            }
            case 17: 
            case 27: {
                int len = this.readVarInt();
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = (Value)this.readValue();
                }
                return type == 17 ? ValueArray.get(list) : ValueRow.get(list);
            }
            case 18: {
                SimpleResult rs = new SimpleResult();
                int columns = this.readVarInt();
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(this.readString(), this.readString(), this.readVarInt(), this.readVarLong(), this.readVarInt());
                }
                while (this.readByte() != 0) {
                    Value[] o = new Value[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = (Value)this.readValue();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
            case 26: {
                boolean negative;
                int ordinal = this.readByte();
                boolean bl = negative = ordinal < 0;
                if (negative) {
                    ordinal ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(ordinal), negative, this.readVarLong(), ordinal < 5 ? 0L : this.readVarLong());
            }
            case 135: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    int customType = this.readVarInt();
                    int len = this.readVarInt();
                    byte[] b = Utils.newBytes(len);
                    this.read(b, 0, len);
                    return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(b), customType);
                }
                throw DbException.get(50004, "No CustomDataTypesHandler has been set up");
            }
            case 136: {
                boolean all = this.readByte() == 65;
                long count = this.readLong();
                return AggregateDataCount.from(all, count);
            }
            case 137: {
                AggregateType aggType = AggregateType.values()[this.readInt()];
                int dataType = this.readInt();
                long cnt = this.readLong();
                Value val = (Value)this.readValue();
                if (val == ValueNull.INSTANCE) {
                    val = null;
                }
                double mean = Double.longBitsToDouble(this.readLong());
                double m22 = Double.longBitsToDouble(this.readLong());
                return AggregateDataDefault.from(aggType, dataType, cnt, mean, m22, val);
            }
            case 138: {
                boolean distinct = this.readByte() == 65;
                Value shared = (Value)this.readValue();
                if (shared == ValueNull.INSTANCE) {
                    shared = null;
                }
                assert (!distinct || this.cmp != null);
                AbstractCollection values = null;
                int size = this.readInt();
                if (size != 0) {
                    values = distinct ? new TreeSet<Value>(this.cmp) : new ArrayList(size);
                }
                for (int i = 0; i < size; ++i) {
                    values.add((Value)((Value)this.readValue()));
                }
                return AggregateDataCollecting.from(distinct, values, shared);
            }
        }
        if (type >= 32 && type < 48) {
            return ValueInt.get(type - 32);
        }
        if (type >= 48 && type < 56) {
            return ValueLong.get(type - 48);
        }
        if (type >= 100 && type < 132) {
            int len = type - 100;
            byte[] b = Utils.newBytes(len);
            this.read(b, 0, len);
            return ValueBytes.getNoCopy(b);
        }
        if (type >= 68 && type < 100) {
            return ValueString.get(this.readString(type - 68));
        }
        throw DbException.get(90030, "type: " + type);
    }

    public int getValueLen(Object v) {
        return Data.getValueLen(v, this.storeLocalTime);
    }

    public static int getValueLen(Object o, boolean storeLocalTime) {
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v == ValueNull.INSTANCE) {
                return 1;
            }
            switch (v.getValueType()) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: 
                case 25: {
                    int x = v.getInt();
                    if (x < 0) {
                        return 1 + Data.getVarIntLen(-x);
                    }
                    if (x < 16) {
                        return 1;
                    }
                    return 1 + Data.getVarIntLen(x);
                }
                case 5: {
                    long x = v.getLong();
                    if (x < 0L) {
                        return 1 + Data.getVarLongLen(-x);
                    }
                    if (x < 8L) {
                        return 1;
                    }
                    return 1 + Data.getVarLongLen(x);
                }
                case 7: {
                    double x = v.getDouble();
                    if (x == 1.0) {
                        return 1;
                    }
                    long d = Double.doubleToLongBits(x);
                    if (d == 0L) {
                        return 1;
                    }
                    return 1 + Data.getVarLongLen(Long.reverse(d));
                }
                case 8: {
                    float x = v.getFloat();
                    if (x == 1.0f) {
                        return 1;
                    }
                    int f = Float.floatToIntBits(x);
                    if (f == 0) {
                        return 1;
                    }
                    return 1 + Data.getVarIntLen(Integer.reverse(f));
                }
                case 13: {
                    String s2 = v.getString();
                    int len = s2.length();
                    if (len < 32) {
                        return 1 + Data.getStringWithoutLengthLen(s2, len);
                    }
                    return 1 + Data.getStringLen(s2);
                }
                case 14: 
                case 21: {
                    return 1 + Data.getStringLen(v.getString());
                }
                case 6: {
                    BigDecimal x = v.getBigDecimal();
                    if (BigDecimal.ZERO.equals(x)) {
                        return 1;
                    }
                    if (BigDecimal.ONE.equals(x)) {
                        return 1;
                    }
                    int scale = x.scale();
                    BigInteger b = x.unscaledValue();
                    int bits = b.bitLength();
                    if (bits <= 63) {
                        if (scale == 0) {
                            return 1 + Data.getVarLongLen(b.longValue());
                        }
                        return 1 + Data.getVarIntLen(scale) + Data.getVarLongLen(b.longValue());
                    }
                    byte[] bytes = b.toByteArray();
                    return 1 + Data.getVarIntLen(scale) + Data.getVarIntLen(bytes.length) + bytes.length;
                }
                case 9: {
                    if (storeLocalTime) {
                        long nanos = ((ValueTime)v).getNanos();
                        long millis = nanos / 1000000L;
                        return 1 + Data.getVarLongLen(millis) + Data.getVarLongLen(nanos -= millis * 1000000L);
                    }
                    return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
                }
                case 10: {
                    if (storeLocalTime) {
                        long dateValue = ((ValueDate)v).getDateValue();
                        return 1 + Data.getVarLongLen(dateValue);
                    }
                    long x = DateTimeUtils.getTimeLocalWithoutDst(v.getDate());
                    return 1 + Data.getVarLongLen(x / 60000L);
                }
                case 11: {
                    if (storeLocalTime) {
                        ValueTimestamp ts = (ValueTimestamp)v;
                        long dateValue = ts.getDateValue();
                        long nanos = ts.getTimeNanos();
                        long millis = nanos / 1000000L;
                        return 1 + Data.getVarLongLen(dateValue) + Data.getVarLongLen(millis) + Data.getVarLongLen(nanos -= millis * 1000000L);
                    }
                    Timestamp ts = v.getTimestamp();
                    return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(ts)) + Data.getVarIntLen(ts.getNanos() % 1000000);
                }
                case 24: {
                    ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                    long dateValue = ts.getDateValue();
                    long nanos = ts.getTimeNanos();
                    short tz = ts.getTimeZoneOffsetMins();
                    return 1 + Data.getVarLongLen(dateValue) + Data.getVarLongLen(nanos) + Data.getVarIntLen(tz);
                }
                case 19: 
                case 22: {
                    byte[] b = v.getBytesNoCopy();
                    return 1 + Data.getVarIntLen(b.length) + b.length;
                }
                case 12: {
                    byte[] b = v.getBytesNoCopy();
                    int len = b.length;
                    if (len < 32) {
                        return 1 + b.length;
                    }
                    return 1 + Data.getVarIntLen(b.length) + b.length;
                }
                case 20: {
                    return 17;
                }
                case 15: 
                case 16: {
                    int len = 1;
                    if (v instanceof ValueLob) {
                        ValueLob lob = (ValueLob)v;
                        byte[] small = lob.getSmall();
                        if (small == null) {
                            int t2 = -1;
                            if (!lob.isLinkedToTable()) {
                                t2 = -2;
                            }
                            len += Data.getVarIntLen(t2);
                            len += Data.getVarIntLen(lob.getTableId());
                            len += Data.getVarIntLen(lob.getObjectId());
                            len += Data.getVarLongLen(lob.getType().getPrecision());
                            ++len;
                            if (t2 == -2) {
                                len += Data.getStringLen(lob.getFileName());
                            }
                        } else {
                            len += Data.getVarIntLen(small.length);
                            len += small.length;
                        }
                    } else {
                        ValueLobDb lob = (ValueLobDb)v;
                        byte[] small = lob.getSmall();
                        if (small == null) {
                            len += Data.getVarIntLen(-3);
                            len += Data.getVarIntLen(lob.getTableId());
                            len += Data.getVarLongLen(lob.getLobId());
                            len += Data.getVarLongLen(lob.getType().getPrecision());
                        } else {
                            len += Data.getVarIntLen(small.length);
                            len += small.length;
                        }
                    }
                    return len;
                }
                case 17: 
                case 39: {
                    Value[] list = ((ValueCollectionBase)v).getList();
                    int len = 1 + Data.getVarIntLen(list.length);
                    for (Value x : list) {
                        len += Data.getValueLen(x, storeLocalTime);
                    }
                    return len;
                }
                case 18: {
                    int len = 1;
                    ResultInterface result = ((ValueResultSet)v).getResult();
                    int columnCount = result.getVisibleColumnCount();
                    len += Data.getVarIntLen(columnCount);
                    for (int i = 0; i < columnCount; ++i) {
                        len += Data.getStringLen(result.getAlias(i));
                        len += Data.getStringLen(result.getColumnName(i));
                        TypeInfo columnType = result.getColumnType(i);
                        len += Data.getVarIntLen(columnType.getValueType());
                        len += Data.getVarLongLen(columnType.getPrecision());
                        len += Data.getVarIntLen(columnType.getScale());
                    }
                    while (result.next()) {
                        ++len;
                        Value[] row = result.currentRow();
                        for (int i = 0; i < columnCount; ++i) {
                            Value val = row[i];
                            len += Data.getValueLen(val, storeLocalTime);
                        }
                    }
                    return ++len;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    ValueInterval interval = (ValueInterval)v;
                    return 2 + Data.getVarLongLen(interval.getLeading());
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    ValueInterval interval = (ValueInterval)v;
                    return 2 + Data.getVarLongLen(interval.getLeading()) + Data.getVarLongLen(interval.getRemaining());
                }
            }
            if (JdbcUtils.customDataTypesHandler != null) {
                byte[] b = v.getBytesNoCopy();
                return 1 + Data.getVarIntLen(v.getValueType()) + Data.getVarIntLen(b.length) + b.length;
            }
            throw DbException.throwInternalError("type=" + v.getValueType());
        }
        if (o instanceof AggregateDataCount) {
            return 14;
        }
        if (o instanceof AggregateDataDefault) {
            AggregateDataDefault a = (AggregateDataDefault)o;
            return 44 + Data.getValueLen(a.value() == null ? ValueNull.INSTANCE : a.value(), storeLocalTime);
        }
        if (o instanceof AggregateDataCollecting) {
            AggregateDataCollecting a = (AggregateDataCollecting)o;
            int len = 10;
            len += Data.getValueLen(a.getSharedArgument() == null ? ValueNull.INSTANCE : a.getSharedArgument(), storeLocalTime);
            Collection<Value> values = a.values();
            if (values != null) {
                for (Value v : values) {
                    len += Data.getValueLen(v, storeLocalTime);
                }
            }
            return len;
        }
        throw DbException.throwInternalError("unknown type=" + o.getClass());
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void writeShortInt(int x) {
        byte[] buff = this.data;
        buff[this.pos++] = (byte)(x >> 8);
        buff[this.pos++] = (byte)x;
    }

    public short readShortInt() {
        byte[] buff = this.data;
        return (short)(((buff[this.pos++] & 0xFF) << 8) + (buff[this.pos++] & 0xFF));
    }

    public void truncate(int size) {
        if (this.pos > size) {
            byte[] buff = Arrays.copyOf(this.data, size);
            this.pos = size;
            this.data = buff;
        }
    }

    private static int getVarIntLen(int x) {
        if ((x & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((x & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((x & 0xFFE00000) == 0) {
            return 3;
        }
        if ((x & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int x) {
        while ((x & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(x | 0x80);
            x >>>= 7;
        }
        this.data[this.pos++] = (byte)x;
    }

    public int readVarInt() {
        byte b = this.data[this.pos];
        if (b >= 0) {
            ++this.pos;
            return b;
        }
        return this.readVarIntRest(b);
    }

    private int readVarIntRest(int b) {
        int x = b & 0x7F;
        b = this.data[this.pos + 1];
        if (b >= 0) {
            this.pos += 2;
            return x | b << 7;
        }
        x |= (b & 0x7F) << 7;
        b = this.data[this.pos + 2];
        if (b >= 0) {
            this.pos += 3;
            return x | b << 14;
        }
        x |= (b & 0x7F) << 14;
        b = this.data[this.pos + 3];
        if (b >= 0) {
            this.pos += 4;
            return x | b << 21;
        }
        this.pos += 5;
        return x |= (b & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public static int getVarLongLen(long x) {
        int i = 1;
        while ((x >>>= 7) != 0L) {
            ++i;
        }
        return i;
    }

    public void writeVarLong(long x) {
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(x | 0x80L);
            x >>>= 7;
        }
        this.data[this.pos++] = (byte)x;
    }

    public long readVarLong() {
        long x;
        if ((x = (long)this.data[this.pos++]) >= 0L) {
            return x;
        }
        x &= 0x7FL;
        int s2 = 7;
        while (true) {
            long b = this.data[this.pos++];
            x |= (b & 0x7FL) << s2;
            if (b >= 0L) {
                return x;
            }
            s2 += 7;
        }
    }

    public void checkCapacity(int plus) {
        if (this.pos + plus >= this.data.length) {
            this.expand(plus);
        }
    }

    private void expand(int plus) {
        this.data = Utils.copyBytes(this.data, (this.data.length + plus) * 2);
    }

    public void fillAligned() {
        int len;
        this.pos = len = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < len) {
            this.checkCapacity(len - this.data.length);
        }
    }

    public static void copyString(Reader source, OutputStream target) throws IOException {
        int l;
        char[] buff = new char[4096];
        Data d = new Data(null, new byte[12288], false);
        while ((l = source.read(buff)) >= 0) {
            d.writeStringWithoutLength(buff, l);
            target.write(d.data, 0, d.pos);
            d.reset();
        }
    }

    public DataHandler getHandler() {
        return this.handler;
    }
}

