/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class UpdatableRow {
    private final JdbcConnection conn;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ArrayList<String> key;
    private boolean isUpdatable;

    public UpdatableRow(JdbcConnection conn, ResultInterface result) throws SQLException {
        this.conn = conn;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            String t2 = result.getTableName(i);
            String s2 = result.getSchemaName(i);
            if (t2 == null || s2 == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = t2;
            } else if (!this.tableName.equals(t2)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = s2;
                continue;
            }
            if (this.schemaName.equals(s2)) continue;
            return;
        }
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTables(null, StringUtils.escapeMetaDataPattern(this.schemaName), StringUtils.escapeMetaDataPattern(this.tableName), new String[]{"TABLE"});
        if (!rs.next()) {
            return;
        }
        if (rs.getString("SQL") == null) {
            return;
        }
        String table = rs.getString("TABLE_NAME");
        boolean toUpper = !table.equals(this.tableName) && table.equalsIgnoreCase(this.tableName);
        this.key = Utils.newSmallArrayList();
        rs = meta.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName);
        while (rs.next()) {
            String c = rs.getString("COLUMN_NAME");
            this.key.add(toUpper ? StringUtils.toUpperEnglish(c) : c);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key.clear();
        rs = meta.getIndexInfo(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName, true, true);
        while (rs.next()) {
            short pos = rs.getShort("ORDINAL_POSITION");
            if (pos == 1) {
                if (this.isIndexUsable(this.key)) {
                    this.isUpdatable = true;
                    return;
                }
                this.key.clear();
            }
            String c = rs.getString("COLUMN_NAME");
            this.key.add(toUpper ? StringUtils.toUpperEnglish(c) : c);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key = null;
    }

    private boolean isIndexUsable(ArrayList<String> indexColumns) {
        if (indexColumns.isEmpty()) {
            return false;
        }
        for (String c : indexColumns) {
            if (this.findColumnIndex(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int findColumnIndex(String columnName) {
        for (int i = 0; i < this.columnCount; ++i) {
            String col = this.result.getColumnName(i);
            if (!col.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    private int getColumnIndex(String columnName) {
        int index = this.findColumnIndex(columnName);
        if (index < 0) {
            throw DbException.get(42122, columnName);
        }
        return index;
    }

    private void appendColumnList(StringBuilder builder, boolean set) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            String col = this.result.getColumnName(i);
            StringUtils.quoteIdentifier(builder, col);
            if (!set) continue;
            builder.append("=? ");
        }
    }

    private void appendKeyCondition(StringBuilder builder) {
        builder.append(" WHERE ");
        for (int i = 0; i < this.key.size(); ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            StringUtils.quoteIdentifier(builder, this.key.get(i)).append("=?");
        }
    }

    private void setKey(PreparedStatement prep, int start, Value[] current) throws SQLException {
        int size = this.key.size();
        for (int i = 0; i < size; ++i) {
            String col = this.key.get(i);
            int idx = this.getColumnIndex(col);
            Value v = current[idx];
            if (v == null || v == ValueNull.INSTANCE) {
                throw DbException.get(2000);
            }
            v.set(prep, start + i);
        }
    }

    private void appendTableName(StringBuilder builder) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            StringUtils.quoteIdentifier(builder, this.schemaName).append('.');
        }
        StringUtils.quoteIdentifier(builder, this.tableName);
    }

    public Value[] readRow(Value[] row) throws SQLException {
        StringBuilder builder = new StringBuilder("SELECT ");
        this.appendColumnList(builder, false);
        builder.append(" FROM ");
        this.appendTableName(builder);
        this.appendKeyCondition(builder);
        PreparedStatement prep = this.conn.prepareStatement(builder.toString());
        this.setKey(prep, 1, row);
        ResultSet rs = prep.executeQuery();
        if (!rs.next()) {
            throw DbException.get(2000);
        }
        Value[] newRow = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.result.getColumnType(i).getValueType();
            newRow[i] = DataType.readValue(this.conn.getSession(), rs, i + 1, type);
        }
        return newRow;
    }

    public void deleteRow(Value[] current) throws SQLException {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        this.appendTableName(builder);
        this.appendKeyCondition(builder);
        PreparedStatement prep = this.conn.prepareStatement(builder.toString());
        this.setKey(prep, 1, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }

    public void updateRow(Value[] current, Value[] updateRow) throws SQLException {
        StringBuilder builder = new StringBuilder("UPDATE ");
        this.appendTableName(builder);
        builder.append(" SET ");
        this.appendColumnList(builder, true);
        this.appendKeyCondition(builder);
        PreparedStatement prep = this.conn.prepareStatement(builder.toString());
        int j = 1;
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = updateRow[i];
            if (v == null) {
                v = current[i];
            }
            v.set(prep, j++);
        }
        this.setKey(prep, j, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }

    public void insertRow(Value[] row) throws SQLException {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        this.appendTableName(builder);
        builder.append('(');
        this.appendColumnList(builder, false);
        builder.append(")VALUES(");
        for (int i = 0; i < this.columnCount; ++i) {
            Value v;
            if (i > 0) {
                builder.append(',');
            }
            if ((v = row[i]) == null) {
                builder.append("DEFAULT");
                continue;
            }
            builder.append('?');
        }
        builder.append(')');
        PreparedStatement prep = this.conn.prepareStatement(builder.toString());
        int j = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = row[i];
            if (v == null) continue;
            v.set(prep, j++ + 1);
        }
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }
}

