/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.WriteBuffer;
import org.gridgain.internal.h2.mvstore.rtree.SpatialDataType;
import org.gridgain.internal.h2.mvstore.rtree.SpatialKey;
import org.gridgain.internal.h2.mvstore.type.DataType;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.SimpleResult;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueJavaObject;
import org.gridgain.internal.h2.value.ValueLobDb;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueStringFixed;
import org.gridgain.internal.h2.value.ValueStringIgnoreCase;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;
import org.gridgain.internal.h2.value.ValueUuid;

public class ValueDataType
implements DataType {
    private static final byte NULL = 0;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte INT = 4;
    private static final byte LONG = 5;
    private static final byte DECIMAL = 6;
    private static final byte DOUBLE = 7;
    private static final byte FLOAT = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte BYTES = 12;
    private static final byte STRING = 13;
    private static final byte STRING_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte RESULT_SET = 18;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte STRING_FIXED = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte LONG_0_7 = 48;
    private static final byte DECIMAL_0_1 = 56;
    private static final byte DECIMAL_SMALL_0 = 58;
    private static final byte DECIMAL_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte FLOAT_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte LONG_NEG = 67;
    private static final byte STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int SPATIAL_KEY_2D = 132;
    private static final int CUSTOM_DATA_TYPE = 133;
    final DataHandler handler;
    final CompareMode compareMode;
    protected final Mode mode;
    final int[] sortTypes;
    SpatialDataType spatialType;

    public ValueDataType() {
        this(CompareMode.getInstance(null, 0), null, null, null);
    }

    public ValueDataType(Database database, int[] sortTypes) {
        this(database.getCompareMode(), database.getMode(), database, sortTypes);
    }

    private ValueDataType(CompareMode compareMode, Mode mode, DataHandler handler, int[] sortTypes) {
        this.compareMode = compareMode;
        this.mode = mode;
        this.handler = handler;
        this.sortTypes = sortTypes;
    }

    private SpatialDataType getSpatialDataType() {
        if (this.spatialType == null) {
            this.spatialType = new SpatialDataType(2);
        }
        return this.spatialType;
    }

    @Override
    public int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a instanceof ValueCollectionBase && b instanceof ValueCollectionBase) {
            Value[] ax = ((ValueCollectionBase)a).getList();
            Value[] bx = ((ValueCollectionBase)b).getList();
            int al = ax.length;
            int bl = bx.length;
            int len = Math.min(al, bl);
            for (int i = 0; i < len; ++i) {
                int sortType = this.sortTypes == null ? 0 : this.sortTypes[i];
                Value one = ax[i];
                Value two = bx[i];
                if (one == null || two == null) {
                    return this.compareValues(ax[len - 1], bx[len - 1], 0);
                }
                int comp = this.compareValues(one, two, sortType);
                if (comp == 0) continue;
                return comp;
            }
            if (len < al) {
                return -1;
            }
            if (len < bl) {
                return 1;
            }
            return 0;
        }
        return this.compareValues((Value)a, (Value)b, 0);
    }

    private int compareValues(Value a, Value b, int sortType) {
        boolean aNull;
        if (a == b) {
            return 0;
        }
        boolean bl = aNull = a == ValueNull.INSTANCE;
        if (aNull || b == ValueNull.INSTANCE) {
            return SortOrder.compareNull(aNull, sortType);
        }
        int comp = a.compareTo(b, this.mode, this.compareMode);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    @Override
    public int getMemory(Object obj) {
        if (obj instanceof SpatialKey) {
            return this.getSpatialDataType().getMemory(obj);
        }
        return ValueDataType.getMemory((Value)obj);
    }

    private static int getMemory(Value v) {
        return v == null ? 0 : v.getMemory();
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    @Override
    public Object read(ByteBuffer buff) {
        return this.readValue(buff);
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        if (obj instanceof SpatialKey) {
            buff.put((byte)-124);
            this.getSpatialDataType().write(buff, obj);
            return;
        }
        Value x = (Value)obj;
        this.writeValue(buff, x);
    }

    private void writeValue(WriteBuffer buff, Value v) {
        if (v == ValueNull.INSTANCE) {
            buff.put((byte)0);
            return;
        }
        int type = v.getValueType();
        switch (type) {
            case 1: {
                buff.put(v.getBoolean() ? (byte)65 : 64);
                break;
            }
            case 2: {
                buff.put((byte)2).put(v.getByte());
                break;
            }
            case 3: {
                buff.put((byte)3).putShort(v.getShort());
                break;
            }
            case 4: 
            case 25: {
                int x = v.getInt();
                if (x < 0) {
                    buff.put((byte)66).putVarInt(-x);
                    break;
                }
                if (x < 16) {
                    buff.put((byte)(32 + x));
                    break;
                }
                buff.put(type == 4 ? (byte)4 : 25).putVarInt(x);
                break;
            }
            case 5: {
                long x = v.getLong();
                if (x < 0L) {
                    buff.put((byte)67).putVarLong(-x);
                    break;
                }
                if (x < 8L) {
                    buff.put((byte)(48L + x));
                    break;
                }
                buff.put((byte)5).putVarLong(x);
                break;
            }
            case 6: {
                BigDecimal x = v.getBigDecimal();
                if (BigDecimal.ZERO.equals(x)) {
                    buff.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(x)) {
                    buff.put((byte)57);
                    break;
                }
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits <= 63) {
                    if (scale == 0) {
                        buff.put((byte)58).putVarLong(b.longValue());
                        break;
                    }
                    buff.put((byte)59).putVarInt(scale).putVarLong(b.longValue());
                    break;
                }
                byte[] bytes = b.toByteArray();
                buff.put((byte)6).putVarInt(scale).putVarInt(bytes.length).put(bytes);
                break;
            }
            case 9: {
                ValueTime t2 = (ValueTime)v;
                long nanos = t2.getNanos();
                long millis = nanos / 1000000L;
                buff.put((byte)9).putVarLong(millis).putVarLong(nanos -= millis * 1000000L);
                break;
            }
            case 10: {
                long x = ((ValueDate)v).getDateValue();
                buff.put((byte)10).putVarLong(x);
                break;
            }
            case 11: {
                ValueTimestamp ts = (ValueTimestamp)v;
                long dateValue = ts.getDateValue();
                long nanos = ts.getTimeNanos();
                long millis = nanos / 1000000L;
                buff.put((byte)11).putVarLong(dateValue).putVarLong(millis).putVarLong(nanos -= millis * 1000000L);
                break;
            }
            case 24: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                long dateValue = ts.getDateValue();
                long nanos = ts.getTimeNanos();
                long millis = nanos / 1000000L;
                buff.put((byte)24).putVarLong(dateValue).putVarLong(millis).putVarLong(nanos -= millis * 1000000L).putVarInt(ts.getTimeZoneOffsetMins());
                break;
            }
            case 19: {
                byte[] b = v.getBytesNoCopy();
                buff.put((byte)19).putVarInt(b.length).put(b);
                break;
            }
            case 12: {
                byte[] b = v.getBytesNoCopy();
                int len = b.length;
                if (len < 32) {
                    buff.put((byte)(100 + len)).put(b);
                    break;
                }
                buff.put((byte)12).putVarInt(b.length).put(b);
                break;
            }
            case 20: {
                ValueUuid uuid = (ValueUuid)v;
                buff.put((byte)20).putLong(uuid.getHigh()).putLong(uuid.getLow());
                break;
            }
            case 13: {
                String s2 = v.getString();
                int len = s2.length();
                if (len < 32) {
                    buff.put((byte)(68 + len)).putStringData(s2, len);
                    break;
                }
                buff.put((byte)13);
                ValueDataType.writeString(buff, s2);
                break;
            }
            case 14: {
                buff.put((byte)14);
                ValueDataType.writeString(buff, v.getString());
                break;
            }
            case 21: {
                buff.put((byte)21);
                ValueDataType.writeString(buff, v.getString());
                break;
            }
            case 7: {
                double x = v.getDouble();
                if (x == 1.0) {
                    buff.put((byte)61);
                    break;
                }
                long d = Double.doubleToLongBits(x);
                if (d == 0L) {
                    buff.put((byte)60);
                    break;
                }
                buff.put((byte)7).putVarLong(Long.reverse(d));
                break;
            }
            case 8: {
                float x = v.getFloat();
                if (x == 1.0f) {
                    buff.put((byte)63);
                    break;
                }
                int f = Float.floatToIntBits(x);
                if (f == 0) {
                    buff.put((byte)62);
                    break;
                }
                buff.put((byte)8).putVarInt(Integer.reverse(f));
                break;
            }
            case 15: 
            case 16: {
                buff.put(type == 15 ? (byte)15 : 16);
                ValueLobDb lob = (ValueLobDb)v;
                byte[] small = lob.getSmall();
                if (small == null) {
                    buff.putVarInt(-3).putVarInt(lob.getTableId()).putVarLong(lob.getLobId()).putVarLong(lob.getType().getPrecision());
                    break;
                }
                buff.putVarInt(small.length).put(small);
                break;
            }
            case 17: 
            case 39: {
                Value[] list = ((ValueCollectionBase)v).getList();
                buff.put(type == 17 ? (byte)17 : 27).putVarInt(list.length);
                for (Value x : list) {
                    this.writeValue(buff, x);
                }
                break;
            }
            case 18: {
                buff.put((byte)18);
                ResultInterface result = ((ValueResultSet)v).getResult();
                int columnCount = result.getVisibleColumnCount();
                buff.putVarInt(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    ValueDataType.writeString(buff, result.getAlias(i));
                    ValueDataType.writeString(buff, result.getColumnName(i));
                    TypeInfo columnType = result.getColumnType(i);
                    buff.putVarInt(columnType.getValueType()).putVarLong(columnType.getPrecision()).putVarInt(columnType.getScale());
                }
                while (result.next()) {
                    buff.put((byte)1);
                    Value[] row = result.currentRow();
                    for (int i = 0; i < columnCount; ++i) {
                        this.writeValue(buff, row[i]);
                    }
                }
                buff.put((byte)0);
                break;
            }
            case 22: {
                byte[] b = v.getBytes();
                int len = b.length;
                buff.put((byte)22).putVarInt(len).put(b);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                ValueInterval interval = (ValueInterval)v;
                int ordinal = type - 26;
                if (interval.isNegative()) {
                    ordinal ^= 0xFFFFFFFF;
                }
                buff.put((byte)26).put((byte)ordinal).putVarLong(interval.getLeading());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                ValueInterval interval = (ValueInterval)v;
                int ordinal = type - 26;
                if (interval.isNegative()) {
                    ordinal ^= 0xFFFFFFFF;
                }
                buff.put((byte)26).put((byte)ordinal).putVarLong(interval.getLeading()).putVarLong(interval.getRemaining());
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    byte[] b = v.getBytesNoCopy();
                    buff.put((byte)-123).putVarInt(type).putVarInt(b.length).put(b);
                    break;
                }
                DbException.throwInternalError("type=" + v.getValueType());
            }
        }
    }

    private static void writeString(WriteBuffer buff, String s2) {
        int len = s2.length();
        buff.putVarInt(len).putStringData(s2, len);
    }

    private Object readValue(ByteBuffer buff) {
        int type = buff.get() & 0xFF;
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInt.get(-ValueDataType.readVarInt(buff));
            }
            case 4: 
            case 25: {
                return ValueInt.get(ValueDataType.readVarInt(buff));
            }
            case 67: {
                return ValueLong.get(-ValueDataType.readVarLong(buff));
            }
            case 5: {
                return ValueLong.get(ValueDataType.readVarLong(buff));
            }
            case 2: {
                return ValueByte.get(buff.get());
            }
            case 3: {
                return ValueShort.get(buff.getShort());
            }
            case 56: {
                return ValueDecimal.ZERO;
            }
            case 57: {
                return ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(buff)));
            }
            case 59: {
                int scale = ValueDataType.readVarInt(buff);
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(buff), scale));
            }
            case 6: {
                int scale = ValueDataType.readVarInt(buff);
                int len = ValueDataType.readVarInt(buff);
                byte[] buff2 = Utils.newBytes(len);
                buff.get(buff2, 0, len);
                BigInteger b = new BigInteger(buff2);
                return ValueDecimal.get(new BigDecimal(b, scale));
            }
            case 10: {
                return ValueDate.fromDateValue(ValueDataType.readVarLong(buff));
            }
            case 9: {
                long nanos = ValueDataType.readVarLong(buff) * 1000000L + ValueDataType.readVarLong(buff);
                return ValueTime.fromNanos(nanos);
            }
            case 11: {
                long dateValue = ValueDataType.readVarLong(buff);
                long nanos = ValueDataType.readVarLong(buff) * 1000000L + ValueDataType.readVarLong(buff);
                return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
            }
            case 24: {
                long dateValue = ValueDataType.readVarLong(buff);
                long nanos = ValueDataType.readVarLong(buff) * 1000000L + ValueDataType.readVarLong(buff);
                short tz = (short)ValueDataType.readVarInt(buff);
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tz);
            }
            case 12: {
                int len = ValueDataType.readVarInt(buff);
                byte[] b = Utils.newBytes(len);
                buff.get(b, 0, len);
                return ValueBytes.getNoCopy(b);
            }
            case 19: {
                int len = ValueDataType.readVarInt(buff);
                byte[] b = Utils.newBytes(len);
                buff.get(b, 0, len);
                return ValueJavaObject.getNoCopy(null, b, this.handler);
            }
            case 20: {
                return ValueUuid.get(buff.getLong(), buff.getLong());
            }
            case 13: {
                return ValueString.get(ValueDataType.readString(buff));
            }
            case 14: {
                return ValueStringIgnoreCase.get(ValueDataType.readString(buff));
            }
            case 21: {
                return ValueStringFixed.get(ValueDataType.readString(buff));
            }
            case 26: {
                boolean negative;
                int ordinal = buff.get();
                boolean bl = negative = ordinal < 0;
                if (negative) {
                    ordinal ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(ordinal), negative, ValueDataType.readVarLong(buff), ordinal < 5 ? 0L : ValueDataType.readVarLong(buff));
            }
            case 62: {
                return ValueFloat.ZERO;
            }
            case 63: {
                return ValueFloat.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(ValueDataType.readVarLong(buff))));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(ValueDataType.readVarInt(buff))));
            }
            case 15: 
            case 16: {
                int smallLen = ValueDataType.readVarInt(buff);
                if (smallLen >= 0) {
                    byte[] small = Utils.newBytes(smallLen);
                    buff.get(small, 0, smallLen);
                    return ValueLobDb.createSmallLob(type == 15 ? 15 : 16, small);
                }
                if (smallLen == -3) {
                    int tableId = ValueDataType.readVarInt(buff);
                    long lobId = ValueDataType.readVarLong(buff);
                    long precision = ValueDataType.readVarLong(buff);
                    return ValueLobDb.create(type == 15 ? 15 : 16, this.handler, tableId, lobId, null, precision);
                }
                throw DbException.get(90030, "lob type: " + smallLen);
            }
            case 17: 
            case 27: {
                int len = ValueDataType.readVarInt(buff);
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = (Value)this.readValue(buff);
                }
                return type == 17 ? ValueArray.get(list) : ValueRow.get(list);
            }
            case 18: {
                SimpleResult rs = new SimpleResult();
                int columns = ValueDataType.readVarInt(buff);
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(ValueDataType.readString(buff), ValueDataType.readString(buff), ValueDataType.readVarInt(buff), ValueDataType.readVarLong(buff), ValueDataType.readVarInt(buff));
                }
                while (buff.get() != 0) {
                    Value[] o = new Value[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = (Value)this.readValue(buff);
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
            case 22: {
                int len = ValueDataType.readVarInt(buff);
                byte[] b = Utils.newBytes(len);
                buff.get(b, 0, len);
                return ValueGeometry.get(b);
            }
            case 132: {
                return this.getSpatialDataType().read(buff);
            }
            case 133: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    int customType = ValueDataType.readVarInt(buff);
                    int len = ValueDataType.readVarInt(buff);
                    byte[] b = Utils.newBytes(len);
                    buff.get(b, 0, len);
                    return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(b), customType);
                }
                throw DbException.get(50004, "No CustomDataTypesHandler has been set up");
            }
        }
        if (type >= 32 && type < 48) {
            return ValueInt.get(type - 32);
        }
        if (type >= 48 && type < 56) {
            return ValueLong.get(type - 48);
        }
        if (type >= 100 && type < 132) {
            int len = type - 100;
            byte[] b = Utils.newBytes(len);
            buff.get(b, 0, len);
            return ValueBytes.getNoCopy(b);
        }
        if (type >= 68 && type < 100) {
            return ValueString.get(ValueDataType.readString(buff, type - 68));
        }
        throw DbException.get(90030, "type: " + type);
    }

    private static int readVarInt(ByteBuffer buff) {
        return DataUtils.readVarInt(buff);
    }

    private static long readVarLong(ByteBuffer buff) {
        return DataUtils.readVarLong(buff);
    }

    private static String readString(ByteBuffer buff, int len) {
        return DataUtils.readString(buff, len);
    }

    private static String readString(ByteBuffer buff) {
        int len = ValueDataType.readVarInt(buff);
        return DataUtils.readString(buff, len);
    }

    public int hashCode() {
        return this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueDataType)) {
            return false;
        }
        ValueDataType v = (ValueDataType)obj;
        if (!this.compareMode.equals(v.compareMode)) {
            return false;
        }
        return Arrays.equals(this.sortTypes, v.sortTypes);
    }
}

