/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public class MVPrimaryIndex
extends BaseIndex {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Value, Value> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database db, MVTable table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, table.getName() + "_DATA", columns, indexType);
        this.mvTable = table;
        int[] sortTypes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            sortTypes[i] = 0;
        }
        ValueDataType keyType = new ValueDataType();
        ValueDataType valueType = new ValueDataType(db, sortTypes);
        this.mapName = "table." + this.getId();
        assert (db.isStarting() || !db.getStore().getMvStore().getMetaMap().containsKey("name." + this.mapName));
        Transaction t2 = this.mvTable.getTransactionBegin();
        this.dataMap = t2.openMap(this.mapName, keyType, valueType);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        t2.commit();
        Value k = (Value)this.dataMap.map.lastKey();
        this.lastKey.set(k == null ? 0L : k.getLong());
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int mainIndexColumn) {
        this.mainIndexColumn = mainIndexColumn;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        long last;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            long c = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(c);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                Value v2 = v.copy(this.database, this.getId());
                if (v2.isLinkedToTable()) {
                    session.removeAtCommitStop(v2);
                }
                if (v == v2) continue;
                row.setValue(i, v2);
            }
        }
        TransactionMap<Value, Value> map = this.getMap(session);
        long rowKey = row.getKey();
        ValueLong key = ValueLong.get(rowKey);
        try {
            Value oldValue = map.putIfAbsent(key, ValueArray.get(row.getValueList()));
            if (oldValue != null) {
                StringBuilder builder = new StringBuilder("PRIMARY KEY ON ");
                this.table.getSQL(builder, false);
                if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
                    builder.append('(');
                    this.indexColumns[this.mainIndexColumn].getSQL(builder, false).append(')');
                }
                int errorCode = 90131;
                if (map.get(key) != null) {
                    errorCode = 23505;
                }
                builder.append(' ').append(oldValue);
                DbException e = DbException.get(errorCode, builder.toString());
                e.setSource(this);
                throw e;
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        while (rowKey > (last = this.lastKey.get()) && !this.lastKey.compareAndSet(last, rowKey)) {
        }
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                if (!v.isLinkedToTable()) continue;
                session.removeAtCommit(v);
            }
        }
        TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value old = map.remove(ValueLong.get(row.getKey()));
            if (old == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, false).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void update(Session session, Row oldRow, Row newRow) {
        if (this.mainIndexColumn != -1) {
            long c = newRow.getValue(this.mainIndexColumn).getLong();
            newRow.setKey(c);
        }
        long key = oldRow.getKey();
        assert (this.mainIndexColumn != -1 || key != 0L);
        assert (key == newRow.getKey()) : key + " != " + newRow.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int len = oldRow.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v2;
                Value newValue;
                Value oldValue = oldRow.getValue(i);
                if (oldValue == (newValue = newRow.getValue(i))) continue;
                if (oldValue.isLinkedToTable()) {
                    session.removeAtCommit(oldValue);
                }
                if ((v2 = newValue.copy(this.database, this.getId())).isLinkedToTable()) {
                    session.removeAtCommitStop(v2);
                }
                if (newValue == v2) continue;
                newRow.setValue(i, v2);
            }
        }
        TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value existing = map.put(ValueLong.get(key), ValueArray.get(newRow.getValueList()));
            if (existing == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, false).append(": ").append(key);
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (newRow.getKey() > this.lastKey.get()) {
            this.lastKey.set(newRow.getKey());
        }
    }

    Row lockRow(Session session, Row row) {
        long key;
        TransactionMap<Value, Value> map = this.getMap(session);
        ValueArray array = (ValueArray)this.lockRow(map, key = row.getKey());
        return array == null ? null : MVPrimaryIndex.getRow(session, key, array);
    }

    private Value lockRow(TransactionMap<Value, Value> map, long key) {
        try {
            return map.lock(ValueLong.get(key));
        }
        catch (IllegalStateException ex) {
            throw this.mvTable.convertException(ex);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        ValueLong min2 = this.extractPKFromRow(first, ValueLong.MIN);
        ValueLong max = this.extractPKFromRow(last, ValueLong.MAX);
        TransactionMap<Value, Value> map = this.getMap(session);
        return new MVStoreCursor(session, map.entryIterator(min2, max));
    }

    private ValueLong extractPKFromRow(SearchRow row, ValueLong defaultValue) {
        ValueLong v;
        ValueLong result = row == null ? defaultValue : (this.mainIndexColumn == -1 ? ValueLong.get(row.getKey()) : ((v = (ValueLong)row.getValue(this.mainIndexColumn)) == null ? ValueLong.get(row.getKey()) : v));
        return result;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long key) {
        TransactionMap<Value, Value> map = this.getMap(session);
        Value v = map.get(ValueLong.get(key));
        if (v == null) {
            throw DbException.get(90143, this.getSQL(false), String.valueOf(key));
        }
        return MVPrimaryIndex.getRow(session, key, (ValueArray)v);
    }

    private static Row getRow(Session session, long key, ValueArray array) {
        Row row = session.createRow(array.getList(), 0);
        row.setKey(key);
        return row;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, true, allColumnsSet);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void remove(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t2 = session.getTransaction();
            t2.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        TransactionMap<Value, Value> map = this.getMap(session);
        ValueLong v = (ValueLong)(first ? map.firstKey() : map.lastKey());
        if (v == null) {
            return new MVStoreCursor(session, Collections.emptyIterator());
        }
        Value value = map.get(v);
        AbstractMap.SimpleImmutableEntry<ValueLong, Value> e = new AbstractMap.SimpleImmutableEntry<ValueLong, Value>(v, value);
        List<AbstractMap.SimpleImmutableEntry<ValueLong, Value>> list = Collections.singletonList(e);
        MVStoreCursor c = new MVStoreCursor(session, list.iterator());
        c.next();
        return c;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.dataMap.map.getRootPage().getDiskSpaceUsed();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void checkRename() {
    }

    ValueLong getKey(SearchRow row, ValueLong ifEmpty, ValueLong ifNull) {
        if (row == null) {
            return ifEmpty;
        }
        Value v = row.getValue(this.mainIndexColumn);
        if (v == null) {
            throw DbException.throwInternalError(row.toString());
        }
        if (v == ValueNull.INSTANCE) {
            return ifNull;
        }
        return (ValueLong)v.convertTo(5);
    }

    Cursor find(Session session, ValueLong first, ValueLong last) {
        TransactionMap<Value, Value> map = this.getMap(session);
        return new MVStoreCursor(session, map.entryIterator(first, last));
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t2 = session.getTransaction();
        return this.dataMap.getInstance(t2);
    }

    static class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Map.Entry<Value, Value>> it;
        private Map.Entry<Value, Value> current;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Map.Entry<Value, Value>> it) {
            this.session = session;
            this.it = it;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                ValueArray array = (ValueArray)this.current.getValue();
                this.row = this.session.createRow(array.getList(), 0);
                this.row.setKey(this.current.getKey().getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

