/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.List;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVIndex;
import org.gridgain.internal.h2.mvstore.db.MVPrimaryIndex;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.ValueLong;

public class MVDelegateIndex
extends BaseIndex
implements MVIndex {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable table, int id, String name, MVPrimaryIndex mainIndex, IndexType indexType) {
        super(table, id, name, IndexColumn.wrap(new Column[]{table.getColumn(mainIndex.getMainIndexColumn())}), indexType);
        this.mainIndex = mainIndex;
        if (id < 0) {
            throw DbException.throwInternalError(name);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.throwInternalError();
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.mainIndex.getRow(session, key);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        ValueLong min2 = this.mainIndex.getKey(first, ValueLong.MIN, ValueLong.MIN);
        ValueLong max = this.mainIndex.getKey(last, ValueLong.MAX, ValueLong.MIN);
        return this.mainIndex.find(session, min2, max);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        return this.mainIndex.findFirstOrLast(session, first);
    }

    @Override
    public int getColumnIndex(Column col) {
        if (col.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.getColumnIndex(column) == 0;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 10L * this.getCostRangeIndex(masks, this.mainIndex.getRowCountApproximation(session), filters, filter, sortOrder, true, allColumnsSet);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void update(Session session, Row oldRow, Row newRow) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.mainIndex.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

