/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.gridgain.internal.h2.jdbcx.JdbcConnectionPoolBackwardsCompat;
import org.gridgain.internal.h2.jdbcx.JdbcDataSource;
import org.gridgain.internal.h2.message.DbException;

public class JdbcConnectionPool
implements DataSource,
ConnectionEventListener,
JdbcConnectionPoolBackwardsCompat {
    private static final int DEFAULT_TIMEOUT = 30;
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private final ConnectionPoolDataSource dataSource;
    private final Queue<PooledConnection> recycledConnections = new ConcurrentLinkedQueue<PooledConnection>();
    private PrintWriter logWriter;
    private volatile int maxConnections = 10;
    private volatile int timeout = 30;
    private AtomicInteger activeConnections = new AtomicInteger();
    private AtomicBoolean isDisposed = new AtomicBoolean();

    protected JdbcConnectionPool(ConnectionPoolDataSource dataSource) {
        this.dataSource = dataSource;
        if (dataSource != null) {
            try {
                this.logWriter = dataSource.getLogWriter();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static JdbcConnectionPool create(ConnectionPoolDataSource dataSource) {
        return new JdbcConnectionPool(dataSource);
    }

    public static JdbcConnectionPool create(String url, String user, String password) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(url);
        ds.setUser(user);
        ds.setPassword(password);
        return new JdbcConnectionPool(ds);
    }

    public void setMaxConnections(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value: " + max);
        }
        this.maxConnections = max;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getLoginTimeout() {
        return this.timeout;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        if (seconds == 0) {
            seconds = 30;
        }
        this.timeout = seconds;
    }

    public void dispose() {
        PooledConnection pc;
        this.isDisposed.set(true);
        while ((pc = this.recycledConnections.poll()) != null) {
            this.closeConnection(pc);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        long max = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.timeout);
        int spin = 0;
        do {
            if (this.activeConnections.incrementAndGet() <= this.maxConnections) {
                try {
                    return this.getConnectionNow();
                }
                catch (Throwable t2) {
                    this.activeConnections.decrementAndGet();
                    throw t2;
                }
            }
            this.activeConnections.decrementAndGet();
            if (--spin >= 0) continue;
            try {
                spin = 3;
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (System.nanoTime() - max <= 0L);
        throw new SQLException("Login timeout", "08001", 8001);
    }

    @Override
    public Connection getConnection(String user, String password) {
        throw new UnsupportedOperationException();
    }

    private Connection getConnectionNow() throws SQLException {
        if (this.isDisposed.get()) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pc = this.recycledConnections.poll();
        if (pc == null) {
            pc = this.dataSource.getPooledConnection();
        }
        Connection conn = pc.getConnection();
        pc.addConnectionEventListener(this);
        return conn;
    }

    private void recycleConnection(PooledConnection pc) {
        int active = this.activeConnections.decrementAndGet();
        if (active < 0) {
            this.activeConnections.incrementAndGet();
            throw new AssertionError();
        }
        if (!this.isDisposed.get() && active < this.maxConnections) {
            this.recycledConnections.add(pc);
            if (this.isDisposed.get()) {
                this.dispose();
            }
        } else {
            this.closeConnection(pc);
        }
    }

    private void closeConnection(PooledConnection pc) {
        block2: {
            try {
                pc.close();
            }
            catch (SQLException e) {
                if (this.logWriter == null) break block2;
                e.printStackTrace(this.logWriter);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        pc.removeConnectionEventListener(this);
        this.recycleConnection(pc);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
    }

    public int getActiveConnections() {
        return this.activeConnections.get();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw DbException.getUnsupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw DbException.getUnsupportedException("isWrapperFor");
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

