/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.PageBtree;
import org.gridgain.internal.h2.index.PageBtreeCursor;
import org.gridgain.internal.h2.index.PageBtreeLeaf;
import org.gridgain.internal.h2.index.PageBtreeNode;
import org.gridgain.internal.h2.index.PageIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.Page;
import org.gridgain.internal.h2.store.PageStore;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class PageBtreeIndex
extends PageIndex {
    private static int memoryChangeRequired;
    private final PageStore store;
    private final PageStoreTable tableData;
    private final boolean needRebuild;
    private long rowCount;
    private int memoryPerPage;
    private int memoryCount;

    public PageBtreeIndex(PageStoreTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType, boolean create, Session session) {
        super(table, id, indexName, columns, indexType);
        if (!this.database.isStarting() && create) {
            PageBtreeIndex.checkIndexColumnTypes(columns);
        }
        this.tableData = table;
        if (!this.database.isPersistent() || id < 0) {
            throw DbException.throwInternalError(indexName);
        }
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (create) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageBtreeLeaf root = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.store.logUndo(root, null);
            this.store.update(root);
        } else {
            this.rootPageId = this.store.getRootPageId(id);
            PageBtree root = this.getPage(this.rootPageId);
            this.rowCount = root.getRowCount();
        }
        boolean bl = this.needRebuild = create || this.rowCount == 0L && this.store.isRecoveryRunning();
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened {0} rows: {1}", this.getName(), this.rowCount);
        }
        this.memoryPerPage = 184 + this.store.getPageSize() >> 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        SearchRow newRow = this.getSearchRow(row);
        try {
            this.addRow(newRow);
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    private void addRow(SearchRow newRow) {
        PageBtree root;
        int splitPoint;
        while ((splitPoint = (root = this.getPage(this.rootPageId)).addRowTry(newRow)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split {0}", splitPoint);
            }
            SearchRow pivot = root.getRow(splitPoint - 1);
            this.store.logUndo(root, root.data);
            PageBtree page1 = root;
            PageBtree page2 = root.split(splitPoint);
            this.store.logUndo(page2, null);
            int id = this.store.allocatePage();
            page1.setPageId(id);
            page1.setParentPageId(this.rootPageId);
            page2.setParentPageId(this.rootPageId);
            PageBtreeNode newRoot = PageBtreeNode.create(this, this.rootPageId, 0);
            this.store.logUndo(newRoot, null);
            newRoot.init(page1, pivot, page2);
            this.store.update(page1);
            this.store.update(page2);
            this.store.update(newRoot);
            PageBtreeNode pageBtreeNode = newRoot;
        }
        this.invalidateRowCount();
        ++this.rowCount;
    }

    private SearchRow getSearchRow(Row row) {
        SearchRow r = this.table.getTemplateSimpleRow(this.columns.length == 1);
        r.setKey(row);
        for (Column c : this.columns) {
            int idx = c.getColumnId();
            r.setValue(idx, row.getValue(idx));
        }
        return r;
    }

    PageBtree getPage(int id) {
        Page p = this.store.getPage(id);
        if (p == null) {
            PageBtreeLeaf empty = PageBtreeLeaf.create(this, id, 0);
            this.store.logUndo(empty, null);
            this.store.update(empty);
            return empty;
        }
        if (!(p instanceof PageBtree)) {
            throw DbException.get(90030, String.valueOf(p));
        }
        return (PageBtree)p;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, true, last);
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, false, last);
    }

    private Cursor find(Session session, SearchRow first, boolean bigger, SearchRow last) {
        if (this.store == null) {
            throw DbException.get(90007);
        }
        PageBtree root = this.getPage(this.rootPageId);
        PageBtreeCursor cursor = new PageBtreeCursor(session, this, last);
        root.find(cursor, first, bigger);
        return cursor;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        SearchRow row;
        if (first) {
            Cursor cursor = this.find(session, null, false, null);
            while (cursor.next()) {
                SearchRow row2 = cursor.getSearchRow();
                Value v = row2.getValue(this.columnIds[0]);
                if (v == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        PageBtree root = this.getPage(this.rootPageId);
        PageBtreeCursor cursor = new PageBtreeCursor(session, this, null);
        root.last(cursor);
        cursor.previous();
        while ((row = cursor.getSearchRow()) != null) {
            Value v = row.getValue(this.columnIds[0]);
            if (v != ValueNull.INSTANCE) {
                return cursor;
            }
            if (cursor.previous()) continue;
        }
        return cursor;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 10L * this.getCostRangeIndex(masks, this.tableData.getRowCount(session), filters, filter, sortOrder, false, allColumnsSet);
    }

    @Override
    public boolean needRebuild() {
        return this.needRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            try {
                PageBtree root = this.getPage(this.rootPageId);
                root.remove(row);
                this.invalidateRowCount();
                --this.rowCount;
            }
            finally {
                this.store.incrementChangeCount();
            }
        }
    }

    @Override
    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.free(this.rootPageId);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() {
        try {
            PageBtree root = this.getPage(this.rootPageId);
            root.freeRecursive();
            root = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.store.removeFromCache(this.rootPageId);
            this.store.update(root);
            this.rowCount = 0L;
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public void checkRename() {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.tableData.getRow(session, key);
    }

    PageStore getPageStore() {
        return this.store;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.tableData.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.tableData.getDiskSpaceUsed();
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
        try {
            this.writeRowCount();
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchRow readRow(Data data, int offset, boolean onlyPosition, boolean needData) {
        Data data2 = data;
        synchronized (data2) {
            data.setPos(offset);
            long key = data.readVarLong();
            if (onlyPosition) {
                if (needData) {
                    return this.tableData.getRow(null, key);
                }
                SearchRow row = this.table.getTemplateSimpleRow(true);
                row.setKey(key);
                return row;
            }
            SearchRow row = this.table.getTemplateSimpleRow(this.columns.length == 1);
            row.setKey(key);
            for (Column col : this.columns) {
                int idx = col.getColumnId();
                row.setValue(idx, (Value)data.readValue());
            }
            return row;
        }
    }

    SearchRow readRow(long key) {
        return this.tableData.getRow(null, key);
    }

    void writeRow(Data data, int offset, SearchRow row, boolean onlyPosition) {
        data.setPos(offset);
        data.writeVarLong(row.getKey());
        if (!onlyPosition) {
            for (Column col : this.columns) {
                int idx = col.getColumnId();
                data.writeValue(row.getValue(idx));
            }
        }
    }

    int getRowSize(Data dummy, SearchRow row, boolean onlyPosition) {
        int rowsize = Data.getVarLongLen(row.getKey());
        if (!onlyPosition) {
            for (Column col : this.columns) {
                Value v = row.getValue(col.getColumnId());
                rowsize += dummy.getValueLen(v);
            }
        }
        return rowsize;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    void setRootPageId(Session session, int newPos) {
        this.store.removeMeta(this, session);
        this.rootPageId = newPos;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    private void invalidateRowCount() {
        PageBtree root = this.getPage(this.rootPageId);
        root.setRowCountStored(-1);
    }

    @Override
    public void writeRowCount() {
        if (SysProperties.MODIFY_ON_WRITE && this.rootPageId == 0) {
            return;
        }
        PageBtree root = this.getPage(this.rootPageId);
        root.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
    }

    boolean hasData(SearchRow row) {
        return row.getValue(this.columns[0].getColumnId()) != null;
    }

    int getMemoryPerPage() {
        return this.memoryPerPage;
    }

    void memoryChange(int x) {
        this.memoryPerPage = this.memoryCount < 64 ? (this.memoryPerPage += (x - this.memoryPerPage) / ++this.memoryCount) : (this.memoryPerPage += (x > this.memoryPerPage ? 1 : -1) + (x - this.memoryPerPage) / 64);
    }

    static boolean isMemoryChangeRequired() {
        if (memoryChangeRequired-- <= 0) {
            memoryChangeRequired = 10;
            return true;
        }
        return false;
    }
}

