/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.value.Value;

public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    public static final int SPATIAL_INTERSECTS = 16;
    private final Column column;
    private final int compareType;
    private final Expression expression;
    private List<Expression> expressionList;
    private Query expressionQuery;

    private IndexCondition(int compareType, ExpressionColumn column, Expression expression) {
        this.compareType = compareType;
        this.column = column == null ? null : column.getColumn();
        this.expression = expression;
    }

    public static IndexCondition get(int compareType, ExpressionColumn column, Expression expression) {
        return new IndexCondition(compareType, column, expression);
    }

    public static IndexCondition getInList(ExpressionColumn column, List<Expression> list) {
        IndexCondition cond = new IndexCondition(9, column, null);
        cond.expressionList = list;
        return cond;
    }

    public static IndexCondition getInQuery(ExpressionColumn column, Query query2) {
        assert (query2.isRandomAccessResult());
        IndexCondition cond = new IndexCondition(10, column, null);
        cond.expressionQuery = query2;
        return cond;
    }

    public Value getCurrentValue(Session session) {
        return this.expression.getValue(session);
    }

    public Value[] getCurrentValueList(Session session) {
        TreeSet<Value> valueSet = new TreeSet<Value>(session.getDatabase().getCompareMode());
        for (Expression e : this.expressionList) {
            Value v = e.getValue(session);
            v = this.column.convert(v);
            valueSet.add(v);
        }
        Value[] array = valueSet.toArray(new Value[valueSet.size()]);
        Arrays.sort(array, session.getDatabase().getCompareMode());
        return array;
    }

    public ResultInterface getCurrentResult() {
        return this.expressionQuery.query(0);
    }

    public String getSQL(boolean alwaysQuote) {
        if (this.compareType == 8) {
            return "FALSE";
        }
        StringBuilder builder = new StringBuilder();
        this.column.getSQL(builder, alwaysQuote);
        switch (this.compareType) {
            case 0: {
                builder.append(" = ");
                break;
            }
            case 16: {
                builder.append(" IS ");
                break;
            }
            case 1: {
                builder.append(" >= ");
                break;
            }
            case 2: {
                builder.append(" > ");
                break;
            }
            case 3: {
                builder.append(" <= ");
                break;
            }
            case 4: {
                builder.append(" < ");
                break;
            }
            case 9: {
                builder.append(" IN(");
                Expression.writeExpressions(builder, this.expressionList, alwaysQuote);
                builder.append(')');
                break;
            }
            case 10: {
                builder.append(" IN(");
                builder.append(this.expressionQuery.getPlanSQL(alwaysQuote));
                builder.append(')');
                break;
            }
            case 11: {
                builder.append(" && ");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (this.expression != null) {
            this.expression.getSQL(builder, alwaysQuote);
        }
        return builder.toString();
    }

    public int getMask(ArrayList<IndexCondition> indexConditions) {
        switch (this.compareType) {
            case 8: {
                return 8;
            }
            case 0: 
            case 16: {
                return 1;
            }
            case 9: 
            case 10: {
                if (indexConditions.size() > 1 && TableType.TABLE != this.column.getTable().getTableType()) {
                    return 0;
                }
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 11: {
                return 16;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 8;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 4: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isSpatialIntersects() {
        switch (this.compareType) {
            case 11: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public Column getColumn() {
        return this.column;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    public Query getExpressionQuery() {
        return this.expressionQuery;
    }

    public boolean isEvaluatable() {
        if (this.expression != null) {
            return this.expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
        }
        if (this.expressionList != null) {
            for (Expression e : this.expressionList) {
                if (e.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
                return false;
            }
            return true;
        }
        return this.expressionQuery.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("column=").append(this.column).append(", compareType=");
        return IndexCondition.compareTypeToString(builder, this.compareType).append(", expression=").append(this.expression).append(", expressionList=").append(this.expressionList).append(", expressionQuery=").append(this.expressionQuery).toString();
    }

    public static int[] createMasksForTable(Table tbl, ArrayList<IndexCondition> idxConditions) {
        int len = tbl.getColumns().length;
        int[] masks = new int[len];
        for (IndexCondition condition : idxConditions) {
            if (!condition.isEvaluatable()) continue;
            if (condition.isAlwaysFalse()) {
                masks = null;
                break;
            }
            int id = condition.getColumn().getColumnId();
            if (id < 0) continue;
            int n = id;
            masks[n] = masks[n] | condition.getMask(idxConditions);
        }
        return masks;
    }

    private static StringBuilder compareTypeToString(StringBuilder builder, int i) {
        boolean f = false;
        if ((i & 1) == 1) {
            f = true;
            builder.append("EQUALITY");
        }
        if ((i & 2) == 2) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("START");
        }
        if ((i & 4) == 4) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("END");
        }
        if ((i & 8) == 8) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("ALWAYS_FALSE");
        }
        if ((i & 0x10) == 16) {
            if (f) {
                builder.append(", ");
            }
            builder.append("SPATIAL_INTERSECTS");
        }
        return builder;
    }
}

