/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class ToChar {
    static final int JULIAN_EPOCH = -2440588;
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_NUMERALS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    static final int MONTHS = 0;
    static final int SHORT_MONTHS = 1;
    static final int WEEKDAYS = 2;
    static final int SHORT_WEEKDAYS = 3;
    static final int AM_PM = 4;
    private static volatile String[][] NAMES;

    private ToChar() {
    }

    public static String toChar(BigDecimal number, String format, String nlsParam) {
        int i;
        int separator;
        int formatScale;
        boolean fillMode;
        Integer power;
        int v;
        boolean angleBrackets;
        boolean trailingMinus;
        boolean trailingSign;
        String formatUp;
        String string = formatUp = format != null ? StringUtils.toUpperEnglish(format) : null;
        if (formatUp == null || formatUp.equals("TM") || formatUp.equals("TM9")) {
            String s2 = number.toPlainString();
            return s2.startsWith("0.") ? s2.substring(1) : s2;
        }
        if (formatUp.equals("TME")) {
            int pow = number.precision() - number.scale() - 1;
            number = number.movePointLeft(pow);
            return number.toPlainString() + "E" + (pow < 0 ? (char)'-' : '+') + (Math.abs(pow) < 10 ? "0" : "") + Math.abs(pow);
        }
        if (formatUp.equals("RN")) {
            boolean lowercase = format.startsWith("r");
            String rn = StringUtils.pad(ToChar.toRomanNumeral(number.intValue()), 15, " ", false);
            return lowercase ? rn.toLowerCase() : rn;
        }
        if (formatUp.equals("FMRN")) {
            boolean lowercase = format.charAt(2) == 'r';
            String rn = ToChar.toRomanNumeral(number.intValue());
            return lowercase ? rn.toLowerCase() : rn;
        }
        if (formatUp.endsWith("X")) {
            return ToChar.toHex(number, format);
        }
        String originalFormat = format;
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        char localGrouping = symbols.getGroupingSeparator();
        char localDecimal = symbols.getDecimalSeparator();
        boolean leadingSign = formatUp.startsWith("S");
        if (leadingSign) {
            format = format.substring(1);
        }
        if (trailingSign = formatUp.endsWith("S")) {
            format = format.substring(0, format.length() - 1);
        }
        if (trailingMinus = formatUp.endsWith("MI")) {
            format = format.substring(0, format.length() - 2);
        }
        if (angleBrackets = formatUp.endsWith("PR")) {
            format = format.substring(0, format.length() - 2);
        }
        if ((v = formatUp.indexOf(86)) >= 0) {
            int digits = 0;
            for (int i2 = v + 1; i2 < format.length(); ++i2) {
                char c = format.charAt(i2);
                if (c != '0' && c != '9') continue;
                ++digits;
            }
            number = number.movePointRight(digits);
            format = format.substring(0, v) + format.substring(v + 1);
        }
        if (format.endsWith("EEEE")) {
            power = number.precision() - number.scale() - 1;
            number = number.movePointLeft(power);
            format = format.substring(0, format.length() - 4);
        } else {
            power = null;
        }
        int maxLength = 1;
        boolean bl = fillMode = !formatUp.startsWith("FM");
        if (!fillMode) {
            format = format.substring(2);
        }
        if ((formatScale = ToChar.calculateScale(format = format.replaceAll("[Bb]", ""), separator = ToChar.findDecimalSeparator(format))) < number.scale()) {
            number = number.setScale(formatScale, RoundingMode.HALF_UP);
        }
        for (int i3 = format.indexOf(48); i3 >= 0 && i3 < separator; ++i3) {
            if (format.charAt(i3) != '9') continue;
            format = format.substring(0, i3) + "0" + format.substring(i3 + 1);
        }
        StringBuilder output = new StringBuilder();
        String unscaled = (number.abs().compareTo(BigDecimal.ONE) < 0 ? ToChar.zeroesAfterDecimalSeparator(number) : "") + number.unscaledValue().abs().toString();
        int j = unscaled.length() - number.scale() - 1;
        for (i = separator - 1; i >= 0; --i) {
            char c = format.charAt(i);
            ++maxLength;
            if (c == '9' || c == '0') {
                if (j >= 0) {
                    char digit = unscaled.charAt(j);
                    output.insert(0, digit);
                    --j;
                    continue;
                }
                if (c != '0' || power != null) continue;
                output.insert(0, '0');
                continue;
            }
            if (c == ',') {
                if (j < 0 && (i <= 0 || format.charAt(i - 1) != '0')) continue;
                output.insert(0, c);
                continue;
            }
            if (c == 'G' || c == 'g') {
                if (j < 0 && (i <= 0 || format.charAt(i - 1) != '0')) continue;
                output.insert(0, localGrouping);
                continue;
            }
            if (c == 'C' || c == 'c') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                output.insert(0, currency.getCurrencyCode());
                maxLength += 6;
                continue;
            }
            if (c == 'L' || c == 'l' || c == 'U' || c == 'u') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                output.insert(0, currency.getSymbol());
                maxLength += 9;
                continue;
            }
            if (c == '$') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                String cs = currency.getSymbol();
                output.insert(0, cs);
                continue;
            }
            throw DbException.get(90010, originalFormat);
        }
        if (j >= 0) {
            return StringUtils.pad("", format.length() + 1, "#", true);
        }
        if (separator < format.length()) {
            ++maxLength;
            char pt = format.charAt(separator);
            if (pt == 'd' || pt == 'D') {
                output.append(localDecimal);
            } else {
                output.append(pt);
            }
            j = unscaled.length() - number.scale();
            for (i = separator + 1; i < format.length(); ++i) {
                char c = format.charAt(i);
                ++maxLength;
                if (c == '9' || c == '0') {
                    if (j < unscaled.length()) {
                        char digit = unscaled.charAt(j);
                        output.append(digit);
                        ++j;
                        continue;
                    }
                    if (c != '0' && !fillMode) continue;
                    output.append('0');
                    continue;
                }
                throw DbException.get(90010, originalFormat);
            }
        }
        ToChar.addSign(output, number.signum(), leadingSign, trailingSign, trailingMinus, angleBrackets, fillMode);
        if (power != null) {
            output.append('E');
            output.append(power < 0 ? (char)'-' : '+');
            output.append(Math.abs(power) < 10 ? "0" : "");
            output.append(Math.abs(power));
        }
        if (fillMode) {
            if (power != null) {
                output.insert(0, ' ');
            } else {
                while (output.length() < maxLength) {
                    output.insert(0, ' ');
                }
            }
        }
        return output.toString();
    }

    private static String zeroesAfterDecimalSeparator(BigDecimal number) {
        int i;
        String numberStr = number.toPlainString();
        int idx = numberStr.indexOf(46);
        if (idx < 0) {
            return "";
        }
        boolean allZeroes = true;
        int length = numberStr.length();
        for (i = idx + 1; i < length; ++i) {
            if (numberStr.charAt(i) == '0') continue;
            allZeroes = false;
            break;
        }
        char[] zeroes = new char[allZeroes ? length - idx - 1 : i - 1 - idx];
        Arrays.fill(zeroes, '0');
        return String.valueOf(zeroes);
    }

    private static void addSign(StringBuilder output, int signum, boolean leadingSign, boolean trailingSign, boolean trailingMinus, boolean angleBrackets, boolean fillMode) {
        if (angleBrackets) {
            if (signum < 0) {
                output.insert(0, '<');
                output.append('>');
            } else if (fillMode) {
                output.insert(0, ' ');
                output.append(' ');
            }
        } else {
            String sign = signum == 0 ? "" : (signum < 0 ? "-" : (leadingSign || trailingSign ? "+" : (fillMode ? " " : "")));
            if (trailingMinus || trailingSign) {
                output.append(sign);
            } else {
                output.insert(0, sign);
            }
        }
    }

    private static int findDecimalSeparator(String format) {
        int index = format.indexOf(46);
        if (index == -1 && (index = format.indexOf(68)) == -1 && (index = format.indexOf(100)) == -1) {
            index = format.length();
        }
        return index;
    }

    private static int calculateScale(String format, int separator) {
        int scale = 0;
        for (int i = separator; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c != '0' && c != '9') continue;
            ++scale;
        }
        return scale;
    }

    private static String toRomanNumeral(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ROMAN_VALUES.length; ++i) {
            int value = ROMAN_VALUES[i];
            String numeral = ROMAN_NUMERALS[i];
            while (number >= value) {
                result.append(numeral);
                number -= value;
            }
        }
        return result.toString();
    }

    private static String toHex(BigDecimal number, String format) {
        int i;
        boolean fillMode = !StringUtils.toUpperEnglish(format).startsWith("FM");
        boolean uppercase = !format.contains("x");
        boolean zeroPadded = format.startsWith("0");
        int digits = 0;
        for (i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c != '0' && c != 'X' && c != 'x') continue;
            ++digits;
        }
        i = number.setScale(0, RoundingMode.HALF_UP).intValue();
        String hex = Integer.toHexString(i);
        if (digits < hex.length()) {
            hex = StringUtils.pad("", digits + 1, "#", true);
        } else {
            if (uppercase) {
                hex = StringUtils.toUpperEnglish(hex);
            }
            if (zeroPadded) {
                hex = StringUtils.pad(hex, digits, "0", false);
            }
            if (fillMode) {
                hex = StringUtils.pad(hex, format.length() + 1, " ", false);
            }
        }
        return hex;
    }

    static String[] getDateNames(int names) {
        String[][] result = NAMES;
        if (result == null) {
            result = new String[5][];
            DateFormatSymbols dfs = DateFormatSymbols.getInstance();
            result[0] = dfs.getMonths();
            String[] months = dfs.getShortMonths();
            for (int i = 0; i < 12; ++i) {
                String month = months[i];
                if (!month.endsWith(".")) continue;
                months[i] = month.substring(0, month.length() - 1);
            }
            result[1] = months;
            result[2] = dfs.getWeekdays();
            result[3] = dfs.getShortWeekdays();
            result[4] = dfs.getAmPmStrings();
            NAMES = result;
        }
        return result[names];
    }

    private static String getTimeZone(Value value, boolean tzd) {
        if (!(value instanceof ValueTimestampTimeZone)) {
            TimeZone tz = TimeZone.getDefault();
            if (tzd) {
                boolean daylight = tz.inDaylightTime(value.getTimestamp());
                return tz.getDisplayName(daylight, 0);
            }
            return tz.getID();
        }
        return DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)value).getTimeZoneOffsetMins());
    }

    public static String toCharDateTime(Value value, String format, String nlsParam) {
        boolean isAM;
        long[] a = DateTimeUtils.dateAndTimeFromValue(value);
        long dateValue = a[0];
        long timeNanos = a[1];
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        int monthOfYear = DateTimeUtils.monthFromDateValue(dateValue);
        int dayOfMonth = DateTimeUtils.dayFromDateValue(dateValue);
        int posYear = Math.abs(year);
        long second = timeNanos / 1000000000L;
        int nanos = (int)(timeNanos - second * 1000000000L);
        int minute = (int)(second / 60L);
        second -= (long)(minute * 60);
        int hour = minute / 60;
        minute -= hour * 60;
        int h12 = (hour + 11) % 12 + 1;
        boolean bl = isAM = hour < 12;
        if (format == null) {
            format = "DD-MON-YY HH.MI.SS.FF PM";
        }
        StringBuilder output = new StringBuilder();
        boolean fillMode = true;
        int i = 0;
        int length = format.length();
        block0: while (i < length) {
            Capitalization cap = ToChar.containsAt(format, i, "A.D.", "B.C.");
            if (cap != null) {
                String era = year > 0 ? "A.D." : "B.C.";
                output.append(cap.apply(era));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "AD", "BC");
            if (cap != null) {
                String era = year > 0 ? "AD" : "BC";
                output.append(cap.apply(era));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "A.M.", "P.M.");
            if (cap != null) {
                String am = isAM ? "A.M." : "P.M.";
                output.append(cap.apply(am));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "AM", "PM");
            if (cap != null) {
                String am = isAM ? "AM" : "PM";
                output.append(cap.apply(am));
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "DL") != null) {
                String day = ToChar.getDateNames(2)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                String month = ToChar.getDateNames(0)[monthOfYear - 1];
                output.append(day).append(", ").append(month).append(' ').append(dayOfMonth).append(", ");
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "DS") != null) {
                StringUtils.appendZeroPadded(output, 2, monthOfYear);
                output.append('/');
                StringUtils.appendZeroPadded(output, 2, dayOfMonth);
                output.append('/');
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "TS") != null) {
                output.append(h12).append(':');
                StringUtils.appendZeroPadded(output, 2, minute);
                output.append(':');
                StringUtils.appendZeroPadded(output, 2, second);
                output.append(' ');
                output.append(ToChar.getDateNames(4)[isAM ? 0 : 1]);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "DDD") != null) {
                output.append(DateTimeUtils.getDayOfYear(dateValue));
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "DD") != null) {
                StringUtils.appendZeroPadded(output, 2, dayOfMonth);
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DY");
            if (cap != null) {
                String day = ToChar.getDateNames(3)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                output.append(cap.apply(day));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DAY");
            if (cap != null) {
                String day = ToChar.getDateNames(2)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                if (fillMode) {
                    day = StringUtils.pad(day, "Wednesday".length(), " ", true);
                }
                output.append(cap.apply(day));
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "D") != null) {
                output.append(DateTimeUtils.getSundayDayOfWeek(dateValue));
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "J") != null) {
                output.append(DateTimeUtils.absoluteDayFromDateValue(dateValue) - -2440588L);
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "HH24") != null) {
                StringUtils.appendZeroPadded(output, 2, hour);
                i += 4;
                continue;
            }
            if (ToChar.containsAt(format, i, "HH12") != null) {
                StringUtils.appendZeroPadded(output, 2, h12);
                i += 4;
                continue;
            }
            if (ToChar.containsAt(format, i, "HH") != null) {
                StringUtils.appendZeroPadded(output, 2, h12);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "MI") != null) {
                StringUtils.appendZeroPadded(output, 2, minute);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "SSSSS") != null) {
                int seconds = (int)(timeNanos / 1000000000L);
                output.append(seconds);
                i += 5;
                continue;
            }
            if (ToChar.containsAt(format, i, "SS") != null) {
                StringUtils.appendZeroPadded(output, 2, second);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "FF1", "FF2", "FF3", "FF4", "FF5", "FF6", "FF7", "FF8", "FF9") != null) {
                int x = format.charAt(i + 2) - 48;
                int ff = (int)((double)nanos * Math.pow(10.0, x - 9));
                StringUtils.appendZeroPadded(output, x, ff);
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "FF") != null) {
                StringUtils.appendZeroPadded(output, 9, nanos);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "TZR") != null) {
                output.append(ToChar.getTimeZone(value, false));
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "TZD") != null) {
                output.append(ToChar.getTimeZone(value, true));
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "IW", "WW") != null) {
                output.append(DateTimeUtils.getWeekOfYear(dateValue, 0, 1));
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "W") != null) {
                int w = 1 + dayOfMonth / 7;
                output.append(w);
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "Y,YYY") != null) {
                output.append(new DecimalFormat("#,###").format(posYear));
                i += 5;
                continue;
            }
            if (ToChar.containsAt(format, i, "SYYYY") != null) {
                if (year < 0) {
                    output.append('-');
                }
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 5;
                continue;
            }
            if (ToChar.containsAt(format, i, "YYYY", "RRRR") != null) {
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 4;
                continue;
            }
            if (ToChar.containsAt(format, i, "IYYY") != null) {
                StringUtils.appendZeroPadded(output, 4, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)));
                i += 4;
                continue;
            }
            if (ToChar.containsAt(format, i, "YYY") != null) {
                StringUtils.appendZeroPadded(output, 3, posYear % 1000);
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "IYY") != null) {
                StringUtils.appendZeroPadded(output, 3, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 1000);
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "YY", "RR") != null) {
                StringUtils.appendZeroPadded(output, 2, posYear % 100);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "IY") != null) {
                StringUtils.appendZeroPadded(output, 2, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 100);
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "Y") != null) {
                output.append(posYear % 10);
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "I") != null) {
                output.append(Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 10);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MONTH");
            if (cap != null) {
                String month = ToChar.getDateNames(0)[monthOfYear - 1];
                if (fillMode) {
                    month = StringUtils.pad(month, "September".length(), " ", true);
                }
                output.append(cap.apply(month));
                i += 5;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MON");
            if (cap != null) {
                String month = ToChar.getDateNames(1)[monthOfYear - 1];
                output.append(cap.apply(month));
                i += 3;
                continue;
            }
            if (ToChar.containsAt(format, i, "MM") != null) {
                StringUtils.appendZeroPadded(output, 2, monthOfYear);
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "RM");
            if (cap != null) {
                output.append(cap.apply(ToChar.toRomanNumeral(monthOfYear)));
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "Q") != null) {
                int q = 1 + (monthOfYear - 1) / 3;
                output.append(q);
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "X") != null) {
                char c = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                output.append(c);
                ++i;
                continue;
            }
            if (ToChar.containsAt(format, i, "FM") != null) {
                fillMode = !fillMode;
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "FX") != null) {
                i += 2;
                continue;
            }
            if (ToChar.containsAt(format, i, "\"") != null) {
                ++i;
                while (i < format.length()) {
                    char c = format.charAt(i);
                    if (c == '\"') {
                        ++i;
                        continue block0;
                    }
                    output.append(c);
                    ++i;
                }
                continue;
            }
            if (format.charAt(i) == '-' || format.charAt(i) == '/' || format.charAt(i) == ',' || format.charAt(i) == '.' || format.charAt(i) == ';' || format.charAt(i) == ':' || format.charAt(i) == ' ') {
                output.append(format.charAt(i));
                ++i;
                continue;
            }
            throw DbException.get(90010, format);
        }
        return output.toString();
    }

    private static Capitalization containsAt(String s2, int index, String ... substrings) {
        for (String substring : substrings) {
            if (index + substring.length() > s2.length()) continue;
            boolean found = true;
            Boolean up1 = null;
            Boolean up2 = null;
            for (int i = 0; i < substring.length(); ++i) {
                char c2;
                char c1 = s2.charAt(index + i);
                if (c1 != (c2 = substring.charAt(i)) && Character.toUpperCase(c1) != Character.toUpperCase(c2)) {
                    found = false;
                    break;
                }
                if (!Character.isLetter(c1)) continue;
                if (up1 == null) {
                    up1 = Character.isUpperCase(c1);
                    continue;
                }
                if (up2 != null) continue;
                up2 = Character.isUpperCase(c1);
            }
            if (!found) continue;
            return Capitalization.toCapitalization(up1, up2);
        }
        return null;
    }

    public static enum Capitalization {
        UPPERCASE,
        LOWERCASE,
        CAPITALIZE;


        static Capitalization toCapitalization(Boolean up1, Boolean up2) {
            if (up1 == null) {
                return CAPITALIZE;
            }
            if (up2 == null) {
                return up1 != false ? UPPERCASE : LOWERCASE;
            }
            if (up1.booleanValue()) {
                return up2 != false ? UPPERCASE : CAPITALIZE;
            }
            return LOWERCASE;
        }

        public String apply(String s2) {
            if (s2 == null || s2.isEmpty()) {
                return s2;
            }
            switch (this) {
                case UPPERCASE: {
                    return StringUtils.toUpperEnglish(s2);
                }
                case LOWERCASE: {
                    return StringUtils.toLowerEnglish(s2);
                }
                case CAPITALIZE: {
                    return Character.toUpperCase(s2.charAt(0)) + (s2.length() > 1 ? StringUtils.toLowerEnglish(s2).substring(1) : "");
                }
            }
            throw new IllegalArgumentException("Unknown capitalization strategy: " + (Object)((Object)this));
        }
    }
}

