/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.util.IntIntHashMap;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;

class AggregateDataSelectivity
extends AggregateData {
    private final boolean distinct;
    private long count;
    private IntIntHashMap distinctHashes;
    private double m2;

    AggregateDataSelectivity(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    void add(Session ses, Value v) {
        int size;
        ++this.count;
        if (this.distinctHashes == null) {
            this.distinctHashes = new IntIntHashMap();
        }
        if ((size = this.distinctHashes.size()) > 10000) {
            this.distinctHashes = new IntIntHashMap();
            this.m2 += (double)size;
        }
        int hash = v.hashCode();
        this.distinctHashes.put(hash, 1);
    }

    @Override
    public void mergeAggregate(Session ses, AggregateData agg) {
        throw new UnsupportedOperationException();
    }

    @Override
    Value getValue(Database database, int dataType) {
        if (this.distinct) {
            this.count = 0L;
        }
        ValueInt v = null;
        int s2 = 0;
        if (this.count == 0L) {
            s2 = 0;
        } else {
            this.m2 += (double)this.distinctHashes.size();
            this.m2 = 100.0 * this.m2 / (double)this.count;
            s2 = (int)this.m2;
            s2 = s2 <= 0 ? 1 : (s2 > 100 ? 100 : s2);
        }
        v = ValueInt.get(s2);
        return v.convertTo(dataType);
    }

    @Override
    public long getMemory() {
        throw new UnsupportedOperationException();
    }
}

