/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public class AggregateDataCount
extends AggregateData {
    private final boolean all;
    private long count;

    AggregateDataCount(boolean all) {
        this.all = all;
    }

    private AggregateDataCount(boolean all, long count) {
        this.all = all;
        this.count = count;
    }

    @Override
    void add(Session ses, Value v) {
        if (this.all || v != ValueNull.INSTANCE) {
            ++this.count;
        }
    }

    @Override
    public void mergeAggregate(Session ses, AggregateData agg) {
        assert (agg != null);
        assert (agg instanceof AggregateDataCount) : agg.getClass();
        this.count += ((AggregateDataCount)agg).count;
    }

    @Override
    Value getValue(Database database, int dataType) {
        return ValueLong.get(this.count).convertTo(dataType);
    }

    public boolean isAll() {
        return this.all;
    }

    public long count() {
        return this.count;
    }

    public static AggregateDataCount from(boolean all, long count) {
        return new AggregateDataCount(all, count);
    }

    @Override
    public long getMemory() {
        return 33L;
    }
}

