/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.IntervalOperation;
import org.gridgain.internal.h2.expression.UnaryOperation;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.function.Function;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;

public class BinaryOperation
extends Expression {
    private OpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo type;
    private boolean convertRight = true;

    public BinaryOperation(OpType opType, Expression left, Expression right) {
        this.opType = opType;
        this.left = left;
        this.right = right;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(builder, alwaysQuote).append(')');
    }

    private String getOperationToken() {
        switch (this.opType) {
            case CONCAT: {
                return "||";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Mode mode = session.getDatabase().getMode();
        Value l = this.left.getValue(session).convertTo(this.type, mode, null);
        Value r = this.right.getValue(session);
        if (this.convertRight) {
            r = r.convertTo(this.type, mode, null);
        }
        switch (this.opType) {
            case CONCAT: {
                if (l == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return r;
                }
                if (r == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return l;
                }
                String s1 = l.getString();
                String s2 = r.getString();
                StringBuilder buff = new StringBuilder(s1.length() + s2.length());
                buff.append(s1).append(s2);
                return ValueString.get(buff.toString());
            }
            case PLUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.add(r);
            }
            case MINUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.subtract(r);
            }
            case MULTIPLY: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.multiply(r);
            }
            case DIVIDE: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.divide(r);
            }
            case MODULUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.modulus(r);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        switch (this.opType) {
            case CONCAT: {
                long precision;
                TypeInfo l = this.left.getType();
                TypeInfo r = this.right.getType();
                if (DataType.isStringType(l.getValueType()) && DataType.isStringType(r.getValueType()) && (precision = l.getPrecision() + r.getPrecision()) >= 0L && precision < Integer.MAX_VALUE) {
                    this.type = TypeInfo.getTypeInfo(13, precision, 0, null);
                    break;
                }
                this.type = TypeInfo.TYPE_STRING;
                break;
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                int l = this.left.getType().getValueType();
                int r = this.right.getType().getValueType();
                if (l == 0 && r == 0 || l == -1 && r == -1) {
                    if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.type = TypeInfo.TYPE_STRING;
                        this.opType = OpType.CONCAT;
                        break;
                    }
                    this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
                    break;
                }
                if (DataType.isIntervalType(l) || DataType.isIntervalType(r)) {
                    return this.optimizeInterval(session, l, r);
                }
                if (DataType.isDateTimeType(l) || DataType.isDateTimeType(r)) {
                    return this.optimizeDateTime(session, l, r);
                }
                int dataType = Value.getHigherOrder(l, r);
                if (dataType == 25) {
                    this.type = TypeInfo.TYPE_INT;
                    break;
                }
                this.type = TypeInfo.getTypeInfo(dataType);
                if (!DataType.isStringType(dataType) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.opType = OpType.CONCAT;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private Expression optimizeInterval(Session session, int l, int r) {
        boolean lInterval = false;
        boolean lNumeric = false;
        boolean lDateTime = false;
        if (DataType.isIntervalType(l)) {
            lInterval = true;
        } else if (DataType.isNumericType(l)) {
            lNumeric = true;
        } else if (DataType.isDateTimeType(l)) {
            lDateTime = true;
        } else {
            throw this.getUnsupported(l, r);
        }
        boolean rInterval = false;
        boolean rNumeric = false;
        boolean rDateTime = false;
        if (DataType.isIntervalType(r)) {
            rInterval = true;
        } else if (DataType.isNumericType(r)) {
            rNumeric = true;
        } else if (DataType.isDateTimeType(r)) {
            rDateTime = true;
        } else {
            throw this.getUnsupported(l, r);
        }
        switch (this.opType) {
            case PLUS: {
                if (lInterval && rInterval) {
                    if (DataType.isYearMonthIntervalType(l) != DataType.isYearMonthIntervalType(r)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_PLUS_INTERVAL, this.left, this.right);
                }
                if (lInterval && rDateTime) {
                    if (r == 9 && DataType.isYearMonthIntervalType(l)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.right, this.left);
                }
                if (!lDateTime || !rInterval || l == 9 && DataType.isYearMonthIntervalType(r)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.left, this.right);
            }
            case MINUS: {
                if (lInterval && rInterval) {
                    if (DataType.isYearMonthIntervalType(l) != DataType.isYearMonthIntervalType(r)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MINUS_INTERVAL, this.left, this.right);
                }
                if (!lDateTime || !rInterval || l == 9 && DataType.isYearMonthIntervalType(r)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_INTERVAL, this.left, this.right);
            }
            case MULTIPLY: {
                if (lInterval && rNumeric) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.left, this.right);
                }
                if (!lNumeric || !rInterval) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.right, this.left);
            }
            case DIVIDE: {
                if (!lInterval || !rNumeric) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_NUMERIC, this.left, this.right);
            }
        }
        throw this.getUnsupported(l, r);
    }

    private Expression optimizeDateTime(Session session, int l, int r) {
        switch (this.opType) {
            case PLUS: {
                if (r != Value.getHigherOrder(l, r)) {
                    this.swap();
                    int t2 = l;
                    l = r;
                    r = t2;
                }
                switch (l) {
                    case 4: {
                        Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                        f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                        f.setParameter(1, this.left);
                        f.setParameter(2, this.right);
                        f.doneWithParameters();
                        return f.optimize(session);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                        f.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                        this.left = new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.left);
                        f.setParameter(1, this.left);
                        f.setParameter(2, this.right);
                        f.doneWithParameters();
                        return f.optimize(session);
                    }
                    case 9: {
                        if (r == 9 || r == 24) {
                            this.type = TypeInfo.getTypeInfo(r);
                            return this;
                        }
                        this.type = TypeInfo.TYPE_TIMESTAMP;
                        return this;
                    }
                }
                break;
            }
            case MINUS: {
                switch (l) {
                    case 10: 
                    case 11: 
                    case 24: {
                        switch (r) {
                            case 4: {
                                Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                                f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                this.right = new UnaryOperation(this.right);
                                this.right = this.right.optimize(session);
                                f.setParameter(1, this.right);
                                f.setParameter(2, this.left);
                                f.doneWithParameters();
                                return f.optimize(session);
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                                f.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                                this.right = new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.right);
                                this.right = new UnaryOperation(this.right);
                                this.right = this.right.optimize(session);
                                f.setParameter(1, this.right);
                                f.setParameter(2, this.left);
                                f.doneWithParameters();
                                return f.optimize(session);
                            }
                            case 9: {
                                this.type = TypeInfo.TYPE_TIMESTAMP;
                                return this;
                            }
                            case 10: 
                            case 11: 
                            case 24: {
                                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                            }
                        }
                        break;
                    }
                    case 9: {
                        if (r != 9) break;
                        return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                    }
                }
                break;
            }
            case MULTIPLY: {
                if (l == 9) {
                    this.type = TypeInfo.TYPE_TIME;
                    this.convertRight = false;
                    return this;
                }
                if (r != 9) break;
                this.swap();
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
            case DIVIDE: {
                if (l != 9) break;
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
        }
        throw this.getUnsupported(l, r);
    }

    private DbException getUnsupported(int l, int r) {
        return DbException.getUnsupportedException(DataType.getDataType((int)l).name + ' ' + this.getOperationToken() + ' ' + DataType.getDataType((int)r).name);
    }

    private void swap() {
        Expression temp = this.left;
        this.left = this.right;
        this.right = temp;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum OpType {
        CONCAT,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MODULUS;

    }
}

