/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.RightOwner;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.security.SHA256;
import org.gridgain.internal.h2.table.MetaTable;
import org.gridgain.internal.h2.table.RangeTable;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class User
extends RightOwner {
    private final boolean systemUser;
    private byte[] salt;
    private byte[] passwordHash;
    private boolean admin;

    public User(Database database, int id, String userName, boolean systemUser) {
        super(database, id, userName, 13);
        this.systemUser = systemUser;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setSaltAndHash(byte[] salt, byte[] hash) {
        this.salt = salt;
        this.passwordHash = hash;
    }

    public void setUserPasswordHash(byte[] userPasswordHash) {
        if (userPasswordHash != null) {
            if (userPasswordHash.length == 0) {
                this.passwordHash = userPasswordHash;
                this.salt = userPasswordHash;
            } else {
                this.salt = new byte[8];
                MathUtils.randomBytes(this.salt);
                this.passwordHash = SHA256.getHashWithSalt(userPasswordHash, this.salt);
            }
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    public void checkRight(Table table, int rightMask) {
        if (!this.hasRight(table, rightMask)) {
            throw DbException.get(90096, table.getSQL(false));
        }
    }

    public boolean hasRight(Table table, int rightMask) {
        if (rightMask != 1 && !this.systemUser && table != null) {
            table.checkWritingAllowed();
        }
        if (this.admin) {
            return true;
        }
        Role publicRole = this.database.getPublicRole();
        if (publicRole.isRightGrantedRecursive(table, rightMask)) {
            return true;
        }
        if (table instanceof MetaTable || table instanceof RangeTable) {
            return true;
        }
        if (table != null) {
            TableView v;
            if (this.hasRight(null, 16)) {
                return true;
            }
            TableType tableType = table.getTableType();
            if (TableType.VIEW == tableType ? (v = (TableView)table).getOwner() == this : tableType == null) {
                return true;
            }
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                return true;
            }
        }
        return this.isRightGrantedRecursive(table, rightMask);
    }

    public String getCreateSQL(boolean password) {
        StringBuilder buff = new StringBuilder("CREATE USER IF NOT EXISTS ");
        this.getSQL(buff, true);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        if (password) {
            buff.append(" SALT '");
            StringUtils.convertBytesToHex(buff, this.salt).append("' HASH '");
            StringUtils.convertBytesToHex(buff, this.passwordHash).append('\'');
        } else {
            buff.append(" PASSWORD ''");
        }
        if (this.admin) {
            buff.append(" ADMIN");
        }
        return buff.toString();
    }

    boolean validateUserPasswordHash(byte[] userPasswordHash) {
        if (userPasswordHash.length == 0 && this.passwordHash.length == 0) {
            return true;
        }
        if (userPasswordHash.length == 0) {
            userPasswordHash = SHA256.getKeyPasswordHash(this.getName(), new char[0]);
        }
        byte[] hash = SHA256.getHashWithSalt(userPasswordHash, this.salt);
        return Utils.compareSecure(hash, this.passwordHash);
    }

    public void checkAdmin() {
        if (!this.admin) {
            throw DbException.get(90040);
        }
    }

    public void checkSchemaAdmin() {
        if (!this.hasRight(null, 16)) {
            throw DbException.get(90040);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = new ArrayList<DbObject>();
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            children.add(right);
        }
        for (Schema schema : this.database.getAllSchemas()) {
            if (schema.getOwner() != this) continue;
            children.add(schema);
        }
        return children;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.salt = null;
        Arrays.fill(this.passwordHash, (byte)0);
        this.passwordHash = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public void checkOwnsNoSchemas() {
        for (Schema s2 : this.database.getAllSchemas()) {
            if (this != s2.getOwner()) continue;
            throw DbException.get(90107, this.getName(), s2.getName());
        }
    }
}

