/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2QueryContext;
import org.apache.ignite.internal.processors.query.h2.ManagedGroupByDataFactory;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.command.CommandInterface;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.ddl.Analyze;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.command.dml.GroupedGroupByData;
import org.gridgain.internal.h2.command.dml.PlainGroupByData;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Engine;
import org.gridgain.internal.h2.engine.GeneratedKeys;
import org.gridgain.internal.h2.engine.Procedure;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.engine.SessionWithState;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.engine.UndoLog;
import org.gridgain.internal.h2.engine.UndoLogRecord;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.ViewIndex;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.message.TraceSystem;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.InDoubtTransaction;
import org.gridgain.internal.h2.table.SubQueryInfo;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.util.ColumnNamerConfiguration;
import org.gridgain.internal.h2.util.CurrentTimestamp;
import org.gridgain.internal.h2.util.SmallLRUCache;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;
import org.gridgain.internal.h2.value.VersionedValue;

public class Session
extends SessionWithState
implements TransactionStore.RollbackListener {
    public static final int LOG_WRITTEN = -1;
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private final Database database;
    private ConnectionInfo connectionInfo;
    private final User user;
    private final int id;
    private final ArrayList<Table> locks = Utils.newSmallArrayList();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private Value lastScopeIdentity = ValueLong.get(0L);
    private Value lastTriggerIdentity;
    private GeneratedKeys generatedKeys;
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Savepoint> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private long throttleNs;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, Value> removeLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean redoLogBinary = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAtNs;
    private final long sessionStart = System.currentTimeMillis();
    private ValueTimestampTimeZone transactionStart;
    private ValueTimestampTimeZone currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<ResultInterface> temporaryResults;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private Thread waitForLockThread;
    private int modificationId;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;
    private long modificationMetaID = -1L;
    private SubQueryInfo subQueryInfo;
    private ArrayDeque<String> viewNameStack;
    private int preparingQueryExpression;
    private volatile SmallLRUCache<Object, ViewIndex> viewIndexCache;
    private HashMap<Object, ViewIndex> subQueryIndexCache;
    private boolean joinBatchEnabled;
    private boolean forceJoinOrder;
    private boolean lazyQueryExecution;
    private ColumnNamerConfiguration columnNamerConfiguration;
    private H2QueryContext qryContext;
    private H2MemoryTracker memoryTracker;
    private ManagedGroupByDataFactory groupByDataFactory;
    private Supplier<String> qryDescSupplier;
    private HashSet<Table> tablesToAnalyze;
    private LinkedList<TimeoutValue> temporaryResultLobs;
    private ArrayList<Value> temporaryLobs;
    private Transaction transaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private long startStatement = -1L;
    private BitSet idsToRelease;
    private boolean hashJoinEnabled;
    private int hashJoinMaxTableSize = 100000;

    public Session(Database database, User user, int id) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.user = user;
        this.id = id;
        this.lockTimeout = database.getLockTimeout();
        Schema mainSchema = database.getMainSchema();
        this.currentSchemaName = mainSchema != null ? mainSchema.getName() : database.sysIdentifier("PUBLIC");
        this.columnNamerConfiguration = ColumnNamerConfiguration.getDefault();
    }

    public void setLazyQueryExecution(boolean lazyQueryExecution) {
        this.lazyQueryExecution = lazyQueryExecution;
    }

    public boolean isLazyQueryExecution() {
        return this.lazyQueryExecution;
    }

    public void setForceJoinOrder(boolean forceJoinOrder) {
        this.forceJoinOrder = forceJoinOrder;
    }

    public boolean isForceJoinOrder() {
        return this.forceJoinOrder;
    }

    public void setJoinBatchEnabled(boolean joinBatchEnabled) {
        this.joinBatchEnabled = joinBatchEnabled;
    }

    public boolean isJoinBatchEnabled() {
        return this.joinBatchEnabled;
    }

    public H2QueryContext getQueryContext() {
        return this.qryContext;
    }

    public void setQueryContext(H2QueryContext qryContext) {
        this.qryContext = qryContext;
    }

    public H2MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public void memoryTracker(H2MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
    }

    public String queryDescription() {
        return this.qryDescSupplier != null ? this.qryDescSupplier.get() : null;
    }

    public void queryDescription(Supplier<String> qryDescSupplier) {
        this.qryDescSupplier = qryDescSupplier;
    }

    public ManagedGroupByDataFactory groupByDataFactory() {
        return this.groupByDataFactory;
    }

    public void groupByDataFactory(ManagedGroupByDataFactory groupByDataFactory) {
        this.groupByDataFactory = groupByDataFactory;
    }

    public GroupByData newGroupByDataInstance(ArrayList<Expression> expressions, boolean isGrpQry, int[] grpIdx) {
        GroupByData grpByData;
        if (this.memoryTracker != null && (grpByData = this.groupByDataFactory.newManagedGroupByData(this, expressions, isGrpQry, grpIdx)) != null) {
            return grpByData;
        }
        return isGrpQry ? new GroupedGroupByData(this, grpIdx) : new PlainGroupByData(this);
    }

    public Row createRow(Value[] data, int memory) {
        return this.database.createRow(data, memory);
    }

    public void pushSubQueryInfo(int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        this.subQueryInfo = new SubQueryInfo(this.subQueryInfo, masks, filters, filter, sortOrder);
    }

    public void popSubQueryInfo() {
        this.subQueryInfo = this.subQueryInfo.getUpper();
    }

    public SubQueryInfo getSubQueryInfo() {
        return this.subQueryInfo;
    }

    public void setParsingCreateView(boolean parsingView, String viewName) {
        if (this.viewNameStack == null) {
            this.viewNameStack = new ArrayDeque(3);
        }
        if (parsingView) {
            this.viewNameStack.push(viewName);
        } else {
            String name = this.viewNameStack.pop();
            assert (viewName.equals(name));
        }
    }

    public String getParsingCreateViewName() {
        return this.viewNameStack != null ? this.viewNameStack.peek() : null;
    }

    public boolean isParsingCreateView() {
        return this.viewNameStack != null && !this.viewNameStack.isEmpty();
    }

    public void optimizeQueryExpression(Query query2) {
        SubQueryInfo tmp = this.subQueryInfo;
        this.subQueryInfo = null;
        ++this.preparingQueryExpression;
        try {
            query2.prepare();
        }
        finally {
            this.subQueryInfo = tmp;
            --this.preparingQueryExpression;
        }
    }

    public boolean isPreparingQueryExpression() {
        assert (this.preparingQueryExpression >= 0);
        return this.preparingQueryExpression != 0;
    }

    @Override
    public ArrayList<String> getClusterServers() {
        return new ArrayList<String>();
    }

    public boolean setCommitOrRollbackDisabled(boolean x) {
        boolean old = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = x;
        return old;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.database.newStringMap();
        }
    }

    public void setVariable(String name, Value value) {
        Value old;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            old = this.variables.remove(name);
        } else {
            value = value.copy(this.database, -1);
            old = this.variables.put(name, value);
        }
        if (old != null) {
            old.remove();
        }
    }

    public Value getVariable(String name) {
        this.initVariables();
        Value v = this.variables.get(name);
        return v == null ? ValueNull.INSTANCE : v;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public Table findLocalTempTable(String name) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(name);
    }

    public ArrayList<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return Utils.newSmallArrayList();
        }
        return new ArrayList<Table>(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.database.newStringMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            StringBuilder builder = new StringBuilder();
            table.getSQL(builder, false).append(" AS ");
            Parser.quoteIdentifier(table.getName(), false);
            throw DbException.get(42101, builder.toString());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        boolean wasLocked = this.database.lockMeta(this);
        try {
            ++this.modificationId;
            if (this.localTempTables != null) {
                this.localTempTables.remove(table.getName());
            }
            Database database = this.database;
            synchronized (database) {
                table.removeChildrenAndResources(this);
            }
        }
        finally {
            if (!wasLocked) {
                this.database.unlockMeta(this);
            }
        }
    }

    public Index findLocalTempTableIndex(String name) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(name);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return new HashMap<String, Index>();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.database.newStringMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL(false));
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String name) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(name);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return new HashMap<String, Constraint>();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String name;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.database.newStringMap();
        }
        if (this.localTempTableConstraints.get(name = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL(false));
        }
        this.localTempTableConstraints.put(name, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    @Override
    public synchronized CommandInterface prepareCommand(String sql, int fetchSize) {
        return this.prepareLocal(sql);
    }

    public Prepared prepare(String sql) {
        return this.prepare(sql, false, false);
    }

    public Prepared prepare(String sql, boolean rightsChecked, boolean literalsChecked) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        parser.setLiteralsChecked(literalsChecked);
        return parser.prepare(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command prepareLocal(String sql) {
        Command command;
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
                this.modificationMetaID = this.database.getModificationMetaId();
            } else {
                long newModificationMetaID = this.database.getModificationMetaId();
                if (newModificationMetaID != this.modificationMetaID) {
                    this.queryCache.clear();
                    this.modificationMetaID = newModificationMetaID;
                }
                if ((command = (Command)this.queryCache.get(sql)) != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        try {
            command = parser.prepareCommand(sql);
        }
        finally {
            this.subQueryIndexCache = null;
        }
        command.prepareJoinBatch();
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(sql, command);
        }
        return command;
    }

    void scheduleDatabaseObjectIdForRelease(int id) {
        if (this.idsToRelease == null) {
            this.idsToRelease = new BitSet();
        }
        this.idsToRelease.set(id);
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int count) {
        this.database.setPowerOffCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean ddl) {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        if (this.transaction != null) {
            try {
                if (!this.locks.isEmpty()) {
                    for (Table t2 : this.locks) {
                        if (!(t2 instanceof MVTable)) continue;
                        ((MVTable)t2).commit();
                    }
                }
                this.transaction.commit();
            }
            finally {
                this.transaction = null;
            }
        } else if (this.containsUncommitted()) {
            this.database.commit(this);
        }
        this.removeTemporaryLobs(true);
        if (this.undoLog != null && this.undoLog.size() > 0) {
            this.undoLog.clear();
        }
        if (!ddl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        if (this.tablesToAnalyze != null) {
            if (this.database.isMVStore()) {
                this.analyzeTables();
                this.commit(true);
            } else {
                this.analyzeTables();
            }
        }
        this.endTransaction();
    }

    private void analyzeTables() {
        int rowCount = this.getDatabase().getSettings().analyzeSample / 10;
        for (Table table : this.tablesToAnalyze) {
            Analyze.analyzeTable(this, table, rowCount, false);
        }
        this.database.unlockMeta(this);
        this.tablesToAnalyze = null;
    }

    private void removeTemporaryLobs(boolean onTimeout) {
        assert (this != this.getDatabase().getLobSession() || Thread.holdsLock(this) || Thread.holdsLock(this.getDatabase()));
        if (this.temporaryLobs != null) {
            for (Value v : this.temporaryLobs) {
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
            this.temporaryLobs.clear();
        }
        if (this.temporaryResultLobs != null && !this.temporaryResultLobs.isEmpty()) {
            long keepYoungerThan = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.database.getSettings().lobTimeout);
            while (!this.temporaryResultLobs.isEmpty()) {
                TimeoutValue tv = this.temporaryResultLobs.getFirst();
                if (onTimeout && tv.created >= keepYoungerThan) break;
                Value v = this.temporaryResultLobs.removeFirst().value;
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
        }
    }

    private void checkCommitRollback() {
        if (this.commitOrRollbackDisabled && !this.locks.isEmpty()) {
            throw DbException.get(90058);
        }
    }

    private void endTransaction() {
        if (this.removeLobMap != null && this.removeLobMap.size() > 0) {
            if (this.database.getStore() == null) {
                this.database.flush();
            }
            for (Value v : this.removeLobMap.values()) {
                v.remove();
            }
            this.removeLobMap = null;
        }
        this.unlockAll();
        if (this.idsToRelease != null) {
            this.database.releaseDatabaseObjectIds(this.idsToRelease);
            this.idsToRelease = null;
        }
    }

    public void rollback() {
        boolean needCommit;
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        boolean bl = needCommit = this.undoLog != null && this.undoLog.size() > 0 || this.transaction != null;
        if (needCommit) {
            this.rollbackTo(null);
        }
        if (!this.locks.isEmpty() || needCommit) {
            this.database.commit(this);
        }
        this.idsToRelease = null;
        this.cleanTempTables(false);
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
        this.endTransaction();
    }

    public void rollbackTo(Savepoint savepoint) {
        int index;
        int n = index = savepoint == null ? 0 : savepoint.logIndex;
        if (this.undoLog != null) {
            while (this.undoLog.size() > index) {
                UndoLogRecord entry = this.undoLog.getLast();
                entry.undo(this);
                this.undoLog.removeLast();
            }
        }
        if (this.transaction != null) {
            if (savepoint == null) {
                this.transaction.rollback();
                this.transaction = null;
            } else {
                this.transaction.rollbackToSavepoint(savepoint.transactionSavepoint);
            }
        }
        if (this.savepoints != null) {
            String[] names;
            for (String name : names = this.savepoints.keySet().toArray(new String[this.savepoints.size()])) {
                Savepoint sp = this.savepoints.get(name);
                int savepointIndex = sp.logIndex;
                if (savepointIndex <= index) continue;
                this.savepoints.remove(name);
            }
        }
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        return this.undoLog != null && this.undoLog.size() > 0;
    }

    public Savepoint setSavepoint() {
        Savepoint sp = new Savepoint();
        if (this.undoLog != null) {
            sp.logIndex = this.undoLog.size();
        }
        if (this.database.getStore() != null) {
            sp.transactionSavepoint = this.getStatementSavepoint();
        }
        return sp;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAtNs = System.nanoTime();
    }

    @Override
    public void close() {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            try {
                this.database.checkPowerOff();
                H2MemoryTracker tracker = this.memoryTracker;
                if (tracker != null) {
                    tracker.close();
                }
                this.rollback();
                this.removeTemporaryLobs(false);
                this.cleanTempTables(true);
                this.commit(true);
                if (this.undoLog != null) {
                    this.undoLog.clear();
                }
                this.database.unlockMeta(this);
            }
            finally {
                this.database.removeSession(this);
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.contains(table)) {
            DbException.throwInternalError(table.toString());
        }
        this.locks.add(table);
    }

    public void log(Table table, short operation, Row row) {
        if (table.isMVStore()) {
            return;
        }
        if (this.undoLogEnabled) {
            int lockMode;
            UndoLogRecord log = new UndoLogRecord(table, operation, row);
            if (SysProperties.CHECK && (lockMode = this.database.getLockMode()) != 0 && !this.database.isMVStore()) {
                TableType tableType = log.getTable().getTableType();
                if (!this.locks.contains(log.getTable()) && TableType.TABLE_LINK != tableType && TableType.EXTERNAL_TABLE_ENGINE != tableType) {
                    DbException.throwInternalError(String.valueOf((Object)tableType));
                }
            }
            if (this.undoLog == null) {
                this.undoLog = new UndoLog(this.database);
            }
            this.undoLog.add(log);
        }
    }

    public void unlockReadLocks() {
        if (!this.database.isMVStore() && this.database.isMultiThreaded() && this.database.getLockMode() == 3) {
            Iterator<Table> iter = this.locks.iterator();
            while (iter.hasNext()) {
                Table t2 = iter.next();
                if (t2.isLockedExclusively()) continue;
                t2.unlock(this);
                iter.remove();
            }
        }
    }

    void unlock(Table t2) {
        this.locks.remove(t2);
    }

    private void unlockAll() {
        if (this.undoLog != null && this.undoLog.size() > 0) {
            DbException.throwInternalError();
        }
        if (!this.locks.isEmpty()) {
            for (Table t2 : this.locks) {
                t2.unlock(this);
            }
            this.locks.clear();
        }
        this.database.unlockMetaDebug(this);
        this.savepoints = null;
        this.sessionStateChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean closeSession) {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            if (this.database.isMVStore()) {
                this._cleanTempTables(closeSession);
            } else {
                Database database = this.database;
                synchronized (database) {
                    this._cleanTempTables(closeSession);
                }
            }
        }
    }

    private void _cleanTempTables(boolean closeSession) {
        Iterator<Table> it = this.localTempTables.values().iterator();
        while (it.hasNext()) {
            Table table = it.next();
            if (closeSession || table.getOnCommitDrop()) {
                ++this.modificationId;
                table.setModified();
                it.remove();
                this.database.lockMeta(this);
                table.removeChildrenAndResources(this);
                if (!closeSession) continue;
                this.database.commit(this);
                continue;
            }
            if (!table.getOnCommitTruncate()) continue;
            table.truncate(this);
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.isClosed()) {
            return this.trace;
        }
        String traceModuleName = "jdbc[" + this.id + "]";
        if (this.isClosed()) {
            return new TraceSystem(null).getTrace(traceModuleName);
        }
        this.trace = this.database.getTraceSystem().getTrace(traceModuleName);
        return this.trace;
    }

    public void setLastIdentity(Value last) {
        this.lastIdentity = last;
        this.lastScopeIdentity = last;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void setLastScopeIdentity(Value last) {
        this.lastScopeIdentity = last;
    }

    public Value getLastScopeIdentity() {
        return this.lastScopeIdentity;
    }

    public void setLastTriggerIdentity(Value last) {
        this.lastTriggerIdentity = last;
    }

    public Value getLastTriggerIdentity() {
        return this.lastTriggerIdentity;
    }

    public GeneratedKeys getGeneratedKeys() {
        if (this.generatedKeys == null) {
            this.generatedKeys = new GeneratedKeys();
        }
        return this.generatedKeys;
    }

    public void addLogPos(int logId, int pos) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = logId;
            this.firstUncommittedPos = pos;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    public boolean containsUncommitted() {
        if (this.database.getStore() != null) {
            return this.transaction != null && this.transaction.hasChanges();
        }
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = this.database.newStringMap();
        }
        this.savepoints.put(name, this.setSavepoint());
    }

    public void rollbackToSavepoint(String name) {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        if (this.savepoints == null) {
            throw DbException.get(90063, name);
        }
        Savepoint savepoint = this.savepoints.get(name);
        if (savepoint == null) {
            throw DbException.get(90063, name);
        }
        this.rollbackTo(savepoint);
    }

    public void prepareCommit(String transactionName) {
        if (this.containsUncommitted()) {
            this.database.prepareCommit(this, transactionName);
        }
        this.currentTransactionName = transactionName;
    }

    public void setPreparedTransaction(String transactionName, boolean commit) {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(transactionName)) {
            if (commit) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> list = this.database.getInDoubtTransactions();
            int state = commit ? 1 : 2;
            boolean found = false;
            if (list != null) {
                for (InDoubtTransaction p : list) {
                    if (!p.getTransactionName().equals(transactionName)) continue;
                    p.setState(state);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw DbException.get(90129, transactionName);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public void setThrottle(int throttle) {
        this.throttleNs = TimeUnit.MILLISECONDS.toNanos(throttle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle() {
        if (this.currentCommandStart == null) {
            this.currentCommandStart = CurrentTimestamp.get();
        }
        if (this.throttleNs == 0L) {
            return;
        }
        long time = System.nanoTime();
        if (this.lastThrottle + TimeUnit.MILLISECONDS.toNanos(50L) > time) {
            return;
        }
        State prevState = this.state.get();
        if (prevState != State.CLOSED) {
            this.lastThrottle = time + this.throttleNs;
            try {
                this.state.compareAndSet(prevState, State.SLEEP);
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.throttleNs));
            }
            catch (Exception exception) {
            }
            finally {
                this.state.compareAndSet(State.SLEEP, prevState);
            }
        }
    }

    public void setCurrentCommand(Command command, Object generatedKeysRequest) {
        State currentState;
        this.currentCommand = command;
        if (command != null && !command.isQuery()) {
            this.getGeneratedKeys().clear(generatedKeysRequest);
        }
        if (command != null) {
            if (this.queryTimeout > 0) {
                this.currentCommandStart = CurrentTimestamp.get();
                long now = System.nanoTime();
                this.cancelAtNs = now + TimeUnit.MILLISECONDS.toNanos(this.queryTimeout);
            } else {
                this.currentCommandStart = null;
            }
        }
        if ((currentState = this.state.get()) != State.CLOSED) {
            this.state.compareAndSet(currentState, command == null ? State.SLEEP : State.RUNNING);
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.cancelAtNs == 0L) {
            return;
        }
        long time = System.nanoTime();
        if (time >= this.cancelAtNs) {
            this.cancelAtNs = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAtNs;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public ValueTimestampTimeZone getCurrentCommandStart() {
        if (this.currentCommandStart == null) {
            this.currentCommandStart = CurrentTimestamp.get();
        }
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    @Override
    public void setCurrentSchemaName(String schemaName) {
        Schema schema = this.database.getSchema(schemaName);
        this.setCurrentSchema(schema);
    }

    public JdbcConnection createConnection(boolean columnList) {
        String url = columnList ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void removeAtCommit(Value v) {
        String key = v.toString();
        if (!v.isLinkedToTable()) {
            DbException.throwInternalError(key);
        }
        if (this.removeLobMap == null) {
            this.removeLobMap = new HashMap();
        }
        this.removeLobMap.put(key, v);
    }

    public void removeAtCommitStop(Value v) {
        if (this.removeLobMap != null) {
            this.removeLobMap.remove(v.toString());
        }
    }

    public String getNextSystemIdentifier(String sql) {
        String identifier;
        while (sql.contains(identifier = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++)) {
        }
        return identifier;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.database.newStringMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String name) {
        if (this.procedures != null) {
            this.procedures.remove(name);
        }
    }

    public Procedure getProcedure(String name) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(name);
    }

    public void setSchemaSearchPath(String[] schemas) {
        ++this.modificationId;
        this.schemaSearchPath = schemas;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + (this.user == null ? "<null>" : this.user.getName()) + ")";
    }

    public void setUndoLogEnabled(boolean b) {
        this.undoLogEnabled = b;
    }

    public void setRedoLogBinary(boolean b) {
        this.redoLogBinary = b;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public ValueTimestampTimeZone getTransactionStart() {
        if (this.transactionStart == null) {
            this.transactionStart = CurrentTimestamp.get();
        }
        return this.transactionStart;
    }

    public Table[] getLocks() {
        ArrayList<Table> copy = new ArrayList<Table>(this.locks.size());
        for (Table lock : this.locks) {
            try {
                copy.add(lock);
            }
            catch (Exception e) {
                break;
            }
        }
        return copy.toArray(new Table[0]);
    }

    public void waitIfExclusiveModeEnabled() {
        Session exclusive;
        if (this.database.getLobSession() == this) {
            return;
        }
        while ((exclusive = this.database.getExclusiveSession()) != null && exclusive != this && !Thread.holdsLock(exclusive)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Map<Object, ViewIndex> getViewIndexCache(boolean subQuery) {
        if (subQuery) {
            if (this.subQueryIndexCache == null) {
                this.subQueryIndexCache = new HashMap();
            }
            return this.subQueryIndexCache;
        }
        SmallLRUCache<Object, ViewIndex> cache = this.viewIndexCache;
        if (cache == null) {
            this.viewIndexCache = cache = SmallLRUCache.newInstance(64);
        }
        return cache;
    }

    public void addTemporaryResult(ResultInterface result) {
        if (!result.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = new HashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(result);
        }
    }

    private void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (ResultInterface result : this.temporaryResults) {
                result.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int queryTimeout) {
        int max = this.database.getSettings().maxQueryTimeout;
        if (max != 0 && (max < queryTimeout || queryTimeout == 0)) {
            queryTimeout = max;
        }
        this.queryTimeout = queryTimeout;
        this.cancelAtNs = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table waitForLock, Thread waitForLockThread) {
        this.waitForLock = waitForLock;
        this.waitForLockThread = waitForLockThread;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public Thread getWaitForLockThread() {
        return this.waitForLockThread;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean write) {
        block2: {
            do {
                boolean reconnect;
                if (reconnect = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!write) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public void afterWriting() {
        this.database.afterWriting();
    }

    @Override
    public SessionInterface reconnect(boolean write) {
        this.readSessionState();
        this.close();
        Session newSession = Engine.getInstance().createSession(this.connectionInfo);
        newSession.sessionState = this.sessionState;
        newSession.recreateSessionState();
        if (write) {
            while (!newSession.database.beforeWriting()) {
            }
        }
        return newSession;
    }

    public void setConnectionInfo(ConnectionInfo ci) {
        this.connectionInfo = ci;
    }

    public Value getTransactionId() {
        if (this.database.getStore() != null) {
            if (this.transaction == null || !this.transaction.hasChanges()) {
                return ValueNull.INSTANCE;
            }
            return ValueString.get(Long.toString(this.getTransaction().getSequenceNum()));
        }
        if (!this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        if (this.undoLog == null || this.undoLog.size() == 0) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.redoLogBinary;
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            MVTableEngine.Store store = this.database.getStore();
            if (store != null) {
                if (store.getMvStore().isClosed()) {
                    Throwable backgroundException = this.database.getBackgroundException();
                    this.database.shutdownImmediately();
                    throw DbException.get(90098, backgroundException, new String[0]);
                }
                this.transaction = store.getTransactionStore().begin(this, this.lockTimeout, this.id);
            }
            this.startStatement = -1L;
        }
        return this.transaction;
    }

    private long getStatementSavepoint() {
        if (this.startStatement == -1L) {
            this.startStatement = this.getTransaction().setSavepoint();
        }
        return this.startStatement;
    }

    public void startStatementWithinTransaction() {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            transaction.markStatementStart();
        }
        this.startStatement = -1L;
    }

    public void endStatement() {
        if (this.transaction != null) {
            this.transaction.markStatementEnd();
        }
        this.startStatement = -1L;
        this.closeTemporaryResults();
    }

    public void clearViewIndexCache() {
        this.viewIndexCache = null;
    }

    @Override
    public void addTemporaryLob(Value v) {
        if (!DataType.isLargeObject(v.getValueType())) {
            return;
        }
        if (v.getTableId() == -3 || v.getTableId() == -2) {
            if (this.temporaryResultLobs == null) {
                this.temporaryResultLobs = new LinkedList();
            }
            this.temporaryResultLobs.add(new TimeoutValue(v));
        } else {
            if (this.temporaryLobs == null) {
                this.temporaryLobs = new ArrayList();
            }
            this.temporaryLobs.add(v);
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void markTableForAnalyze(Table table) {
        if (this.tablesToAnalyze == null) {
            this.tablesToAnalyze = new HashSet();
        }
        this.tablesToAnalyze.add(table);
    }

    public State getState() {
        return this.getBlockingSessionId() != 0 ? State.BLOCKED : this.state.get();
    }

    public int getBlockingSessionId() {
        return this.transaction == null ? 0 : this.transaction.getBlockerId();
    }

    @Override
    public void onRollback(MVMap<Object, VersionedValue> map, Object key, VersionedValue existingValue, VersionedValue restoredValue) {
        MVTable table;
        MVTableEngine.Store store = this.database.getStore();
        if (store != null && (table = store.getTable(map.getName())) != null) {
            long recKey = ((ValueLong)key).getLong();
            Row oldRow = Session.getRowFromVersionedValue(table, recKey, existingValue);
            Row newRow = Session.getRowFromVersionedValue(table, recKey, restoredValue);
            table.fireAfterRow(this, oldRow, newRow, true);
            if (table.getContainsLargeObject()) {
                Value v;
                int i;
                int len;
                if (oldRow != null) {
                    len = oldRow.getColumnCount();
                    for (i = 0; i < len; ++i) {
                        v = oldRow.getValue(i);
                        if (!v.isLinkedToTable()) continue;
                        this.removeAtCommit(v);
                    }
                }
                if (newRow != null) {
                    len = newRow.getColumnCount();
                    for (i = 0; i < len; ++i) {
                        v = newRow.getValue(i);
                        if (!v.isLinkedToTable()) continue;
                        this.removeAtCommitStop(v);
                    }
                }
            }
        }
    }

    private static Row getRowFromVersionedValue(MVTable table, long recKey, VersionedValue versionedValue) {
        Row result;
        Object value;
        Object object = value = versionedValue == null ? null : versionedValue.getCurrentValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Row) {
            result = (Row)value;
            assert (result.getKey() == recKey) : result.getKey() + " != " + recKey;
        } else {
            ValueArray array = (ValueArray)value;
            result = table.createRow(array.getList(), 0);
            result.setKey(recKey);
        }
        return result;
    }

    public ColumnNamerConfiguration getColumnNamerConfiguration() {
        return this.columnNamerConfiguration;
    }

    public void setColumnNamerConfiguration(ColumnNamerConfiguration columnNamerConfiguration) {
        this.columnNamerConfiguration = columnNamerConfiguration;
    }

    public boolean isHashJoinEnabled() {
        return this.hashJoinEnabled;
    }

    public void setHashJoinEnabled(boolean enable) {
        this.hashJoinEnabled = enable;
    }

    public int getHashJoinMaxTableSize() {
        return this.hashJoinMaxTableSize;
    }

    public void setHashJoinMaxTableSize(int hashJoinMaxTableSize) {
        this.hashJoinMaxTableSize = hashJoinMaxTableSize;
    }

    @Override
    public boolean isSupportsGeneratedKeys() {
        return true;
    }

    public static class TimeoutValue {
        final long created = System.nanoTime();
        final Value value;

        TimeoutValue(Value v) {
            this.value = v;
        }
    }

    public static class Savepoint {
        int logIndex;
        long transactionSavepoint;
    }

    public static enum State {
        INIT,
        RUNNING,
        BLOCKED,
        SLEEP,
        CLOSED;

    }
}

