/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.constraint;

import java.util.ArrayList;
import java.util.HashSet;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.constraint.ConstraintActionType;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    private IndexColumn[] columns;
    private IndexColumn[] refColumns;
    private ConstraintActionType deleteAction = ConstraintActionType.RESTRICT;
    private ConstraintActionType updateAction = ConstraintActionType.RESTRICT;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.REFERENTIAL;
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        return this.getCreateSQLForCopy(forTable, this.refTable, quotedName, true);
    }

    public String getCreateSQLForCopy(Table forTable, Table forRefTable, String quotedName, boolean internalIndex) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        forTable.getSQL(builder, true).append(" ADD CONSTRAINT ");
        if (forTable.isHidden()) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        IndexColumn[] cols = this.columns;
        IndexColumn[] refCols = this.refColumns;
        builder.append(" FOREIGN KEY(");
        IndexColumn.writeColumns(builder, cols, true);
        builder.append(')');
        if (internalIndex && this.indexOwner && forTable == this.table) {
            builder.append(" INDEX ");
            this.index.getSQL(builder, true);
        }
        builder.append(" REFERENCES ");
        if (this.table == this.refTable) {
            forTable.getSQL(builder, true);
        } else {
            forRefTable.getSQL(builder, true);
        }
        builder.append('(');
        IndexColumn.writeColumns(builder, refCols, true);
        builder.append(')');
        if (internalIndex && this.refIndexOwner && forTable == this.table) {
            builder.append(" INDEX ");
            this.refIndex.getSQL(builder, true);
        }
        if (this.deleteAction != ConstraintActionType.RESTRICT) {
            builder.append(" ON DELETE ").append(this.deleteAction.getSqlName());
        }
        if (this.updateAction != ConstraintActionType.RESTRICT) {
            builder.append(" ON UPDATE ").append(this.updateAction.getSqlName());
        }
        return builder.append(" NOCHECK").toString();
    }

    private String getShortDescription(Index searchIndex, SearchRow check) {
        StringBuilder builder = new StringBuilder(this.getName()).append(": ");
        this.table.getSQL(builder, false).append(" FOREIGN KEY(");
        IndexColumn.writeColumns(builder, this.columns, false);
        builder.append(") REFERENCES ");
        this.refTable.getSQL(builder, false).append('(');
        IndexColumn.writeColumns(builder, this.refColumns, false);
        builder.append(')');
        if (searchIndex != null && check != null) {
            builder.append(" (");
            Column[] cols = searchIndex.getColumns();
            int len = Math.min(this.columns.length, cols.length);
            for (int i = 0; i < len; ++i) {
                int idx = cols[i].getColumnId();
                Value c = check.getValue(idx);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(c == null ? "" : c.toString());
            }
            builder.append(')');
        }
        return builder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(true), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    public void setColumns(IndexColumn[] cols) {
        this.columns = cols;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> result;
        block3: {
            block2: {
                result = new HashSet<Column>();
                if (table != this.table) break block2;
                for (IndexColumn c : this.columns) {
                    result.add(c.column);
                }
                break block3;
            }
            if (table != this.refTable) break block3;
            for (IndexColumn c : this.refColumns) {
                result.add(c.column);
            }
        }
        return result;
    }

    public void setRefColumns(IndexColumn[] refCols) {
        this.refColumns = refCols;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table refTable) {
        this.refTable = refTable;
        if (refTable.isTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean isOwner) {
        this.index = index;
        this.indexOwner = isOwner;
    }

    public void setRefIndex(Index refIndex, boolean isRefOwner) {
        this.refIndex = refIndex;
        this.refIndexOwner = isRefOwner;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table t2, Row oldRow, Row newRow) {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (t2 == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, oldRow, newRow);
        }
        if (t2 == this.refTable) {
            this.checkRowRefTable(session, oldRow, newRow);
        }
    }

    private void checkRowOwnTable(Session session, Row oldRow, Row newRow) {
        int refIdx;
        Column refCol;
        int i;
        int len;
        if (newRow == null) {
            return;
        }
        boolean constraintColumnsEqual = oldRow != null;
        for (IndexColumn col : this.columns) {
            int idx = col.column.getColumnId();
            Value v = newRow.getValue(idx);
            if (v == ValueNull.INSTANCE) {
                return;
            }
            if (!constraintColumnsEqual || this.database.areEqual(v, oldRow.getValue(idx))) continue;
            constraintColumnsEqual = false;
        }
        if (constraintColumnsEqual) {
            return;
        }
        if (this.refTable == this.table) {
            boolean self = true;
            len = this.columns.length;
            for (i = 0; i < len; ++i) {
                int idx = this.columns[i].column.getColumnId();
                Value v = newRow.getValue(idx);
                refCol = this.refColumns[i].column;
                refIdx = refCol.getColumnId();
                Value r = newRow.getValue(refIdx);
                if (this.database.areEqual(r, v)) continue;
                self = false;
                break;
            }
            if (self) {
                return;
            }
        }
        Row check = this.refTable.getTemplateRow();
        len = this.columns.length;
        for (i = 0; i < len; ++i) {
            int idx = this.columns[i].column.getColumnId();
            Value v = newRow.getValue(idx);
            refCol = this.refColumns[i].column;
            refIdx = refCol.getColumnId();
            check.setValue(refIdx, refCol.convert(v));
        }
        if (!this.existsRow(session, this.refIndex, check, null)) {
            throw DbException.get(23506, this.getShortDescription(this.refIndex, check));
        }
    }

    private boolean existsRow(Session session, Index searchIndex, SearchRow check, Row excluding) {
        Table searchTable = searchIndex.getTable();
        searchTable.lock(session, false, false);
        Cursor cursor = searchIndex.find(session, check, check);
        while (cursor.next()) {
            SearchRow found = cursor.getSearchRow();
            if (excluding != null && found.getKey() == excluding.getKey()) continue;
            Column[] cols = searchIndex.getColumns();
            boolean allEqual = true;
            int len = Math.min(this.columns.length, cols.length);
            for (int i = 0; i < len; ++i) {
                Value f;
                int idx = cols[i].getColumnId();
                Value c = check.getValue(idx);
                if (searchTable.compareValues(c, f = found.getValue(idx)) == 0) continue;
                allEqual = false;
                break;
            }
            if (!allEqual) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row oldRow, Row newRow) {
        return this.refIndex.compareRows(oldRow, newRow) == 0;
    }

    private void checkRow(Session session, Row oldRow) {
        Row excluding;
        SearchRow check = this.table.getTemplateSimpleRow(false);
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            Column col = this.columns[i].column;
            Column refCol = this.refColumns[i].column;
            int refIdx = refCol.getColumnId();
            Value v = col.convert(oldRow.getValue(refIdx));
            if (v == ValueNull.INSTANCE) {
                return;
            }
            check.setValue(col.getColumnId(), v);
        }
        Row row = excluding = this.refTable == this.table ? oldRow : null;
        if (this.existsRow(session, this.index, check, excluding)) {
            throw DbException.get(23503, this.getShortDescription(this.index, check));
        }
    }

    private void checkRowRefTable(Session session, Row oldRow, Row newRow) {
        if (oldRow == null) {
            return;
        }
        if (newRow != null && this.isEqual(oldRow, newRow)) {
            return;
        }
        if (newRow == null) {
            if (this.deleteAction == ConstraintActionType.RESTRICT) {
                this.checkRow(session, oldRow);
            } else {
                int i = this.deleteAction == ConstraintActionType.CASCADE ? 0 : this.columns.length;
                Prepared deleteCommand = this.getDelete(session);
                this.setWhere(deleteCommand, i, oldRow);
                this.updateWithSkipCheck(deleteCommand);
            }
        } else if (this.updateAction == ConstraintActionType.RESTRICT) {
            this.checkRow(session, oldRow);
        } else {
            Prepared updateCommand = this.getUpdate(session);
            if (this.updateAction == ConstraintActionType.CASCADE) {
                ArrayList<Parameter> params = updateCommand.getParameters();
                int len = this.columns.length;
                for (int i = 0; i < len; ++i) {
                    Parameter param = params.get(i);
                    Column refCol = this.refColumns[i].column;
                    param.setValue(newRow.getValue(refCol.getColumnId()));
                }
            }
            this.setWhere(updateCommand, this.columns.length, oldRow);
            this.updateWithSkipCheck(updateCommand);
        }
    }

    private void updateWithSkipCheck(Prepared prep) {
        try {
            this.skipOwnTable = true;
            prep.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    private void setWhere(Prepared command, int pos, Row row) {
        int len = this.refColumns.length;
        for (int i = 0; i < len; ++i) {
            int idx = this.refColumns[i].column.getColumnId();
            Value v = row.getValue(idx);
            ArrayList<Parameter> params = command.getParameters();
            Parameter param = params.get(pos + i);
            param.setValue(v);
        }
    }

    public ConstraintActionType getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(ConstraintActionType action) {
        if (action == this.deleteAction && this.deleteSQL == null) {
            return;
        }
        if (this.deleteAction != ConstraintActionType.RESTRICT) {
            throw DbException.get(90045, "ON DELETE");
        }
        this.deleteAction = action;
        this.buildDeleteSQL();
    }

    public void updateOnTableColumnRename() {
        if (this.deleteAction != null) {
            this.deleteSQL = null;
            this.buildDeleteSQL();
        }
        if (this.updateAction != null) {
            this.updateSQL = null;
            this.buildUpdateSQL();
        }
    }

    private void buildDeleteSQL() {
        if (this.deleteAction == ConstraintActionType.RESTRICT) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (this.deleteAction == ConstraintActionType.CASCADE) {
            builder.append("DELETE FROM ");
            this.table.getSQL(builder, true);
        } else {
            this.appendUpdate(builder);
        }
        this.appendWhere(builder);
        this.deleteSQL = builder.toString();
    }

    private Prepared getUpdate(Session session) {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public ConstraintActionType getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(ConstraintActionType action) {
        if (action == this.updateAction && this.updateSQL == null) {
            return;
        }
        if (this.updateAction != ConstraintActionType.RESTRICT) {
            throw DbException.get(90045, "ON UPDATE");
        }
        this.updateAction = action;
        this.buildUpdateSQL();
    }

    private void buildUpdateSQL() {
        if (this.updateAction == ConstraintActionType.RESTRICT) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.appendUpdate(builder);
        this.appendWhere(builder);
        this.updateSQL = builder.toString();
    }

    @Override
    public void rebuild() {
        this.buildUpdateSQL();
        this.buildDeleteSQL();
    }

    private Prepared prepare(Session session, String sql, ConstraintActionType action) {
        Prepared command = session.prepare(sql);
        if (action != ConstraintActionType.CASCADE) {
            ArrayList<Parameter> params = command.getParameters();
            int len = this.columns.length;
            for (int i = 0; i < len; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter param = params.get(i);
                if (action == ConstraintActionType.SET_NULL) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expr = column.getDefaultExpression();
                    if (expr == null) {
                        throw DbException.get(23507, column.getName());
                    }
                    value = expr.getValue(session);
                }
                param.setValue(value);
            }
        }
        return command;
    }

    private void appendUpdate(StringBuilder builder) {
        builder.append("UPDATE ");
        this.table.getSQL(builder, true).append(" SET ");
        int l = this.columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.columns[i].column.getSQL(builder, true).append("=?");
        }
    }

    private void appendWhere(StringBuilder builder) {
        builder.append(" WHERE ");
        int l = this.columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            this.columns[i].column.getSQL(builder, true).append("=?");
        }
    }

    @Override
    public Table getRefTable() {
        return this.refTable;
    }

    @Override
    public boolean usesIndex(Index idx) {
        return idx == this.index || idx == this.refIndex;
    }

    @Override
    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            DbException.throwInternalError(index + " " + this.toString());
        }
    }

    @Override
    public boolean isBefore() {
        return false;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        session.startStatementWithinTransaction();
        StringBuilder builder = new StringBuilder("SELECT 1 FROM (SELECT ");
        IndexColumn.writeColumns(builder, this.columns, true);
        builder.append(" FROM ");
        this.table.getSQL(builder, true).append(" WHERE ");
        IndexColumn.writeColumns(builder, this.columns, " AND ", " IS NOT NULL ", true);
        builder.append(" ORDER BY ");
        IndexColumn.writeColumns(builder, this.columns, true);
        builder.append(") C WHERE NOT EXISTS(SELECT 1 FROM ");
        this.refTable.getSQL(builder, true).append(" P WHERE ");
        int l = this.columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append("C.");
            this.columns[i].getSQL(builder, true).append('=').append("P.");
            this.refColumns[i].getSQL(builder, true);
        }
        builder.append(')');
        ResultInterface r = session.prepare(builder.toString()).query(1);
        if (r.next()) {
            throw DbException.get(23506, this.getShortDescription(null, null));
        }
    }

    @Override
    public Index getUniqueIndex() {
        return this.refIndex;
    }
}

