/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.constraint;

import java.util.HashSet;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.CHECK;
    }

    public void setTableFilter(TableFilter filter) {
        this.filter = filter;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        StringBuilder buff = new StringBuilder("ALTER TABLE ");
        forTable.getSQL(buff, true).append(" ADD CONSTRAINT ");
        if (forTable.isHidden()) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append(" CHECK(");
        this.expr.getUnenclosedSQL(buff, true).append(") NOCHECK");
        return buff.toString();
    }

    private String getShortDescription() {
        StringBuilder builder = new StringBuilder().append(this.getName()).append(": ");
        this.expr.getSQL(builder, false);
        return builder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table t2, Row oldRow, Row newRow) {
        boolean b;
        if (newRow == null) {
            return;
        }
        this.filter.set(newRow);
        try {
            Value v = this.expr.getValue(session);
            b = v == ValueNull.INSTANCE || v.getBoolean();
        }
        catch (DbException ex) {
            throw DbException.get(23514, ex, this.getShortDescription());
        }
        if (!b) {
            throw DbException.get(23513, this.getShortDescription());
        }
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> columns = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(columns, table));
        return columns;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuilder builder = new StringBuilder().append("SELECT 1 FROM ");
        this.filter.getTable().getSQL(builder, true).append(" WHERE NOT(");
        this.expr.getSQL(builder, true).append(')');
        String sql = builder.toString();
        ResultInterface r = session.prepare(sql).query(1);
        if (r.next()) {
            throw DbException.get(23513, this.getName());
        }
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.expr.isEverything(visitor);
    }
}

