/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LazyResult;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultTarget;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.ColumnNamer;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;

public class SelectUnion
extends Query {
    private final UnionType unionType;
    final Query left;
    final Query right;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, UnionType unionType, Query query2, Query right) {
        super(session);
        this.unionType = unionType;
        this.left = query2;
        this.right = right;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public void prepareJoinBatch() {
        this.left.prepareJoinBatch();
        this.right.prepareJoinBatch();
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setDistinctIfPossible() {
        this.setDistinct();
    }

    private Value[] convert(Value[] values, int columnCount) {
        Value[] newValues = columnCount == values.length ? values : new Value[columnCount];
        Mode mode = this.session.getDatabase().getMode();
        for (int i = 0; i < columnCount; ++i) {
            Expression e = (Expression)this.expressions.get(i);
            newValues[i] = values[i].convertTo(e.getType(), mode, null);
        }
        return newValues;
    }

    @Override
    public ResultInterface queryMeta() {
        int columnCount = this.left.getColumnCount();
        LocalResult result = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, columnCount, true);
        result.done();
        return result;
    }

    public LocalResult getEmptyResult() {
        int columnCount = this.left.getColumnCount();
        return this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, columnCount, false);
    }

    @Override
    protected ResultInterface queryWithoutCache(int maxRows, ResultTarget target) {
        Value v;
        if (maxRows != 0) {
            Value v2;
            int l = this.limitExpr == null ? -1 : ((v2 = this.limitExpr.getValue(this.session)) == ValueNull.INSTANCE ? -1 : v2.getInt());
            l = l < 0 ? maxRows : Math.min(l, maxRows);
            this.limitExpr = ValueExpression.get(ValueInt.get(l));
        }
        Database db = this.session.getDatabase();
        if (db.getSettings().optimizeInsertFromSelect && this.unionType == UnionType.UNION_ALL && target != null && this.sort == null && !this.distinct && maxRows == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.left.query(0, target);
            this.right.query(0, target);
            return null;
        }
        int columnCount = this.left.getColumnCount();
        if (!(!this.session.isLazyQueryExecution() || this.unionType != UnionType.UNION_ALL || this.distinct || this.sort != null || this.randomAccessResult || this.isForUpdate || this.offsetExpr != null || this.fetchPercent || this.withTies || !this.isReadOnly())) {
            Value v3;
            int limit = -1;
            if (this.limitExpr != null && (v3 = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                limit = v3.getInt();
            }
            if (limit != 0) {
                LazyResultUnion lazyResult = new LazyResultUnion(this.expressionArray, columnCount);
                if (limit > 0) {
                    lazyResult.setLimit(limit);
                }
                return lazyResult;
            }
        }
        LocalResult result = db.getResultFactory().create(this.session, this.expressionArray, columnCount, false);
        if (this.sort != null) {
            result.setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinctIfPossible();
            this.right.setDistinctIfPossible();
            result.setDistinct();
        }
        switch (this.unionType) {
            case UNION: 
            case EXCEPT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                result.setDistinct();
                break;
            }
            case UNION_ALL: {
                break;
            }
            case INTERSECT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        ResultInterface l = this.left.query(0);
        ResultInterface r = this.right.query(0);
        l.reset();
        r.reset();
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow(), columnCount));
                }
                while (r.next()) {
                    result.addRow(this.convert(r.currentRow(), columnCount));
                }
                break;
            }
            case EXCEPT: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow(), columnCount));
                }
                while (r.next()) {
                    result.removeDistinct(this.convert(r.currentRow(), columnCount));
                }
                break;
            }
            case INTERSECT: {
                LocalResult temp = db.getResultFactory().create(this.session, this.expressionArray, columnCount, false);
                temp.setDistinct();
                while (l.next()) {
                    temp.addRow(this.convert(l.currentRow(), columnCount));
                }
                temp.done();
                while (r.next()) {
                    Value[] values = this.convert(r.currentRow(), columnCount);
                    if (!temp.containsDistinct(values)) continue;
                    result.addRow(values);
                }
                temp.close();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        if (this.offsetExpr != null) {
            result.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            result.setLimit(v.getInt());
            result.setFetchPercent(this.fetchPercent);
            if (this.withTies) {
                result.setWithTies(this.sort);
            }
        }
        l.close();
        r.close();
        result.done();
        if (target != null) {
            while (result.next()) {
                target.addRow(result.currentRow());
            }
            result.close();
            return null;
        }
        return result;
    }

    @Override
    public void init() {
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int len = this.left.getColumnCount();
        if (len != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> le = this.left.getExpressions();
        this.expressions = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            Expression l = le.get(i);
            this.expressions.add(l);
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int len = this.left.getColumnCount();
        this.expressions = new ArrayList(len);
        ArrayList<Expression> le = this.left.getExpressions();
        ArrayList<Expression> re = this.right.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < len; ++i) {
            Expression l = le.get(i);
            Expression r = re.get(i);
            String columnName = columnNamer.getColumnName(l, i, l.getAlias());
            Column col = new Column(columnName, Value.getHigherType(l.getType(), r.getType()));
            ExpressionColumn e = new ExpressionColumn(this.session.getDatabase(), col);
            this.expressions.add(e);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = this.left.getTables();
        set.addAll(this.right.getTables());
        return set;
    }

    @Override
    public void setForUpdate(boolean forUpdate) {
        this.left.setForUpdate(forUpdate);
        this.right.setForUpdate(forUpdate);
        this.isForUpdate = forUpdate;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: 
            case INTERSECT: {
                this.left.addGlobalCondition(param, columnId, comparisonType);
                this.right.addGlobalCondition(param, columnId, comparisonType);
                break;
            }
            case EXCEPT: {
                this.left.addGlobalCondition(param, columnId, comparisonType);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        StringBuilder buff = new StringBuilder();
        buff.append('(').append(this.left.getPlanSQL(alwaysQuote)).append(')');
        switch (this.unionType) {
            case UNION_ALL: {
                buff.append("\nUNION ALL\n");
                break;
            }
            case UNION: {
                buff.append("\nUNION\n");
                break;
            }
            case INTERSECT: {
                buff.append("\nINTERSECT\n");
                break;
            }
            case EXCEPT: {
                buff.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        buff.append('(').append(this.right.getPlanSQL(alwaysQuote)).append(')');
        Expression[] exprList = this.expressions.toArray(new Expression[0]);
        if (this.sort != null) {
            buff.append("\nORDER BY ").append(this.sort.getSQL(exprList, exprList.length, alwaysQuote));
        }
        this.appendLimitToSQL(buff, alwaysQuote);
        if (this.sampleSizeExpr != null) {
            buff.append("\nSAMPLE_SIZE ");
            this.sampleSizeExpr.getUnenclosedSQL(buff, alwaysQuote);
        }
        if (this.isForUpdate) {
            buff.append("\nFOR UPDATE");
        }
        return buff.toString();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session s2, int stage) {
        this.left.updateAggregate(s2, stage);
        this.right.updateAggregate(s2, stage);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }

    private final class LazyResultUnion
    extends LazyResult {
        int columnCount;
        ResultInterface l;
        ResultInterface r;
        boolean leftDone;
        boolean rightDone;

        LazyResultUnion(Expression[] expressions, int columnCount) {
            super(expressions);
            this.columnCount = columnCount;
        }

        @Override
        public int getVisibleColumnCount() {
            return this.columnCount;
        }

        @Override
        protected Value[] fetchNextRow() {
            if (this.rightDone) {
                return null;
            }
            if (!this.leftDone) {
                if (this.l == null) {
                    this.l = SelectUnion.this.left.query(0);
                    this.l.reset();
                }
                if (this.l.next()) {
                    return this.l.currentRow();
                }
                this.leftDone = true;
            }
            if (this.r == null) {
                this.r = SelectUnion.this.right.query(0);
                this.r.reset();
            }
            if (this.r.next()) {
                return this.r.currentRow();
            }
            this.rightDone = true;
            return null;
        }

        @Override
        public void close() {
            super.close();
            if (this.l != null) {
                this.l.close();
            }
            if (this.r != null) {
                this.r.close();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.l != null) {
                this.l.reset();
            }
            if (this.r != null) {
                this.r.reset();
            }
            this.leftDone = false;
            this.rightDone = false;
        }
    }

    public static enum UnionType {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

