/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.gridgain.internal.h2.command.dml.ScriptBase;
import org.gridgain.internal.h2.command.dml.SetTypes;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.Comment;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.Setting;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.engine.UserAggregate;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Constant;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private Charset charset = StandardCharsets.UTF_8;
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private boolean withColumns;
    private LocalResult result;
    private String lineSeparatorString;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(Session session) {
        super(session);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> schemaNames) {
        this.schemaNames = schemaNames;
    }

    public void setTables(Collection<Table> tables) {
        this.tables = tables;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setLobBlockSize(long blockSize) {
        this.lobBlockSize = MathUtils.convertLongToInt(blockSize);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult r = this.createResult();
        r.done();
        return r;
    }

    private LocalResult createResult() {
        Database db = this.session.getDatabase();
        return db.getResultFactory().create(this.session, new Expression[]{new ExpressionColumn(db, new Column("SCRIPT", 13))}, 1, true);
    }

    @Override
    public ResultInterface query(int maxrows) {
        this.session.getUser().checkAdmin();
        this.reset();
        Database db = this.session.getDatabase();
        if (this.schemaNames != null) {
            for (String string : this.schemaNames) {
                Schema schema = db.findSchema(string);
                if (schema != null) continue;
                throw DbException.get(90079, string);
            }
        }
        try {
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            if (this.settings) {
                for (Setting setting : db.getAllSettings()) {
                    if (setting.getName().equals(SetTypes.getTypeName(33))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            for (User user : db.getAllUsers()) {
                this.add(user.getCreateSQL(this.passwords), false);
            }
            for (Role role : db.getAllRoles()) {
                this.add(role.getCreateSQL(true), false);
            }
            for (Schema schema : db.getAllSchemas()) {
                if (this.excludeSchema(schema)) continue;
                this.add(schema.getCreateSQL(), false);
            }
            for (Domain domain : db.getAllDomains()) {
                if (this.drop) {
                    this.add(domain.getDropSQL(), false);
                }
                this.add(domain.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : db.getAllSchemaObjects(11)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                Constant constant = (Constant)schemaObject;
                this.add(constant.getCreateSQL(), false);
            }
            ArrayList<Table> tables = db.getAllTablesAndViews(false);
            Collections.sort(tables, new Comparator<Table>(){

                @Override
                public int compare(Table t1, Table t2) {
                    return t1.getId() - t2.getId();
                }
            });
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, false, false);
                String sql = table.getCreateSQL();
                if (sql == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            for (SchemaObject schemaObject : db.getAllSchemaObjects(9)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                if (this.drop) {
                    this.add(schemaObject.getDropSQL(), false);
                }
                this.add(schemaObject.getCreateSQL(), false);
            }
            for (UserAggregate userAggregate : db.getAllAggregates()) {
                if (this.drop) {
                    this.add(userAggregate.getDropSQL(), false);
                }
                this.add(userAggregate.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : db.getAllSchemaObjects(3)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                Sequence sequence = (Sequence)schemaObject;
                if (this.drop) {
                    this.add(sequence.getDropSQL(), false);
                }
                this.add(sequence.getCreateSQL(), false);
            }
            boolean bl = false;
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, false, false);
                String createTableSql = table.getCreateSQL();
                if (createTableSql == null) continue;
                TableType tableType = table.getTableType();
                this.add(createTableSql, false);
                ArrayList<Constraint> constraints = table.getConstraints();
                if (constraints != null) {
                    for (Constraint constraint : constraints) {
                        if (Constraint.Type.PRIMARY_KEY != constraint.getConstraintType()) continue;
                        this.add(constraint.getCreateSQLWithoutIndexes(), false);
                    }
                }
                if (TableType.TABLE == tableType) {
                    if (table.canGetRowCount()) {
                        StringBuilder builder = new StringBuilder("-- ").append(table.getRowCountApproximation(this.session)).append(" +/- SELECT COUNT(*) FROM ");
                        table.getSQL(builder, false);
                        this.add(builder.toString(), false);
                    }
                    if (this.data) {
                        int n;
                        n = this.generateInsertValues(n, table);
                    }
                }
                ArrayList<Index> indexes = table.getIndexes();
                for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                    Index index = indexes.get(j);
                    if (index.getIndexType().getBelongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ArrayList<SchemaObject> arrayList = db.getAllSchemaObjects(5);
            Collections.sort(arrayList, null);
            for (SchemaObject obj : arrayList) {
                Constraint constraint;
                if (this.excludeSchema(obj.getSchema()) || this.excludeTable((constraint = (Constraint)obj).getTable()) || constraint.getTable().isHidden() || Constraint.Type.PRIMARY_KEY == constraint.getConstraintType()) continue;
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            for (SchemaObject obj : db.getAllSchemaObjects(4)) {
                TriggerObject trigger;
                if (this.excludeSchema(obj.getSchema()) || this.excludeTable((trigger = (TriggerObject)obj).getTable())) continue;
                this.add(trigger.getCreateSQL(), false);
            }
            for (Right right : db.getAllRights()) {
                Table table;
                DbObject object = right.getGrantedObject();
                if (object != null && (object instanceof Schema ? this.excludeSchema((Schema)object) : object instanceof Table && (this.excludeSchema((table = (Table)object).getSchema()) || this.excludeTable(table)))) continue;
                this.add(right.getCreateSQL(), false);
            }
            for (Comment comment : db.getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    private int generateInsertValues(int count, Table table) throws IOException {
        PlanItem plan = table.getBestPlanItem(this.session, null, null, -1, null, null, false);
        Index index = plan.getIndex();
        Cursor cursor = index.find(this.session, null, null);
        Column[] columns = table.getColumns();
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        table.getSQL(builder, true);
        if (this.withColumns) {
            builder.append('(');
            Column.writeColumns(builder, columns, true);
            builder.append(')');
        }
        builder.append(" VALUES");
        if (!this.simple) {
            builder.append('\n');
        }
        builder.append('(');
        String ins = builder.toString();
        builder = null;
        while (cursor.next()) {
            Row row = cursor.get();
            if (builder == null) {
                builder = new StringBuilder(ins);
            } else {
                builder.append(",\n(");
            }
            for (int j = 0; j < row.getColumnCount(); ++j) {
                Value v;
                if (j > 0) {
                    builder.append(", ");
                }
                if ((v = row.getValue(j)).getType().getPrecision() > (long)this.lobBlockSize) {
                    int id;
                    if (v.getValueType() == 16) {
                        id = this.writeLobStream(v);
                        builder.append("SYSTEM_COMBINE_CLOB(").append(id).append(')');
                        continue;
                    }
                    if (v.getValueType() == 15) {
                        id = this.writeLobStream(v);
                        builder.append("SYSTEM_COMBINE_BLOB(").append(id).append(')');
                        continue;
                    }
                    v.getSQL(builder);
                    continue;
                }
                v.getSQL(builder);
            }
            builder.append(')');
            if ((++count & 0x7F) == 0) {
                this.checkCanceled();
            }
            if (!this.simple && builder.length() <= 4096) continue;
            this.add(builder.toString(), true);
            builder = null;
        }
        if (builder != null) {
            this.add(builder.toString(), true);
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private int writeLobStream(Value v) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY)", true);
            this.add("CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART)", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        id = this.nextLobId++;
        switch (v.getValueType()) {
            case 15: {
                bytes = new byte[this.lobBlockSize];
                input = v.getInputStream();
                var5_7 = null;
                i = 0;
                while (true) {
                    buff = new StringBuilder(this.lobBlockSize * 2);
                    buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", NULL, '");
                    len = IOUtils.readFully(input, bytes, this.lobBlockSize);
                    if (len <= 0) break;
                    StringUtils.convertBytesToHex(buff, bytes, len).append("')");
                    sql = buff.toString();
                    this.add(sql, true);
                    ++i;
                }
                if (input == null) break;
                if (var5_7 == null) ** GOTO lbl35
                try {
                    input.close();
                }
                catch (Throwable i) {
                    var5_7.addSuppressed(i);
                }
                break;
lbl35:
                // 1 sources

                input.close();
                break;
                catch (Throwable i) {
                    try {
                        var5_7 = i;
                        throw i;
                    }
                    catch (Throwable var10_21) {
                        if (input != null) {
                            if (var5_7 != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable var11_22) {
                                    var5_7.addSuppressed(var11_22);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw var10_21;
                    }
                }
            }
            case 16: {
                chars = new char[this.lobBlockSize];
                reader = v.getReader();
                var5_8 = null;
                i = 0;
                while (true) {
                    buff = new StringBuilder(this.lobBlockSize * 2);
                    buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", ");
                    len = IOUtils.readFully(reader, chars, this.lobBlockSize);
                    if (len == 0) break;
                    StringUtils.quoteStringSQL(buff, new String(chars, 0, len)).append(", NULL)");
                    sql = buff.toString();
                    this.add(sql, true);
                    ++i;
                }
                if (reader == null) break;
                if (var5_8 == null) ** GOTO lbl78
                try {
                    reader.close();
                }
                catch (Throwable var6_13) {
                    var5_8.addSuppressed(var6_13);
                }
                break;
lbl78:
                // 1 sources

                reader.close();
                break;
                catch (Throwable var6_14) {
                    try {
                        var5_8 = var6_14;
                        throw var6_14;
                    }
                    catch (Throwable var12_23) {
                        if (reader != null) {
                            if (var5_8 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable var13_24) {
                                    var5_8.addSuppressed(var13_24);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw var12_23;
                    }
                }
            }
            default: {
                DbException.throwInternalError("type:" + v.getValueType());
            }
        }
        return id;
    }

    public static InputStream combineBlob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "BDATA", id);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }
        };
    }

    public static Reader combineClob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "CDATA", id);
        return new Reader(){
            private Reader current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public int read(char[] buffer, int off, int len) throws IOException {
                int i;
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buffer[off] = (char)c;
                for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                    buffer[off + i] = (char)c;
                }
                return i;
            }
        };
    }

    private static ResultSet getLobStream(Connection conn, String column, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT " + column + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        prep.setInt(1, id);
        return prep.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        this.lineSeparatorString = SysProperties.LINE_SEPARATOR;
        this.lineSeparator = this.lineSeparatorString.getBytes(this.charset);
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews()) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String s2, boolean insert) throws IOException {
        if (s2 == null) {
            return;
        }
        if (this.lineSeparator.length > 1 || this.lineSeparator[0] != 10) {
            s2 = StringUtils.replaceAll(s2, "\n", this.lineSeparatorString);
        }
        s2 = s2 + ";";
        if (this.out != null) {
            byte[] buff = s2.getBytes(this.charset);
            int len = MathUtils.roundUpInt(buff.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            for (int i = buff.length; i < len - this.lineSeparator.length; ++i) {
                this.buffer[i] = 32;
            }
            int j = 0;
            int i = len - this.lineSeparator.length;
            while (i < len) {
                this.buffer[i] = this.lineSeparator[j];
                ++i;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                Value[] row = new Value[]{ValueString.get(s2)};
                this.result.addRow(row);
            }
        } else {
            Value[] row = new Value[]{ValueString.get(s2)};
            this.result.addRow(row);
        }
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setWithColumns(boolean withColumns) {
        this.withColumns = withColumns;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

