/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.value.ValueRow;

public class PlainGroupByData
extends GroupByData {
    private List<Object[]> rows = new ArrayList<Object[]>();
    private Iterator<Object[]> cursor;
    private Object[] curr;

    public PlainGroupByData(Session ses) {
        super(ses);
    }

    @Override
    public Object[] nextSource(ValueRow grpKey, int width) {
        Object[] grpByData = new Object[width];
        this.rows.add(grpByData);
        this.onGroupChanged(null, null, grpByData);
        return grpByData;
    }

    @Override
    public void updateCurrent(Object[] grpByExprData) {
        Object[] old = this.rows.set(this.rows.size() - 1, grpByExprData);
        this.onGroupChanged(null, old, grpByExprData);
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    @Override
    public void done(int width) {
        this.cursor = this.rows.iterator();
    }

    @Override
    public boolean next() {
        assert (this.cursor != null);
        boolean hasNext = this.cursor.hasNext();
        this.curr = hasNext ? this.cursor.next() : null;
        return hasNext;
    }

    @Override
    public ValueRow groupKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] groupByExprData() {
        return this.curr;
    }

    @Override
    public void reset() {
        this.rows = new ArrayList<Object[]>();
        this.cursor = null;
        this.curr = null;
    }

    @Override
    public void remove() {
        this.cursor.remove();
        this.curr = null;
    }

    @Override
    public void onRowProcessed() {
    }
}

