/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.command.dml.CommandWithValues;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.Update;
import org.gridgain.internal.h2.engine.GeneratedKeys;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.PageDataIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVPrimaryIndex;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultTarget;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class Insert
extends CommandWithValues
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private TableFilter sourceTableFilter;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private boolean ignore;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            if (!this.session.getDatabase().isMVStore()) {
                this.table.lock(this.session, true, true);
            }
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0L);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        generatedKeys.initialize(this.table);
        int listSize = this.valuesExpressionList.size();
        if (listSize > 0) {
            Mode mode = this.session.getDatabase().getMode();
            int columnLen = this.columns.length;
            for (int x = 0; x < listSize; ++x) {
                generatedKeys.nextRow();
                Row newRow = this.table.getTemplateRow();
                Expression[] expr = (Expression[])this.valuesExpressionList.get(x);
                this.setCurrentRowNumber(x + 1);
                for (int i = 0; i < columnLen; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    e = e.optimize(this.session);
                    try {
                        Value v = c.convert(e.getValue(this.session), mode);
                        newRow.setValue(index, v);
                        if (!e.isGeneratedKey()) continue;
                        generatedKeys.add(c);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, x, Insert.getSimpleSQL(expr));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, newRow);
                boolean done = this.table.fireBeforeRow(this.session, null, newRow);
                if (done) continue;
                this.table.lock(this.session, true, false);
                try {
                    this.table.addRow(this.session, newRow);
                }
                catch (DbException de) {
                    if (this.handleOnDuplicate(de, null)) {
                        ++this.rowNumber;
                        continue;
                    }
                    --this.rowNumber;
                    continue;
                }
                generatedKeys.confirmRow(newRow);
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfterRow(this.session, null, newRow, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                ResultInterface rows = this.query.query(0);
                while (rows.next()) {
                    generatedKeys.nextRow();
                    Value[] r = rows.currentRow();
                    try {
                        Row newRow = this.addRowImpl(r);
                        if (newRow == null) continue;
                        generatedKeys.confirmRow(newRow);
                    }
                    catch (DbException de) {
                        if (this.handleOnDuplicate(de, r)) {
                            ++this.rowNumber;
                            continue;
                        }
                        --this.rowNumber;
                    }
                }
                rows.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] values) {
        this.addRowImpl(values);
    }

    private Row addRowImpl(Value[] values) {
        Row newRow = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        Mode mode = this.session.getDatabase().getMode();
        int len = this.columns.length;
        for (int j = 0; j < len; ++j) {
            Column c = this.columns[j];
            int index = c.getColumnId();
            try {
                Value v = c.convert(values[j], mode);
                newRow.setValue(index, v);
                continue;
            }
            catch (DbException ex) {
                throw this.setRow(ex, this.rowNumber, Insert.getSQL(values));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, newRow);
        boolean done = this.table.fireBeforeRow(this.session, null, newRow);
        if (!done) {
            this.table.addRow(this.session, newRow);
            this.session.log(this.table, (short)0, newRow);
            this.table.fireAfterRow(this.session, null, newRow, false);
            return newRow;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public void limitsWereApplied() {
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        this.table.getSQL(builder, alwaysQuote).append('(');
        Column.writeColumns(builder, this.columns, alwaysQuote);
        builder.append(")\n");
        if (this.insertFromSelect) {
            builder.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            builder.append("SORTED ");
        }
        if (!this.valuesExpressionList.isEmpty()) {
            builder.append("VALUES ");
            int row = 0;
            if (this.valuesExpressionList.size() > 1) {
                builder.append('\n');
            }
            for (Expression[] expr : this.valuesExpressionList) {
                if (row++ > 0) {
                    builder.append(",\n");
                }
                builder.append('(');
                Expression.writeExpressions(builder, expr, alwaysQuote);
                builder.append(')');
            }
        } else {
            builder.append(this.query.getPlanSQL(alwaysQuote));
        }
        return builder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getVisibleColums();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expr : this.valuesExpressionList) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int len = expr.length;
                for (int i = 0; i < len; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    if (this.sourceTableFilter != null) {
                        e.mapColumns(this.sourceTableFilter, 0, 0);
                    }
                    if ((e = e.optimize(this.session)) instanceof Parameter) {
                        Parameter p = (Parameter)e;
                        p.setColumn(this.columns[i]);
                    }
                    expr[i] = e;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.sortedInsertMode = sortedInsertMode;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean value) {
        this.insertFromSelect = value;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    private boolean handleOnDuplicate(DbException de, Value[] currentRow) {
        if (de.getErrorCode() != 23505) {
            throw de;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            if (this.ignore) {
                return false;
            }
            throw de;
        }
        ArrayList<Object> variableNames = new ArrayList<Object>(this.duplicateKeyAssignmentMap.size());
        Expression[] row = currentRow == null ? (Expression[])this.valuesExpressionList.get((int)this.getCurrentRowNumber() - 1) : new Expression[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Value value;
            StringBuilder builder = this.table.getSQL(new StringBuilder(), true).append('.');
            String key = this.columns[i].getSQL(builder, true).toString();
            variableNames.add(key);
            if (currentRow != null) {
                value = currentRow[i];
                row[i] = ValueExpression.get(value);
            } else {
                value = row[i].getValue(this.session);
            }
            this.session.setVariable(key, value);
        }
        StringBuilder builder = new StringBuilder("UPDATE ");
        this.table.getSQL(builder, true).append(" SET ");
        boolean f = false;
        for (Column column : this.duplicateKeyAssignmentMap.keySet()) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            Expression ex = this.duplicateKeyAssignmentMap.get(column);
            column.getSQL(builder, true).append('=');
            ex.getSQL(builder, true);
        }
        builder.append(" WHERE ");
        Index foundIndex = (Index)de.getSource();
        if (foundIndex == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        this.prepareUpdateCondition(foundIndex, row).getSQL(builder, true);
        String sql = builder.toString();
        Update command = (Update)this.session.prepare(sql);
        command.setUpdateToCurrentValuesReturnsZero(true);
        for (Parameter param : command.getParameters()) {
            Parameter parameter = (Parameter)this.parameters.get(param.getIndex());
            param.setValue(parameter.getValue(this.session));
        }
        boolean result = command.update() > 0;
        for (String string : variableNames) {
            this.session.setVariable(string, ValueNull.INSTANCE);
        }
        return result;
    }

    private Expression prepareUpdateCondition(Index foundIndex, Expression[] row) {
        Column[] indexedColumns;
        if (foundIndex instanceof MVPrimaryIndex) {
            MVPrimaryIndex foundMV = (MVPrimaryIndex)foundIndex;
            indexedColumns = new Column[]{foundMV.getIndexColumns()[foundMV.getMainIndexColumn()].column};
        } else if (foundIndex instanceof PageDataIndex) {
            Column[] columnArray;
            PageDataIndex foundPD = (PageDataIndex)foundIndex;
            int mainIndexColumn = foundPD.getMainIndexColumn();
            if (mainIndexColumn >= 0) {
                Column[] columnArray2 = new Column[1];
                columnArray = columnArray2;
                columnArray2[0] = foundPD.getIndexColumns()[mainIndexColumn].column;
            } else {
                columnArray = foundIndex.getColumns();
            }
            indexedColumns = columnArray;
        } else {
            indexedColumns = foundIndex.getColumns();
        }
        Condition condition = null;
        block0: for (Column column : indexedColumns) {
            ExpressionColumn expr = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName(), false);
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expr.getColumnName().equals(this.columns[i].getName())) continue;
                if (condition == null) {
                    condition = new Comparison(this.session, 0, expr, row[i]);
                    continue block0;
                }
                condition = new ConditionAndOr(0, condition, new Comparison(this.session, 0, expr, row[i]));
                continue block0;
            }
        }
        return condition;
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }
}

