/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.constraint.ConstraintActionType;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;

public class DropDomain
extends DefineCommand {
    private String typeName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropDomain(Session session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Domain type = db.findDomain(this.typeName);
        if (type == null) {
            if (!this.ifExists) {
                throw DbException.get(90120, this.typeName);
            }
        } else {
            for (Table t2 : db.getAllTablesAndViews(false)) {
                boolean modified = false;
                for (Column c : t2.getColumns()) {
                    Domain domain = c.getDomain();
                    if (domain == null || !domain.getName().equals(this.typeName)) continue;
                    if (this.dropAction == ConstraintActionType.RESTRICT) {
                        throw DbException.get(90107, this.typeName, t2.getCreateSQL());
                    }
                    c.setOriginalSQL(type.getColumn().getOriginalSQL());
                    c.setDomain(null);
                    modified = true;
                }
                if (!modified) continue;
                db.updateMeta(this.session, t2);
            }
            db.removeDatabaseObject(this.session, type);
        }
        return 0;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    @Override
    public int getType() {
        return 47;
    }
}

