/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.gridgain.internal.h2.command.ddl.CommandWithColumns;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.command.dml.Insert;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.ColumnNamer;

public class CreateTable
extends CommandWithColumns {
    private final CreateTableData data = new CreateTableData();
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;
    private boolean withNoData;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query2) {
        this.asQuery = query2;
    }

    public void setTemporary(boolean temporary) {
        this.data.temporary = temporary;
    }

    public void setTableName(String tableName) {
        this.data.tableName = tableName;
    }

    @Override
    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        boolean isSessionTemporary;
        Database db;
        if (!this.transactional) {
            this.session.commit(true);
        }
        if (!(db = this.session.getDatabase()).isPersistent()) {
            this.data.persistIndexes = false;
        }
        boolean bl = isSessionTemporary = this.data.temporary && !this.data.globalTemporary;
        if (!isSessionTemporary) {
            db.lockMeta(this.session);
        }
        if (this.getSchema().resolveTableOrView(this.session, this.data.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.tableName);
        }
        if (this.asQuery != null) {
            this.asQuery.prepare();
            if (this.data.columns.isEmpty()) {
                this.generateColumnsFromQuery();
            } else {
                if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                    throw DbException.get(21002);
                }
                ArrayList<Column> columns = this.data.columns;
                for (int i = 0; i < columns.size(); ++i) {
                    Column column = columns.get(i);
                    if (column.getType().getValueType() != -1) continue;
                    columns.set(i, new Column(column.getName(), this.asQuery.getExpressions().get(i).getType()));
                }
            }
        }
        this.changePrimaryKeysToNotNull(this.data.columns);
        this.data.id = this.getObjectId();
        this.data.create = this.create;
        this.data.session = this.session;
        Table table = this.getSchema().createTable(this.data);
        ArrayList<Sequence> sequences = this.generateSequences(this.data.columns, this.data.temporary);
        table.setComment(this.comment);
        if (isSessionTemporary) {
            if (this.onCommitDrop) {
                table.setOnCommitDrop(true);
            }
            if (this.onCommitTruncate) {
                table.setOnCommitTruncate(true);
            }
            this.session.addLocalTempTable(table);
        } else {
            db.lockMeta(this.session);
            db.addSchemaObject(this.session, table);
        }
        try {
            for (Column c : this.data.columns) {
                c.prepareExpression(this.session);
            }
            for (Sequence sequence : sequences) {
                table.addSequence(sequence);
            }
            this.createConstraints();
            if (this.asQuery != null && !this.withNoData) {
                boolean old = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    this.session.startStatementWithinTransaction();
                    Insert insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(old);
                }
            }
            HashSet<DbObject> set = new HashSet<DbObject>();
            table.addDependencies(set);
            for (DbObject obj : set) {
                Table t2;
                if (obj == table || obj.getType() != 0 || !(obj instanceof Table) || (t2 = (Table)obj).getId() <= table.getId()) continue;
                throw DbException.get(50100, "Table depends on another table with a higher ID: " + t2 + ", this is currently not supported, as it would prevent the database from being re-opened");
            }
        }
        catch (DbException e) {
            try {
                db.checkPowerOff();
                db.removeSchemaObject(this.session, table);
                if (!this.transactional) {
                    this.session.commit(true);
                }
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int columnCount = this.asQuery.getColumnCount();
        ArrayList<Expression> expressions = this.asQuery.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = expressions.get(i);
            String name = columnNamer.getColumnName(expr, i, expr.getAlias());
            Column col = new Column(name, expr.getType());
            this.addColumn(col);
        }
    }

    public void setPersistIndexes(boolean persistIndexes) {
        this.data.persistIndexes = persistIndexes;
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.data.globalTemporary = globalTemporary;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPersistData(boolean persistData) {
        this.data.persistData = persistData;
        if (!persistData) {
            this.data.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.sortedInsertMode = sortedInsertMode;
    }

    public void setWithNoData(boolean withNoData) {
        this.withNoData = withNoData;
    }

    public void setTableEngine(String tableEngine) {
        this.data.tableEngine = tableEngine;
    }

    public void setTableEngineParams(ArrayList<String> tableEngineParams) {
        this.data.tableEngineParams = tableEngineParams;
    }

    public void setHidden(boolean isHidden) {
        this.data.isHidden = isHidden;
    }

    @Override
    public int getType() {
        return 30;
    }
}

