/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.ddl.CommandWithColumns;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.constraint.ConstraintReferential;
import org.gridgain.internal.h2.constraint.ConstraintUnique;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableBase;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.Utils;

public class AlterTableAlterColumn
extends CommandWithColumns {
    private String tableName;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private boolean addFirst;
    private String addBefore;
    private String addAfter;
    private boolean ifTableExists;
    private boolean ifNotExists;
    private ArrayList<Column> columnsToAdd;
    private ArrayList<Column> columnsToRemove;
    private boolean newVisibility;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOldColumn(Column oldColumn) {
        this.oldColumn = oldColumn;
    }

    public void setAddFirst() {
        this.addFirst = true;
    }

    public void setAddBefore(String before) {
        this.addBefore = before;
    }

    public void setAddAfter(String after) {
        this.addAfter = after;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Table table = this.getSchema().resolveTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkRight(table, 15);
        table.checkSupportAlter();
        table.lock(this.session, true, true);
        if (this.newColumn != null) {
            AlterTableAlterColumn.checkDefaultReferencesTable(table, this.newColumn.getDefaultExpression());
            this.checkClustering(this.newColumn);
        }
        if (this.columnsToAdd != null) {
            for (Column column : this.columnsToAdd) {
                AlterTableAlterColumn.checkDefaultReferencesTable(table, column.getDefaultExpression());
                this.checkClustering(column);
            }
        }
        switch (this.type) {
            case 8: {
                if (!this.oldColumn.isNullable()) break;
                this.checkNoNullValues(table);
                this.oldColumn.setNullable(false);
                db.updateMeta(this.session, table);
                break;
            }
            case 9: {
                if (this.oldColumn.isNullable()) break;
                this.checkNullable(table);
                this.oldColumn.setNullable(true);
                db.updateMeta(this.session, table);
                break;
            }
            case 10: {
                Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
                AlterTableAlterColumn.checkDefaultReferencesTable(table, this.defaultExpression);
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(table, sequence);
                db.updateMeta(this.session, table);
                break;
            }
            case 90: {
                AlterTableAlterColumn.checkDefaultReferencesTable(table, this.defaultExpression);
                this.oldColumn.setOnUpdateExpression(this.session, this.defaultExpression);
                db.updateMeta(this.session, table);
                break;
            }
            case 11: {
                if (this.oldColumn.isWideningConversion(this.newColumn)) {
                    this.convertAutoIncrementColumn(table, this.newColumn);
                    this.oldColumn.copy(this.newColumn);
                    db.updateMeta(this.session, table);
                } else {
                    this.oldColumn.setSequence(null);
                    this.oldColumn.setDefaultExpression(this.session, null);
                    this.oldColumn.setConvertNullToDefault(false);
                    if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                        this.checkNoNullValues(table);
                    } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                        this.checkNullable(table);
                    }
                    if (this.oldColumn.getVisible() ^ this.newColumn.getVisible()) {
                        this.oldColumn.setVisible(this.newColumn.getVisible());
                    }
                    this.convertAutoIncrementColumn(table, this.newColumn);
                    this.copyData(table);
                }
                table.setModified();
                break;
            }
            case 7: {
                if (this.ifNotExists && this.columnsToAdd != null && this.columnsToAdd.size() == 1 && table.doesColumnExist(this.columnsToAdd.get(0).getName())) break;
                ArrayList<Sequence> sequences = this.generateSequences(this.columnsToAdd, false);
                if (this.columnsToAdd != null) {
                    this.changePrimaryKeysToNotNull(this.columnsToAdd);
                }
                this.copyData(table, sequences, true);
                break;
            }
            case 12: {
                if (table.getColumns().length - this.columnsToRemove.size() < 1) {
                    throw DbException.get(90084, this.columnsToRemove.get(0).getSQL(false));
                }
                table.dropMultipleColumnsConstraintsAndIndexes(this.session, this.columnsToRemove);
                this.copyData(table);
                break;
            }
            case 13: {
                int value = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(value);
                db.updateMeta(this.session, table);
                break;
            }
            case 87: {
                this.oldColumn.setVisible(this.newVisibility);
                table.setModified();
                db.updateMeta(this.session, table);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private static void checkDefaultReferencesTable(Table table, Expression defaultExpression) {
        if (defaultExpression == null) {
            return;
        }
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        defaultExpression.isEverything(visitor);
        if (dependencies.contains(table)) {
            throw DbException.get(90083, defaultExpression.getSQL(false));
        }
    }

    private void checkClustering(Column c) {
        if (!"''".equals(this.session.getDatabase().getCluster()) && c.isAutoIncrement()) {
            throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
        }
    }

    private void convertAutoIncrementColumn(Table table, Column c) {
        if (c.isAutoIncrement()) {
            if (c.isPrimaryKey()) {
                c.setOriginalSQL("IDENTITY");
            } else {
                int objId = this.getObjectId();
                c.convertAutoIncrementToSequence(this.session, this.getSchema(), objId, table.isTemporary());
            }
        }
    }

    private void removeSequence(Table table, Sequence sequence) {
        if (sequence != null) {
            table.removeSequence(sequence);
            sequence.setBelongsToTable(false);
            Database db = this.session.getDatabase();
            db.removeSchemaObject(this.session, sequence);
        }
    }

    private void copyData(Table table) {
        this.copyData(table, null, false);
    }

    private void copyData(Table table, ArrayList<Sequence> sequences, boolean createConstraints) {
        if (table.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database db = this.session.getDatabase();
        String baseName = table.getName();
        String tempName = db.getTempTableName(baseName, this.session);
        Column[] columns = table.getColumns();
        ArrayList<Column> newColumns = new ArrayList<Column>(columns.length);
        Table newTable = this.cloneTableStructure(table, columns, db, tempName, newColumns);
        if (sequences != null) {
            for (Sequence sequence : sequences) {
                table.addSequence(sequence);
            }
        }
        try {
            this.checkViews(table, newTable);
        }
        catch (DbException e) {
            StringBuilder builder = new StringBuilder("DROP TABLE ");
            newTable.getSQL(builder, true);
            this.execute(builder.toString(), true);
            throw e;
        }
        String tableName = table.getName();
        ArrayList<TableView> dependentViews = new ArrayList<TableView>(table.getDependentViews());
        for (TableView view : dependentViews) {
            table.removeDependentView(view);
        }
        StringBuilder builder = new StringBuilder("DROP TABLE ");
        table.getSQL(builder, true).append(" IGNORE");
        this.execute(builder.toString(), true);
        db.renameSchemaObject(this.session, newTable, tableName);
        for (DbObject child : newTable.getChildren()) {
            String name;
            if (child instanceof Sequence || (name = child.getName()) == null || child.getCreateSQL() == null || !name.startsWith(tempName + "_")) continue;
            name = name.substring(tempName.length() + 1);
            SchemaObject so = (SchemaObject)child;
            if (so instanceof Constraint) {
                if (so.getSchema().findConstraint(this.session, name) != null) {
                    name = so.getSchema().getUniqueConstraintName(this.session, newTable);
                }
            } else if (so instanceof Index && so.getSchema().findIndex(this.session, name) != null) {
                name = so.getSchema().getUniqueIndexName(this.session, newTable, name);
            }
            db.renameSchemaObject(this.session, so, name);
        }
        if (createConstraints) {
            this.createConstraints();
        }
        for (TableView view : dependentViews) {
            String sql = view.getCreateSQL(true, true);
            this.execute(sql, true);
        }
    }

    private Table cloneTableStructure(Table table, Column[] columns, Database db, String tempName, ArrayList<Column> newColumns) {
        for (Column col : columns) {
            newColumns.add(col.getClone());
        }
        if (this.type == 12) {
            for (Column removeCol : this.columnsToRemove) {
                Column foundCol = null;
                for (Column newCol : newColumns) {
                    if (!newCol.getName().equals(removeCol.getName())) continue;
                    foundCol = newCol;
                    break;
                }
                if (foundCol == null) {
                    throw DbException.throwInternalError(removeCol.getCreateSQL());
                }
                newColumns.remove(foundCol);
            }
        } else if (this.type == 7) {
            int position = this.addFirst ? 0 : (this.addBefore != null ? table.getColumn(this.addBefore).getColumnId() : (this.addAfter != null ? table.getColumn(this.addAfter).getColumnId() + 1 : columns.length));
            if (this.columnsToAdd != null) {
                for (Column column : this.columnsToAdd) {
                    newColumns.add(position++, column);
                }
            }
        } else if (this.type == 11) {
            int position = this.oldColumn.getColumnId();
            newColumns.set(position, this.newColumn);
        }
        int id = db.allocateObjectId();
        CreateTableData data = new CreateTableData();
        data.tableName = tempName;
        data.id = id;
        data.columns = newColumns;
        data.temporary = table.isTemporary();
        data.persistData = table.isPersistData();
        data.persistIndexes = table.isPersistIndexes();
        data.isHidden = table.isHidden();
        data.create = true;
        data.session = this.session;
        Table newTable = this.getSchema().createTable(data);
        newTable.setComment(table.getComment());
        String newTableSQL = newTable.getCreateSQL();
        StringBuilder columnList = new StringBuilder();
        for (Column nc : newColumns) {
            if (columnList.length() > 0) {
                columnList.append(", ");
            }
            if (this.type == 7 && this.columnsToAdd != null && this.columnsToAdd.contains(nc)) {
                Expression def = nc.getDefaultExpression();
                if (def == null) {
                    columnList.append("NULL");
                    continue;
                }
                def.getSQL(columnList, true);
                continue;
            }
            nc.getSQL(columnList, true);
        }
        String newTableName = newTable.getName();
        Schema newTableSchema = newTable.getSchema();
        newTable.removeChildrenAndResources(this.session);
        this.execute(newTableSQL, true);
        newTable = newTableSchema.getTableOrView(this.session, newTableName);
        ArrayList<String> children = Utils.newSmallArrayList();
        ArrayList<String> triggers = Utils.newSmallArrayList();
        boolean hasDelegateIndex = false;
        for (DbObject child : table.getChildren()) {
            ConstraintReferential r;
            String createSQL;
            Index idx;
            if (child instanceof Sequence || child instanceof Index && (idx = (Index)child).getIndexType().getBelongsToConstraint() || (createSQL = child.getCreateSQL()) == null || child instanceof TableView) continue;
            if (child.getType() == 0) {
                DbException.throwInternalError();
            }
            String quotedName = Parser.quoteIdentifier(tempName + "_" + child.getName(), true);
            String sql = null;
            if (child instanceof ConstraintReferential && (r = (ConstraintReferential)child).getTable() != table) {
                sql = r.getCreateSQLForCopy(r.getTable(), newTable, quotedName, false);
            }
            if (sql == null) {
                sql = child.getCreateSQLForCopy(newTable, quotedName);
            }
            if (sql == null) continue;
            if (child instanceof TriggerObject) {
                triggers.add(sql);
                continue;
            }
            if (!hasDelegateIndex) {
                Index index = null;
                if (child instanceof ConstraintUnique) {
                    ConstraintUnique constraint = (ConstraintUnique)child;
                    if (constraint.getConstraintType() == Constraint.Type.PRIMARY_KEY) {
                        index = constraint.getUniqueIndex();
                    }
                } else if (child instanceof Index) {
                    index = (Index)child;
                }
                if (index != null && TableBase.getMainIndexColumn(index.getIndexType(), index.getIndexColumns()) != -1) {
                    this.execute(sql, true);
                    hasDelegateIndex = true;
                    continue;
                }
            }
            children.add(sql);
        }
        StringBuilder buff = new StringBuilder();
        buff.append("INSERT INTO ");
        newTable.getSQL(buff, true);
        buff.append(" (");
        for (int i = 0; i < newTable.getColumns().length; ++i) {
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(newTable.getColumn(i).getName());
        }
        buff.append(")");
        buff.append(" SELECT ");
        if (columnList.length() == 0) {
            buff.append('*');
        } else {
            buff.append((CharSequence)columnList);
        }
        buff.append(" FROM ");
        table.getSQL(buff, true);
        try {
            this.execute(buff.toString(), true);
        }
        catch (Throwable t2) {
            StringBuilder builder = new StringBuilder("DROP TABLE ");
            newTable.getSQL(builder, true);
            this.execute(builder.toString(), true);
            throw t2;
        }
        for (String sql : children) {
            this.execute(sql, true);
        }
        table.setModified();
        for (Column col : newColumns) {
            Sequence seq = col.getSequence();
            if (seq == null) continue;
            table.removeSequence(seq);
            col.setSequence(null);
        }
        for (String sql : triggers) {
            this.execute(sql, true);
        }
        return newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkViews(SchemaObject sourceTable, SchemaObject newTable) {
        String sourceTableName = sourceTable.getName();
        String newTableName = newTable.getName();
        Database db = sourceTable.getDatabase();
        String temp = db.getTempTableName(sourceTableName, this.session);
        db.renameSchemaObject(this.session, sourceTable, temp);
        try {
            db.renameSchemaObject(this.session, newTable, sourceTableName);
            this.checkViewsAreValid(sourceTable);
        }
        finally {
            try {
                db.renameSchemaObject(this.session, newTable, newTableName);
            }
            finally {
                db.renameSchemaObject(this.session, sourceTable, sourceTableName);
            }
        }
    }

    private void checkViewsAreValid(DbObject tableOrView) {
        for (DbObject view : tableOrView.getChildren()) {
            if (!(view instanceof TableView)) continue;
            String sql = ((TableView)view).getQuery();
            try {
                this.session.prepare(sql);
            }
            catch (DbException e) {
                throw DbException.get(90083, e, view.getSQL(false));
            }
            this.checkViewsAreValid(view);
        }
    }

    private void execute(String sql, boolean ddl) {
        Prepared command = this.session.prepare(sql);
        command.update();
        if (ddl) {
            this.session.commit(true);
        }
    }

    private void checkNullable(Table table) {
        for (Index index : table.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw DbException.get(90075, index.getSQL(false));
        }
    }

    private void checkNoNullValues(Table table) {
        StringBuilder builder = new StringBuilder("SELECT COUNT(*) FROM ");
        table.getSQL(builder, true).append(" WHERE ");
        this.oldColumn.getSQL(builder, true).append(" IS NULL");
        String sql = builder.toString();
        Prepared command = this.session.prepare(sql);
        ResultInterface result = command.query(0);
        result.next();
        if (result.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.oldColumn.getSQL(false));
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSelectivity(Expression selectivity) {
        this.newSelectivity = selectivity;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void setNewColumn(Column newColumn) {
        this.newColumn = newColumn;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void addColumn(Column column) {
        if (this.columnsToAdd == null) {
            this.columnsToAdd = new ArrayList();
        }
        this.columnsToAdd.add(column);
    }

    public void setColumnsToRemove(ArrayList<Column> columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    public void setVisible(boolean visible) {
        this.newVisibility = visible;
    }
}

