/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.bnf;

import java.util.HashMap;
import org.gridgain.internal.h2.bnf.Bnf;
import org.gridgain.internal.h2.bnf.BnfVisitor;
import org.gridgain.internal.h2.bnf.Rule;
import org.gridgain.internal.h2.bnf.RuleHead;
import org.gridgain.internal.h2.bnf.Sentence;

public class RuleFixed
implements Rule {
    public static final int YMD = 0;
    public static final int HMS = 1;
    public static final int NANOS = 2;
    public static final int ANY_EXCEPT_SINGLE_QUOTE = 3;
    public static final int ANY_EXCEPT_DOUBLE_QUOTE = 4;
    public static final int ANY_UNTIL_EOL = 5;
    public static final int ANY_UNTIL_END = 6;
    public static final int ANY_WORD = 7;
    public static final int ANY_EXCEPT_2_DOLLAR = 8;
    public static final int HEX_START = 10;
    public static final int CONCAT = 11;
    public static final int AZ_UNDERSCORE = 12;
    public static final int AF = 13;
    public static final int DIGIT = 14;
    public static final int OPEN_BRACKET = 15;
    public static final int CLOSE_BRACKET = 16;
    private final int type;

    RuleFixed(int type) {
        this.type = type;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleFixed(this.type);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        String query2;
        sentence.stopIfRequired();
        String s2 = query2 = sentence.getQuery();
        boolean removeTrailingSpaces = false;
        switch (this.type) {
            case 0: {
                while (s2.length() > 0 && "0123456789-".indexOf(s2.charAt(0)) >= 0) {
                    s2 = s2.substring(1);
                }
                if (s2.length() == 0) {
                    sentence.add("2006-01-01", "1", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 1: {
                while (s2.length() > 0 && "0123456789:".indexOf(s2.charAt(0)) >= 0) {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("12:00:00", "1", 1);
                break;
            }
            case 2: {
                while (s2.length() > 0 && Character.isDigit(s2.charAt(0))) {
                    s2 = s2.substring(1);
                }
                if (s2.length() == 0) {
                    sentence.add("nanoseconds", "0", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 3: {
                while (true) {
                    if (s2.length() > 0 && s2.charAt(0) != '\'') {
                        s2 = s2.substring(1);
                        continue;
                    }
                    if (!s2.startsWith("''")) break;
                    s2 = s2.substring(2);
                }
                if (s2.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("'", "'", 1);
                break;
            }
            case 8: {
                while (s2.length() > 0 && !s2.startsWith("$$")) {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("$$", "$$", 1);
                break;
            }
            case 4: {
                while (true) {
                    if (s2.length() > 0 && s2.charAt(0) != '\"') {
                        s2 = s2.substring(1);
                        continue;
                    }
                    if (!s2.startsWith("\"\"")) break;
                    s2 = s2.substring(2);
                }
                if (s2.length() != 0) break;
                sentence.add("anything", "identifier", 1);
                sentence.add("\"", "\"", 1);
                break;
            }
            case 7: {
                while (s2.length() > 0 && !Bnf.startWithSpace(s2)) {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("anything", "anything", 1);
                break;
            }
            case 10: {
                if (s2.startsWith("0X") || s2.startsWith("0x")) {
                    s2 = s2.substring(2);
                    break;
                }
                if ("0".equals(s2)) {
                    sentence.add("0x", "x", 1);
                    break;
                }
                if (s2.length() != 0) break;
                sentence.add("0x", "0x", 1);
                break;
            }
            case 11: {
                if (s2.equals("|")) {
                    sentence.add("||", "|", 1);
                } else if (s2.startsWith("||")) {
                    s2 = s2.substring(2);
                } else if (s2.length() == 0) {
                    sentence.add("||", "||", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 12: {
                if (s2.length() > 0 && (Character.isLetter(s2.charAt(0)) || s2.charAt(0) == '_')) {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("character", "A", 1);
                break;
            }
            case 13: {
                char ch;
                if (s2.length() > 0 && (ch = Character.toUpperCase(s2.charAt(0))) >= 'A' && ch <= 'F') {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("hex character", "0A", 1);
                break;
            }
            case 14: {
                if (s2.length() > 0 && Character.isDigit(s2.charAt(0))) {
                    s2 = s2.substring(1);
                }
                if (s2.length() != 0) break;
                sentence.add("digit", "1", 1);
                break;
            }
            case 15: {
                if (s2.length() == 0) {
                    sentence.add("[", "[", 1);
                } else if (s2.charAt(0) == '[') {
                    s2 = s2.substring(1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 16: {
                if (s2.length() == 0) {
                    sentence.add("]", "]", 1);
                } else if (s2.charAt(0) == ']') {
                    s2 = s2.substring(1);
                }
                removeTrailingSpaces = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + this.type));
            }
        }
        if (!s2.equals(query2)) {
            if (removeTrailingSpaces) {
                while (Bnf.startWithSpace(s2)) {
                    s2 = s2.substring(1);
                }
            }
            sentence.setQuery(s2);
            return true;
        }
        return false;
    }
}

