/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.jaas;

import java.security.Principal;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.security.SecuritySubjectAdapter;
import org.gridgain.grid.security.AuthenticationValidator;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.jaas.JaasAuthenticatorMBean;
import org.gridgain.grid.security.jaas.JaasCallbackHandlerFactory;
import org.gridgain.grid.security.jaas.JaasJsonPermissionProvider;
import org.gridgain.grid.security.jaas.JaasPermissionsProvider;
import org.jetbrains.annotations.Nullable;

public class JaasAuthenticator
implements Authenticator,
AuthenticationValidator,
JaasAuthenticatorMBean,
LifecycleAware {
    private static final JaasPermissionsProvider DFLT_PERMISSION_PROVIDER = new JaasJsonPermissionProvider();
    private ObjectName mBean;
    @LoggerResource
    private IgniteLogger log;
    @IgniteInstanceResource
    @GridToStringExclude
    private Ignite ignite;
    private String loginCtxName = "GridJaasLoginContext";
    private JaasCallbackHandlerFactory callbackHndFactory = new DefaultCallbackFactory();
    private String dfltPermissions = "{defaultAllow:false}";
    private SecurityPermissionSet dfltPermSet;
    private JaasPermissionsProvider permProvider;
    private boolean globalNodeAuth;

    @Override
    public String getLoginContextName() {
        return this.loginCtxName;
    }

    @Override
    public void setLoginContextName(String loginCtxName) {
        assert (loginCtxName != null);
        this.loginCtxName = loginCtxName;
    }

    @Override
    public String getCallbackHandlerFactoryFormatted() {
        return this.callbackHndFactory.toString();
    }

    public void setCallbackHandlerFactory(JaasCallbackHandlerFactory callbackHndFactory) {
        this.callbackHndFactory = callbackHndFactory;
    }

    public String getDefaultPermissions() {
        return this.dfltPermissions;
    }

    public SecurityPermissionSet getDefaultPermissionSet() {
        return this.dfltPermSet;
    }

    public void setDefaultPermissionSet(SecurityPermissionSet dfltPermSet) {
        this.dfltPermSet = dfltPermSet;
    }

    public JaasPermissionsProvider getPermissionsProvider() {
        return this.permProvider;
    }

    public void setPermissionsProvider(JaasPermissionsProvider permProvider) {
        this.permProvider = permProvider;
    }

    public void setDefaultPermissions(String dfltPermissions) {
        this.dfltPermissions = dfltPermissions;
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return this.globalNodeAuth;
    }

    public void setGlobalNodeAuthentication(boolean globalNodeAuth) {
        this.globalNodeAuth = globalNodeAuth;
    }

    @Override
    public Object validationToken() {
        return new T3<String, SecurityPermissionSet, Boolean>(this.loginCtxName, this.dfltPermSet, this.globalNodeAuth);
    }

    @Override
    public SecuritySubject authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        SecurityPermissionSet permSet;
        LoginContext lc;
        CallbackHandler cbHnd = this.callbackHndFactory.newInstance(authCtx);
        if (cbHnd == null) {
            return null;
        }
        try {
            lc = new LoginContext(this.loginCtxName, cbHnd);
        }
        catch (LoginException e) {
            throw new IgniteCheckedException("Failed to create login context: " + this.loginCtxName, e);
        }
        try {
            lc.login();
        }
        catch (LoginException e) {
            U.error(this.log, "Authentication failed.", e);
            return null;
        }
        ArrayList<SecurityPermissionSet> permSets = new ArrayList<SecurityPermissionSet>();
        for (Principal p : lc.getSubject().getPrincipals()) {
            SecurityPermissionSet permSet2 = this.parsePermissions(p.getName(), false);
            if (permSet2 == null) continue;
            permSets.add(permSet2);
        }
        if (permSets.isEmpty()) {
            permSet = this.dfltPermSet;
            U.log(this.log, String.format("Successfully logged in with default permissions: [subjectType=%s, subjectID=%s, credentials=%s]", new Object[]{authCtx.subjectType(), authCtx.subjectId(), authCtx.credentials() == null ? null : authCtx.credentials().getLogin()}));
        } else {
            if (permSets.size() == 1) {
                permSet = (SecurityPermissionSet)permSets.get(0);
            } else {
                SecurityPermissionSetBuilder builder = new SecurityPermissionSetBuilder();
                permSets.forEach(builder::appendPermissionSet);
                permSet = builder.build();
            }
            U.log(this.log, String.format("Successfully logged in: [subjectType=%s, subjectID=%s, credentials=%s, permissions=%s]", new Object[]{authCtx.subjectType(), authCtx.subjectId(), authCtx.credentials() == null ? null : authCtx.credentials().getLogin(), permSet}));
        }
        SecuritySubjectAdapter subj = new SecuritySubjectAdapter(authCtx.subjectType(), authCtx.subjectId());
        subj.permissions(permSet);
        subj.address(authCtx.address());
        if (authCtx.credentials() != null) {
            subj.login(authCtx.credentials().getLogin());
        }
        subj.certificates(authCtx.certificates());
        return subj;
    }

    @Override
    public boolean supported(SecuritySubjectType subjType) {
        return this.callbackHndFactory.supported(subjType);
    }

    @Override
    public void start() {
        GridPluginUtils.assertParameter(this.callbackHndFactory != null, "callbackHandlerFactory != null");
        GridPluginUtils.assertParameter(this.dfltPermissions != null, "defaultPermissions != null");
        if (this.dfltPermSet == null) {
            this.dfltPermSet = this.parsePermissions(this.dfltPermissions, true);
        }
        GridPluginUtils.assertParameter(this.dfltPermSet != null, "defaultPermissionSet != null");
        GridPluginUtils.assertParameter(this.loginCtxName != null, "loginContextName != null");
        this.registerMBean();
    }

    @Override
    public void stop() {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authenticator stopped ok.");
        }
    }

    private void registerMBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            IgniteConfiguration ctx = this.ignite.configuration();
            this.mBean = U.registerMBean(ctx.getMBeanServer(), ctx.getIgniteInstanceName(), "authenticator", U.getSimpleName(this.getClass()), this, JaasAuthenticatorMBean.class);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register authenticator MBean: " + JaasAuthenticatorMBean.class, e);
        }
    }

    private void unregisterMBean() {
        if (this.mBean == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            IgniteConfiguration ctx = this.ignite.configuration();
            ctx.getMBeanServer().unregisterMBean(this.mBean);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register authenticator MBean: " + JaasAuthenticatorMBean.class, e);
        }
    }

    private SecurityPermissionSet parsePermissions(String permStr, boolean useDfltPermProvider) {
        try {
            JaasPermissionsProvider provider = useDfltPermProvider || this.permProvider == null ? DFLT_PERMISSION_PROVIDER : this.permProvider;
            return provider.permissions(permStr);
        }
        catch (IgniteCheckedException e) {
            if (useDfltPermProvider) {
                String msg = "Failed to parse permissions [permStr=" + permStr + ", permProvider=" + this.permProvider + ']';
                U.error(this.log, msg, e);
            }
            return null;
        }
    }

    public String toString() {
        return S.toString(JaasAuthenticator.class, this);
    }

    private static class DefaultCallbackFactory
    implements JaasCallbackHandlerFactory {
        private DefaultCallbackFactory() {
        }

        @Override
        public boolean supported(SecuritySubjectType subjType) {
            return true;
        }

        @Override
        @Nullable
        public CallbackHandler newInstance(final AuthenticationContext ctx) throws IgniteException {
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            Object login;
                            Object object = login = ctx.credentials() == null ? null : ctx.credentials().getLogin();
                            if (!(login instanceof String)) {
                                throw new IllegalArgumentException("Failed to handle JAAS callback (unsupported login type: " + (login == null ? "null" : login.getClass().getName()) + ")");
                            }
                            NameCallback nc = (NameCallback)callback;
                            nc.setName((String)login);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            Object password;
                            PasswordCallback pc = (PasswordCallback)callback;
                            Object object = password = ctx.credentials() == null ? null : ctx.credentials().getPassword();
                            if (!(password instanceof String) && !(password instanceof char[])) {
                                throw new IllegalArgumentException("Failed to handle JAAS callback (unsupported login type: " + (password == null ? "null" : password.getClass().getName()) + ")");
                            }
                            char[] pwd = password instanceof String ? ((String)password).toCharArray() : (char[])password;
                            pc.setPassword(pwd);
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback, "Failed to handle JAAS callback (unsupported callback type): " + callback.getClass().getName());
                    }
                }
            };
        }
    }
}

