/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.certificate;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.regex.Pattern;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;

public class IssuerRegexPredicate
implements IgnitePredicate<Certificate[]> {
    private static final long serialVersionUID = 0L;
    private final Pattern pattern;

    public IssuerRegexPredicate(String patternStr) {
        this.pattern = Pattern.compile(patternStr);
    }

    @Override
    public boolean apply(Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return false;
        }
        return certs[0] instanceof X509Certificate && this.pattern.matcher(((X509Certificate)certs[0]).getIssuerDN().getName()).matches();
    }

    public String toString() {
        return S.toString(IssuerRegexPredicate.class, this);
    }
}

