/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.certificate;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.resources.LoggerResource;
import org.gridgain.grid.internal.processors.security.AllowAllPermissionSet;
import org.gridgain.grid.internal.util.security.GridSecurityPermissionSetJsonParser;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.SecuritySubjectAdapter;

public class CertificateAuthenticator
implements Authenticator,
SecurityCredentialsProvider {
    private Map<? extends IgnitePredicate<Certificate[]>, SecurityPermissionSet> permsMap;
    private boolean alwaysAcceptServerNodes = true;
    @LoggerResource
    private IgniteLogger log;

    public void setPermissions(Map<? extends IgnitePredicate<Certificate[]>, SecurityPermissionSet> permsMap) {
        this.permsMap = Collections.unmodifiableMap(permsMap);
    }

    public <P extends IgnitePredicate<Certificate[]>> void setPermissionsJson(Map<P, String> permsMapJson) throws IgniteCheckedException {
        LinkedHashMap<P, SecurityPermissionSet> permsMap = new LinkedHashMap<P, SecurityPermissionSet>();
        for (Map.Entry<P, String> entry : permsMapJson.entrySet()) {
            permsMap.put(entry.getKey(), new GridSecurityPermissionSetJsonParser(entry.getValue()).parse());
        }
        this.setPermissions(permsMap);
    }

    public void setAlwaysAcceptServerNodes(boolean alwaysAcceptServerNodes) {
        this.alwaysAcceptServerNodes = alwaysAcceptServerNodes;
    }

    @Override
    public boolean supported(SecuritySubjectType subjType) {
        assert (subjType != null);
        return this.alwaysAcceptServerNodes || subjType == SecuritySubjectType.REMOTE_CLIENT;
    }

    @Override
    public SecuritySubject authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        if (authCtx.subjectType() == SecuritySubjectType.REMOTE_NODE) {
            if (this.alwaysAcceptServerNodes) {
                return new SecuritySubjectAdapter(authCtx.subjectId(), authCtx.subjectType(), "", authCtx.address(), new AllowAllPermissionSet(), null);
            }
            throw new IgniteAccessControlException("Remote nodes cannot be authenticated using certificates.");
        }
        Certificate[] certs = authCtx.certificates();
        if (certs == null || certs.length == 0) {
            throw new IgniteAccessControlException("No client certificates supplied! Please check that SSL and peer certificate checking are enabled.");
        }
        if (this.permsMap == null || this.permsMap.isEmpty()) {
            throw new IgniteAccessControlException("No certificate matchers specified! Please call setPermissions().");
        }
        SecurityPermissionSet perms = null;
        String subjectDnName = null;
        for (Map.Entry<? extends IgnitePredicate<Certificate[]>, SecurityPermissionSet> e : this.permsMap.entrySet()) {
            IgnitePredicate<Certificate[]> p;
            if (subjectDnName == null) {
                subjectDnName = this.certificateName(certs[0]);
            }
            if (!(p = e.getKey()).apply(certs)) continue;
            subjectDnName = this.certificateName(certs[0]);
            perms = e.getValue();
            if (!this.log.isDebugEnabled()) break;
            this.log.debug("Matched certificate with predicate [subjectDnName=" + subjectDnName + ", predicate=" + p + "]");
            break;
        }
        if (perms == null) {
            throw new IgniteAccessControlException("No predicates matched by client certificate(s) [subjectDnName=" + subjectDnName + "].");
        }
        return new SecuritySubjectAdapter(authCtx.subjectId(), authCtx.subjectType(), subjectDnName, authCtx.address(), perms, authCtx.certificates());
    }

    private String certificateName(Certificate cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSubjectDN().getName();
        }
        return cert == null ? "null" : cert.toString();
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return false;
    }

    public String toString() {
        return S.toString(CertificateAuthenticator.class, this);
    }

    @Override
    public SecurityCredentials credentials() {
        return this.alwaysAcceptServerNodes ? new SecurityCredentials("", "") : null;
    }
}

