/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.util.VisorEventMapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.grid.internal.visor.util.VisorEventMapperEnt;
import org.jetbrains.annotations.Nullable;

public class VisorTaskUtilsEnt {
    public static final int[] VISOR_EVTS_ENT;
    private static final Pattern RMT_MARSHALLER_PTRN;
    private static final Map<Integer, String> GRID_EVT_NAMES_ENT;
    public static final int[] VISOR_NON_TASK_EVTS_ENT;
    public static final int[] VISOR_ALL_EVTS_ENT;
    public static final VisorEventMapper EVT_MAPPER_ENT;

    public static List<VisorGridEvent> collectEventsEnt(Ignite ignite, String evtOrderKey, String evtThrottleCntrKey, boolean all, IgniteClosure<Event, VisorGridEvent> evtMapper) {
        int[] evtTypes;
        int[] nArray = evtTypes = all ? VISOR_ALL_EVTS_ENT : VISOR_NON_TASK_EVTS_ENT;
        if (evtOrderKey.startsWith("CONSOLE_")) {
            evtTypes = VisorTaskUtils.concat(evtTypes, EventType.EVTS_DISCOVERY);
        }
        return VisorTaskUtils.collectEvents(ignite, evtOrderKey, evtThrottleCntrKey, evtTypes, evtMapper);
    }

    public static String gridEventNameEnt(int type) {
        String evtUnknown = Integer.toString(type);
        String evtName = U.gridEventName(type);
        if (!evtName.equals(evtUnknown)) {
            return evtName;
        }
        evtName = GRID_EVT_NAMES_ENT.get(type);
        return evtName != null ? evtName : evtUnknown;
    }

    @Nullable
    public static String compactClassEnt(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        String s2 = obj.getClass().getName();
        s2 = s2.replace("org.gridgain.grid.internal.visor.", "o.g.g.i.v.").replace("org.gridgain.grid.internal.", "o.g.g.i.").replace("org.gridgain.grid.scalar.", "o.g.g.s.").replace("org.gridgain.grid.", "o.g.g.");
        return U.compact(s2);
    }

    public static boolean differentMarshaller(String msg) {
        return msg != null && msg.contains("Local node's marshaller differs from remote node's marshaller");
    }

    public static Marshaller remoteMarshaller(CharSequence msg) {
        Matcher matcher = RMT_MARSHALLER_PTRN.matcher(msg);
        if (matcher.matches()) {
            try {
                return (Marshaller)U.newInstance(matcher.group(1));
            }
            catch (IgniteCheckedException ignored) {
                return null;
            }
        }
        return null;
    }

    static {
        Class[] evtHolderClasses;
        VISOR_EVTS_ENT = new int[]{1009, 1008, 1010, 1006, 1002};
        RMT_MARSHALLER_PTRN = Pattern.compile(".+rmtMarshaller=([^,]+).+", 2);
        GRID_EVT_NAMES_ENT = new HashMap<Integer, String>();
        for (Class cls : evtHolderClasses = new Class[]{org.gridgain.grid.events.EventType.class}) {
            for (Field field : cls.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith("EVT_")) continue;
                try {
                    int type = field.getInt(null);
                    String prev = GRID_EVT_NAMES_ENT.put(type, field.getName().substring("EVT_".length()));
                    if ($assertionsDisabled || prev == null) continue;
                    throw new AssertionError((Object)("Duplicate event [type=" + type + ", name1=" + prev + ", name2=" + field.getName() + ']'));
                }
                catch (IllegalAccessException e) {
                    throw new IgniteException(e);
                }
            }
        }
        VISOR_NON_TASK_EVTS_ENT = VisorTaskUtils.concat(VisorTaskUtils.VISOR_NON_TASK_EVTS, VISOR_EVTS_ENT, org.gridgain.grid.events.EventType.EVTS_DR);
        VISOR_ALL_EVTS_ENT = VisorTaskUtils.concat(VisorTaskUtils.VISOR_ALL_EVTS, VISOR_EVTS_ENT, org.gridgain.grid.events.EventType.EVTS_DR);
        EVT_MAPPER_ENT = new VisorEventMapperEnt();
    }
}

