/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.node;

import java.util.Collection;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJob;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.events.EventType;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.visor.dr.VisorDr;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheMetrics;
import org.gridgain.grid.internal.visor.license.VisorLicense;
import org.gridgain.grid.internal.visor.node.VisorGridGainNodeDataCollectorJobResult;
import org.gridgain.grid.internal.visor.node.VisorGridGainNodeDataCollectorTaskArg;
import org.gridgain.grid.internal.visor.util.VisorTaskUtilsEnt;

public class VisorGridGainNodeDataCollectorJob
extends VisorNodeDataCollectorJob {
    private static final long serialVersionUID = 0L;

    public VisorGridGainNodeDataCollectorJob(VisorNodeDataCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    @Override
    protected void events(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        if (arg.getClass() == VisorNodeDataCollectorTaskArg.class) {
            super.events(res, arg);
            return;
        }
        try {
            VisorGridGainNodeDataCollectorTaskArg arg0;
            int[] evts = null;
            if (arg.isTaskMonitoringEnabled()) {
                if (VisorTaskUtils.checkExplicitEvents(this.ignite, VisorTaskUtils.VISOR_TASK_EVTS)) {
                    res.setTaskMonitoringEnabled(true);
                } else {
                    evts = VisorTaskUtils.VISOR_TASK_EVTS;
                }
            }
            if ((arg0 = (VisorGridGainNodeDataCollectorTaskArg)arg).isDrEventsEnabled() && !VisorTaskUtils.checkExplicitEvents(this.ignite, EventType.EVTS_DR)) {
                int[] nArray = evts = evts == null ? EventType.EVTS_DR : VisorTaskUtils.concat(evts, EventType.EVTS_DR);
            }
            if (evts != null) {
                this.startCollectEvents(arg.getEventsOrderKey(), evts);
                if (!res.isTaskMonitoringEnabled()) {
                    res.setTaskMonitoringEnabled(this.ignite.allEventsUserRecordable(VisorTaskUtils.VISOR_TASK_EVTS));
                }
            }
            this.events0(res, arg.getEventsOrderKey(), arg.getEventsThrottleCounterKey(), arg.isTaskMonitoringEnabled());
        }
        catch (Exception e) {
            res.setEventsEx(new VisorExceptionWrapper(e));
        }
    }

    @Override
    protected void events0(VisorNodeDataCollectorJobResult res, String evtOrderKey, String evtThrottleCntrKey, boolean all) {
        res.getEvents().addAll(VisorTaskUtilsEnt.collectEventsEnt(this.ignite, evtOrderKey, evtThrottleCntrKey, all, VisorTaskUtilsEnt.EVT_MAPPER_ENT));
    }

    private void license(VisorGridGainNodeDataCollectorJobResult res) {
        if (this.ignite.cluster().active()) {
            try {
                GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
                GridProduct product = plugin.product();
                if (product != null && product.license() != null) {
                    res.setLicense(new VisorLicense(product));
                }
            }
            catch (Throwable licenseEx) {
                res.setLicenseEx(new VisorExceptionWrapper(licenseEx));
            }
        }
    }

    private void dr(VisorGridGainNodeDataCollectorJobResult res) {
        if (this.ignite.cluster().active()) {
            try {
                GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
                GridGainConfiguration cfg = plugin.configuration();
                if (!DrUtils.isDrEnabled(cfg)) {
                    return;
                }
                GridDr dr = plugin.dr();
                if (dr != null) {
                    if (cfg.getDrSenderConfiguration() != null || cfg.getDrReceiverConfiguration() != null) {
                        res.setDr(new VisorDr(this.ignite, plugin));
                    }
                    Collection<IgniteCacheProxy<?, ?>> caches = this.ignite.context().cache().jcaches();
                    for (IgniteCacheProxy<?, ?> cache : caches) {
                        CacheConfiguration ccfg;
                        GridGainCacheConfiguration ggCcfg;
                        String cacheName = cache.getName();
                        if (VisorTaskUtils.isRestartingCache(this.ignite, cacheName) || (ggCcfg = GridCacheUtils.cachePluginConfiguration(ccfg = cache.getConfiguration(CacheConfiguration.class), GridGainCacheConfiguration.class)) == null) continue;
                        res.getDrCacheMetrics().add(new VisorDrCacheMetrics(dr, ggCcfg, cacheName));
                    }
                }
            }
            catch (Throwable drEx) {
                res.setDrEx(new VisorExceptionWrapper(drEx));
            }
        }
    }

    @Override
    protected VisorNodeDataCollectorJobResult run(VisorNodeDataCollectorTaskArg arg) {
        VisorGridGainNodeDataCollectorJobResult res = new VisorGridGainNodeDataCollectorJobResult();
        this.run(res, arg);
        long start0 = U.currentTimeMillis();
        this.license(res);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected license", this.getClass(), start0);
        }
        this.dr(res);
        if (this.debug) {
            VisorTaskUtils.log(this.ignite.log(), "Collected DR", this.getClass(), start0);
        }
        return res;
    }
}

