/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.license;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.internal.visor.license.VisorLicense;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorLicenseCollectorTask
extends VisorMultiNodeTask<Void, Map<UUID, VisorLicense>, VisorLicense> {
    private static final long serialVersionUID = 0L;

    protected VisorLicenseCollectorJob job(Void arg) {
        return new VisorLicenseCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, VisorLicense> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, VisorLicense> licenses = U.newHashMap(results.size());
        for (ComputeJobResult r : results) {
            VisorLicense license = r.getException() != null ? null : (VisorLicense)r.getData();
            licenses.put(r.getNode().id(), license);
        }
        return licenses;
    }

    private static class VisorLicenseCollectorJob
    extends VisorJob<Void, VisorLicense> {
        private static final long serialVersionUID = 0L;

        private VisorLicenseCollectorJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @Nullable
        protected VisorLicense run(Void arg) {
            GridProduct product;
            if (this.ignite.cluster().active() && (product = ((GridGain)this.ignite.plugin("GridGain")).product()) != null && product.license() != null) {
                return new VisorLicense(product);
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorLicenseCollectorJob.class, this);
        }
    }
}

