/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskResult;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrReceiverInMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderConnection;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrNodeTask
extends VisorOneNodeTask<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> job(VisorDrNodeTaskArgs arg) {
        return new VisorDrNodeJob(arg, this.debug);
    }

    private static class VisorDrNodeJob
    extends VisorJob<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrNodeJob(VisorDrNodeTaskArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorDrNodeTaskResult run(@Nullable VisorDrNodeTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            ClusterNode locNode = this.ignite.localNode();
            GridGainConfiguration pluginCfg = plugin.configuration();
            boolean useCacheNames = pluginCfg.isDrUseCacheNames();
            DrSenderConfiguration senderHubCfg = pluginCfg.getDrSenderConfiguration();
            DrReceiverConfiguration receiverHubCfg = pluginCfg.getDrReceiverConfiguration();
            GridDr dr = plugin.dr();
            VisorDrNodeTaskResult res = new VisorDrNodeTaskResult();
            DiscoveryDataClusterState clusterState = this.ignite.context().state().clusterState();
            res.setDataCenterId(pluginCfg.getDataCenterId());
            res.setDataNode(clusterState.hasBaselineTopology() && CU.baselineNode(locNode, clusterState));
            res.setAddresses(locNode.addresses().toString());
            res.setMode(locNode.isClient() ? "Client" : "Server");
            if (senderHubCfg != null) {
                DrSenderConnectionConfiguration[] senderCfg = senderHubCfg.getConnectionConfiguration();
                ArrayList<T2<Byte, List<String>>> dataCenters = new ArrayList<T2<Byte, List<String>>>();
                for (DrSenderConnectionConfiguration configuration : senderCfg) {
                    dataCenters.add(IgniteUtils.tuple(configuration.getDataCenterId(), Arrays.asList(configuration.getReceiverAddresses())));
                }
                res.setSenderDataCenters(dataCenters);
            }
            if (receiverHubCfg != null) {
                String locInboundHost = receiverHubCfg.getLocalInboundHost();
                int locInboundPort = receiverHubCfg.getLocalInboundPort();
                res.setReceiverAddress(locInboundHost + ":" + locInboundPort);
            }
            if (arg.clearStore()) {
                if (dr.isLocalSender()) {
                    DrSender locSnd = dr.localSender();
                    if (!locSnd.isGlobalStore()) {
                        locSnd.connections().forEach(DrSenderConnection::clearStore);
                    } else {
                        locSnd.clearGlobalStore();
                    }
                    res.addResponseMessage("Clear store command completed successfully.");
                } else {
                    res.addResponseMessage("Clear store command failed, node is not a local sender.");
                }
            }
            if (arg.config()) {
                ArrayList<T2<String, Object>> commonCfg = new ArrayList<T2<String, Object>>();
                commonCfg.add(IgniteUtils.tuple("StreamerThreadPoolSize", pluginCfg.getDrStreamerThreadPoolSize()));
                commonCfg.add(IgniteUtils.tuple("ThreadPoolSize", pluginCfg.getDrThreadPoolSize()));
                commonCfg.add(IgniteUtils.tuple("IncrementalDrThreadPoolSize", pluginCfg.getIncrementalDrPoolSize()));
                res.setCommonConfig(commonCfg);
                ArrayList<T2<String, Object>> sndCfg = new ArrayList<T2<String, Object>>();
                if (senderHubCfg != null) {
                    if (useCacheNames) {
                        sndCfg.add(IgniteUtils.tuple("CacheNames", Arrays.asList(senderHubCfg.getCacheNames())));
                    } else {
                        sndCfg.add(IgniteUtils.tuple("SenderGroups", Arrays.asList(senderHubCfg.getSenderGroups())));
                    }
                    sndCfg.add(IgniteUtils.tuple("MaxErrors", senderHubCfg.getMaxErrors()));
                    sndCfg.add(IgniteUtils.tuple("MaxFailedConnectAttempts", senderHubCfg.getMaxFailedConnectAttempts()));
                    sndCfg.add(IgniteUtils.tuple("MaxQueueSize", senderHubCfg.getMaxQueueSize()));
                    sndCfg.add(IgniteUtils.tuple("SocketSendBufferSize", senderHubCfg.getSocketSendBufferSize()));
                    sndCfg.add(IgniteUtils.tuple("SocketReceiveBufferSize", senderHubCfg.getSocketReceiveBufferSize()));
                    sndCfg.add(IgniteUtils.tuple("HealthCheckFrequency", senderHubCfg.getHealthCheckFrequency()));
                    sndCfg.add(IgniteUtils.tuple("ReadTimeout", senderHubCfg.getReadTimeout()));
                    sndCfg.add(IgniteUtils.tuple("ReconnectOnFailureTimeout", senderHubCfg.getReconnectOnFailureTimeout()));
                    sndCfg.add(IgniteUtils.tuple("SystemRequestTimeout", senderHubCfg.getSystemRequestTimeout()));
                    if (senderHubCfg.getStore() != null) {
                        DrSenderConnectionConfiguration[] sndStore = senderHubCfg.getStore();
                        sndCfg.add(IgniteUtils.tuple("StoreSizeBytes", sndStore.sizeBytes()));
                    }
                    for (DrSenderConnectionConfiguration conCfg : senderHubCfg.getConnectionConfiguration()) {
                        DrSenderStore sndStore = conCfg.getStore();
                        if (sndStore == null) continue;
                        byte dataCenterId = conCfg.getDataCenterId();
                        sndCfg.add(IgniteUtils.tuple("DataCenter" + dataCenterId + "-StoreSizeBytes", sndStore.sizeBytes()));
                    }
                    sndCfg.add(IgniteUtils.tuple("UseIgniteSslContextFactory", senderHubCfg.isUseIgniteSslContextFactory()));
                }
                res.setSenderConfig(sndCfg);
                ArrayList<T2<String, Object>> rcvCfg = new ArrayList<T2<String, Object>>();
                if (receiverHubCfg != null) {
                    rcvCfg.add(IgniteUtils.tuple("SelectorCount", receiverHubCfg.getSelectorCount()));
                    rcvCfg.add(IgniteUtils.tuple("MessageQueueLimit", receiverHubCfg.getMessageQueueLimit()));
                    rcvCfg.add(IgniteUtils.tuple("WorkerThreads", receiverHubCfg.getWorkerThreads()));
                    rcvCfg.add(IgniteUtils.tuple("PerNodeBufferSize", receiverHubCfg.getPerNodeBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple("PerNodeParallelLoadOperations", receiverHubCfg.getPerNodeParallelLoadOperations()));
                    rcvCfg.add(IgniteUtils.tuple("SocketReceiveBufferSize", receiverHubCfg.getSocketReceiveBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple("SocketSendBufferSize", receiverHubCfg.getSocketSendBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple("WriteTimeout", receiverHubCfg.getWriteTimeout()));
                    rcvCfg.add(IgniteUtils.tuple("IdleTimeout", receiverHubCfg.getIdleTimeout()));
                    rcvCfg.add(IgniteUtils.tuple("FlushFrequency", receiverHubCfg.getFlushFrequency()));
                    rcvCfg.add(IgniteUtils.tuple("DirectBuffer", receiverHubCfg.isDirectBuffer()));
                    rcvCfg.add(IgniteUtils.tuple("TcpNodelay", receiverHubCfg.isTcpNodelay()));
                    rcvCfg.add(IgniteUtils.tuple("UseIgniteSslContextFactory", receiverHubCfg.isUseIgniteSslContextFactory()));
                }
                res.setReceiverConfig(rcvCfg);
            }
            if (arg.metrics()) {
                ArrayList<T2<String, Object>> senderMetrics = new ArrayList<T2<String, Object>>();
                if (dr.isLocalSender()) {
                    DrSenderInMetrics inMetrics = dr.senderAggregatedInMetrics();
                    DrSenderOutMetrics outMetrics = dr.senderAggregatedOutMetrics();
                    senderMetrics.add(IgniteUtils.tuple("StoreSize", outMetrics.storeSize()));
                    senderMetrics.add(IgniteUtils.tuple("BatchesSent", outMetrics.batchesSent()));
                    senderMetrics.add(IgniteUtils.tuple("BatchesReceived", inMetrics.batchesReceived()));
                    senderMetrics.add(IgniteUtils.tuple("BatchesAcked", outMetrics.batchesAcked()));
                    senderMetrics.add(IgniteUtils.tuple("AverageBatchAckTime", outMetrics.averageBatchAckTime()));
                    senderMetrics.add(IgniteUtils.tuple("BytesSent", outMetrics.bytesSent()));
                    senderMetrics.add(IgniteUtils.tuple("BytesReceived", inMetrics.bytesReceived()));
                    senderMetrics.add(IgniteUtils.tuple("BytesAcked", outMetrics.bytesAcked()));
                    senderMetrics.add(IgniteUtils.tuple("EntriesSent", outMetrics.entriesSent()));
                    senderMetrics.add(IgniteUtils.tuple("EntriesReceived", inMetrics.entriesReceived()));
                    senderMetrics.add(IgniteUtils.tuple("EntriesAcked", outMetrics.entriesAcked()));
                    if (senderHubCfg.getStore() != null) {
                        DrSenderStore sndStore = senderHubCfg.getStore();
                        senderMetrics.add(IgniteUtils.tuple("StoreIsOverflow", sndStore.isOverflow()));
                    }
                    for (DrSenderConnectionConfiguration conCfg : senderHubCfg.getConnectionConfiguration()) {
                        DrSenderStore sndStore = conCfg.getStore();
                        if (sndStore == null) continue;
                        byte dataCenterId = conCfg.getDataCenterId();
                        senderMetrics.add(IgniteUtils.tuple("DataCenter" + dataCenterId + "-StoreIsOverflow", sndStore.isOverflow()));
                    }
                }
                res.setSenderMetrics(senderMetrics);
                ArrayList<T2<String, Object>> receiverMetrics = new ArrayList<T2<String, Object>>();
                try {
                    DrReceiverInMetrics inMetrics = dr.receiverAggregatedInMetrics();
                    DrReceiverOutMetrics outMetrics = dr.receiverAggregatedOutMetrics();
                    receiverMetrics.add(IgniteUtils.tuple("MessageQueueSizeBytes", inMetrics.messageQueueSizeBytes()));
                    receiverMetrics.add(IgniteUtils.tuple("BatchesSent", outMetrics.batchesSent()));
                    receiverMetrics.add(IgniteUtils.tuple("BatchesReceived", inMetrics.batchesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple("BatchesAcked", outMetrics.batchesAcked()));
                    receiverMetrics.add(IgniteUtils.tuple("AverageBatchAckTime", outMetrics.averageBatchAckTime()));
                    receiverMetrics.add(IgniteUtils.tuple("BytesSent", outMetrics.bytesSent()));
                    receiverMetrics.add(IgniteUtils.tuple("BytesReceived", inMetrics.bytesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple("BytesAcked", outMetrics.bytesAcked()));
                    receiverMetrics.add(IgniteUtils.tuple("EntriesSent", outMetrics.entriesSent()));
                    receiverMetrics.add(IgniteUtils.tuple("EntriesReceived", inMetrics.entriesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple("EntriesAcked", outMetrics.entriesAcked()));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                res.setReceiverMetrics(receiverMetrics);
            }
            return res;
        }
    }
}

