/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderConnection;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionState;
import org.gridgain.grid.dr.DrSenderOutMetrics;

public class VisorDrSenderHubOutMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesSent;
    private long entriesSent;
    private long bytesSent;
    private int batchesAcked;
    private long entriesAcked;
    private long bytesAcked;
    private double avgBatchAckTime;
    private DrSenderConnectionState connState;
    private boolean storeOverflow;

    public VisorDrSenderHubOutMetrics() {
    }

    public static VisorDrSenderHubOutMetrics aggregated(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        try {
            return new VisorDrSenderHubOutMetrics(dr.senderAggregatedOutMetrics());
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public static Map<Byte, VisorDrSenderHubOutMetrics> map(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        DrSenderConfiguration cfg = plugin.configuration().getDrSenderConfiguration();
        HashMap<Byte, VisorDrSenderHubOutMetrics> map = new HashMap<Byte, VisorDrSenderHubOutMetrics>();
        if (cfg != null) {
            for (DrSenderConnectionConfiguration c : cfg.getConnectionConfiguration()) {
                byte rmtDrId = c.getDataCenterId();
                try {
                    VisorDrSenderHubOutMetrics metrics = new VisorDrSenderHubOutMetrics(dr.senderAggregatedOutMetrics(rmtDrId));
                    DrSenderConnection conn = dr.localSender().connection(rmtDrId);
                    metrics.connState = conn.connectionState();
                    metrics.storeOverflow = conn.isStoreOverflow();
                    map.put(rmtDrId, metrics);
                }
                catch (IllegalArgumentException | IllegalStateException runtimeException) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    public VisorDrSenderHubOutMetrics(DrSenderOutMetrics m4) {
        assert (m4 != null);
        this.batchesAcked = m4.batchesAcked();
        this.entriesAcked = m4.entriesAcked();
        this.bytesAcked = m4.bytesAcked();
        this.batchesSent = m4.batchesSent();
        this.entriesSent = m4.entriesSent();
        this.bytesSent = m4.bytesSent();
        this.avgBatchAckTime = m4.averageBatchAckTime();
    }

    public int getBatchesSent() {
        return this.batchesSent;
    }

    public long getEntriesSent() {
        return this.entriesSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public int getBatchesAcked() {
        return this.batchesAcked;
    }

    public long getEntriesAcked() {
        return this.entriesAcked;
    }

    public long getBytesAcked() {
        return this.bytesAcked;
    }

    public double getAverageBatchAckTime() {
        return this.avgBatchAckTime;
    }

    public DrSenderConnectionState getConnectionState() {
        return this.connState;
    }

    public boolean isStoreOverflow() {
        return this.storeOverflow;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesSent);
        out.writeLong(this.entriesSent);
        out.writeLong(this.bytesSent);
        out.writeInt(this.batchesAcked);
        out.writeLong(this.entriesAcked);
        out.writeLong(this.bytesAcked);
        out.writeDouble(this.avgBatchAckTime);
        U.writeEnum(out, this.connState);
        out.writeBoolean(this.storeOverflow);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesSent = in.readInt();
        this.entriesSent = in.readLong();
        this.bytesSent = in.readLong();
        this.batchesAcked = in.readInt();
        this.entriesAcked = in.readLong();
        this.bytesAcked = in.readLong();
        this.avgBatchAckTime = in.readDouble();
        if (protoVer >= 2) {
            this.connState = DrSenderConnectionState.fromOrdinal(in.readByte());
            this.storeOverflow = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorDrSenderHubOutMetrics.class, this);
    }
}

