/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class VisorDrSenderHubInMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesRcv;
    private long entriesRcv;
    private long bytesRcv;

    public VisorDrSenderHubInMetrics() {
    }

    public VisorDrSenderHubInMetrics(DrSenderInMetrics m4) {
        assert (m4 != null);
        this.batchesRcv = m4.batchesReceived();
        this.entriesRcv = m4.entriesReceived();
        this.bytesRcv = m4.bytesReceived();
    }

    public static VisorDrSenderHubInMetrics aggregated(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        try {
            return new VisorDrSenderHubInMetrics(dr.senderAggregatedInMetrics());
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public static Map<String, VisorDrSenderHubInMetrics> map(IgniteEx ignite, GridGain plugin) {
        HashMap<String, VisorDrSenderHubInMetrics> map;
        block9: {
            assert (plugin != null);
            DrSenderConfiguration cfg = plugin.configuration().getDrSenderConfiguration();
            map = new HashMap<String, VisorDrSenderHubInMetrics>();
            if (cfg == null) break block9;
            GridDr dr = plugin.dr();
            if (plugin.configuration().isDrUseCacheNames()) {
                for (String cacheName : cfg.getCacheNames()) {
                    try {
                        DrSenderInMetrics m4 = dr.senderInMetrics(cacheName);
                        map.put(cacheName, new VisorDrSenderHubInMetrics(m4));
                    }
                    catch (IllegalArgumentException | IllegalStateException m4) {
                        // empty catch block
                    }
                }
            } else {
                List<String> effectiveGroups = Arrays.asList(DrUtils.effectiveSenderGroups(cfg));
                for (String cacheName : ignite.cacheNames()) {
                    CacheDrSenderConfiguration cacheSndCfg;
                    CacheConfiguration ccfg;
                    GridGainCacheConfiguration ggCcfg;
                    IgniteCache cache = ignite.cache(cacheName);
                    if (cache == null || (ggCcfg = GridCacheUtils.cachePluginConfiguration(ccfg = cache.getConfiguration(CacheConfiguration.class), GridGainCacheConfiguration.class)) == null || (cacheSndCfg = ggCcfg.getDrSenderConfiguration()) == null || !effectiveGroups.contains(DrUtils.effectiveSenderGroup(cacheSndCfg))) continue;
                    try {
                        DrSenderInMetrics m5 = dr.senderInMetrics(cacheName);
                        map.put(cacheName, new VisorDrSenderHubInMetrics(m5));
                    }
                    catch (IllegalArgumentException | IllegalStateException runtimeException) {}
                }
            }
        }
        return map;
    }

    public int getBatchesReceived() {
        return this.batchesRcv;
    }

    public long getEntriesReceived() {
        return this.entriesRcv;
    }

    public long getBytesReceived() {
        return this.bytesRcv;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesRcv);
        out.writeLong(this.entriesRcv);
        out.writeLong(this.bytesRcv);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesRcv = in.readInt();
        this.entriesRcv = in.readLong();
        this.bytesRcv = in.readLong();
    }

    public String toString() {
        return S.toString(VisorDrSenderHubInMetrics.class, this);
    }
}

