/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStateTransfer;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStatus;
import org.jetbrains.annotations.Nullable;

public class VisorDrSenderCacheMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesSent;
    private long entriesSent;
    private long entriesFiltered;
    private int batchesAcked;
    private long entriesAcked;
    private int batchesFailed;
    private long backupQueueSize;
    private VisorDrCacheStatus status;
    private List<VisorDrCacheStateTransfer> stateTransfers;

    public VisorDrSenderCacheMetrics() {
    }

    public VisorDrSenderCacheMetrics(GridDr dr, String cacheName) {
        assert (dr != null);
        CacheDrSenderMetrics m4 = dr.senderCacheMetrics(cacheName);
        this.batchesSent = m4.batchesSent();
        this.entriesSent = m4.entriesSent();
        this.batchesAcked = m4.batchesAcked();
        this.entriesAcked = m4.entriesAcked();
        this.batchesFailed = m4.batchesFailed();
        this.entriesFiltered = m4.entriesFiltered();
        this.backupQueueSize = m4.backupQueueSize();
        this.status = m4.status() != null ? new VisorDrCacheStatus(m4.status()) : null;
        this.stateTransfers = new ArrayList<VisorDrCacheStateTransfer>();
        for (CacheDrStateTransfer transfer : dr.listStateTransfers(cacheName)) {
            this.stateTransfers.add(new VisorDrCacheStateTransfer(transfer));
        }
    }

    public int getBatchesSent() {
        return this.batchesSent;
    }

    public long getEntriesSent() {
        return this.entriesSent;
    }

    public long getEntriesFiltered() {
        return this.entriesFiltered;
    }

    public int getBatchesAcked() {
        return this.batchesAcked;
    }

    public long getEntriesAcked() {
        return this.entriesAcked;
    }

    public int getBatchesFailed() {
        return this.batchesFailed;
    }

    public long getBackupQueueSize() {
        return this.backupQueueSize;
    }

    @Nullable
    public VisorDrCacheStatus getStatus() {
        return this.status;
    }

    public List<VisorDrCacheStateTransfer> getStateTransfers() {
        return this.stateTransfers;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesSent);
        out.writeLong(this.entriesSent);
        out.writeLong(this.entriesFiltered);
        out.writeInt(this.batchesAcked);
        out.writeLong(this.entriesAcked);
        out.writeInt(this.batchesFailed);
        out.writeLong(this.backupQueueSize);
        out.writeObject(this.status);
        U.writeCollection(out, this.stateTransfers);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesSent = in.readInt();
        this.entriesSent = in.readLong();
        this.entriesFiltered = in.readLong();
        this.batchesAcked = in.readInt();
        this.entriesAcked = in.readLong();
        this.batchesFailed = in.readInt();
        this.backupQueueSize = in.readLong();
        this.status = (VisorDrCacheStatus)in.readObject();
        this.stateTransfers = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorDrSenderCacheMetrics.class, this);
    }
}

