/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.dr.DrReceiverOutMetrics;

public class VisorDrReceiverHubOutMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesSent;
    private long entriesSent;
    private long bytesSent;
    private int batchesAcked;
    private long entriesAcked;
    private long bytesAcked;
    private double avgBatchAckTime;

    public VisorDrReceiverHubOutMetrics() {
    }

    public VisorDrReceiverHubOutMetrics(DrReceiverOutMetrics m4) {
        assert (m4 != null);
        this.batchesAcked = m4.batchesAcked();
        this.entriesAcked = m4.entriesAcked();
        this.bytesAcked = m4.bytesAcked();
        this.batchesSent = m4.batchesSent();
        this.entriesSent = m4.entriesSent();
        this.bytesSent = m4.bytesSent();
        this.avgBatchAckTime = m4.averageBatchAckTime();
    }

    public static VisorDrReceiverHubOutMetrics aggregated(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        try {
            return new VisorDrReceiverHubOutMetrics(dr.receiverAggregatedOutMetrics());
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public int getBatchesSent() {
        return this.batchesSent;
    }

    public long getEntriesSent() {
        return this.entriesSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public int getBatchesAcked() {
        return this.batchesAcked;
    }

    public long getEntriesAcked() {
        return this.entriesAcked;
    }

    public long getBytesAcked() {
        return this.bytesAcked;
    }

    public double getAverageBatchAckTime() {
        return this.avgBatchAckTime;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesSent);
        out.writeLong(this.entriesSent);
        out.writeLong(this.bytesSent);
        out.writeInt(this.batchesAcked);
        out.writeLong(this.entriesAcked);
        out.writeLong(this.bytesAcked);
        out.writeDouble(this.avgBatchAckTime);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesSent = in.readInt();
        this.entriesSent = in.readLong();
        this.bytesSent = in.readLong();
        this.batchesAcked = in.readInt();
        this.entriesAcked = in.readLong();
        this.bytesAcked = in.readLong();
        this.avgBatchAckTime = in.readDouble();
    }

    public String toString() {
        return S.toString(VisorDrReceiverHubOutMetrics.class, this);
    }
}

