/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;

public class VisorDrReceiverCacheMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long entriesReceived;
    private long conflictNew;
    private long conflictOld;
    private long conflictMerge;

    public VisorDrReceiverCacheMetrics() {
    }

    public VisorDrReceiverCacheMetrics(GridDr dr, String cacheName) {
        assert (dr != null);
        CacheDrReceiverMetrics m4 = dr.receiverCacheMetrics(cacheName);
        this.entriesReceived = m4.entriesReceived();
        this.conflictNew = m4.conflictNew();
        this.conflictOld = m4.conflictOld();
        this.conflictMerge = m4.conflictMerge();
    }

    public long getEntriesReceived() {
        return this.entriesReceived;
    }

    public long getConflictNew() {
        return this.conflictNew;
    }

    public long getConflictOld() {
        return this.conflictOld;
    }

    public long getConflictMerge() {
        return this.conflictMerge;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.entriesReceived);
        out.writeLong(this.conflictNew);
        out.writeLong(this.conflictOld);
        out.writeLong(this.conflictMerge);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.entriesReceived = in.readLong();
        this.conflictNew = in.readLong();
        this.conflictOld = in.readLong();
        this.conflictMerge = in.readLong();
    }

    public String toString() {
        return S.toString(VisorDrReceiverCacheMetrics.class, this);
    }
}

