/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderConnection;
import org.gridgain.grid.internal.visor.dr.VisorDrClearSenderConnectionStoreTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrClearSenderConnectionStoreTask
extends VisorMultiNodeTask<VisorDrClearSenderConnectionStoreTaskArg, Void, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorDrClearSenderConnectionStoreJob job(VisorDrClearSenderConnectionStoreTaskArg arg) {
        return new VisorDrClearSenderConnectionStoreJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Void reduce0(List<ComputeJobResult> results) {
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            throw res.getException();
        }
        return null;
    }

    private static class VisorDrClearSenderConnectionStoreJob
    extends VisorJob<VisorDrClearSenderConnectionStoreTaskArg, Void> {
        private static final long serialVersionUID = 0L;

        private VisorDrClearSenderConnectionStoreJob(VisorDrClearSenderConnectionStoreTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(VisorDrClearSenderConnectionStoreTaskArg arg) {
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridDr dr = plugin.dr();
            if (dr.isLocalSender()) {
                DrSender drSnd = dr.localSender();
                Map<Byte, Collection<String>> connections = arg.getSenderConnections();
                for (DrSenderConnection conn : drSnd.connections()) {
                    Collection<String> targetAddrs = connections.get(conn.dataCenterId());
                    List<String> rcvAddrs = Arrays.asList(conn.getConfiguration().getReceiverAddresses());
                    if (!F.isEmpty(targetAddrs) && !Collections.disjoint(targetAddrs, rcvAddrs)) continue;
                    conn.clearStore();
                }
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorDrClearSenderConnectionStoreJob.class, this);
        }
    }
}

