/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.txdr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;

public class TransactionalDrGlobalStatus
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private ClusterRole role;
    private ReplicationState state;
    private long sesId;
    private long lastSuccessfullyAppliedCutId;
    private long timeLag;
    @GridToStringInclude
    private Map<Object, ReplicationSessionDescriptor> locStates;
    private boolean readOnly;

    public TransactionalDrGlobalStatus() {
    }

    public TransactionalDrGlobalStatus(ClusterRole role, ReplicationState state, long sesId, long lastSuccessfullyAppliedCutId, long timeLag, Map<Object, ReplicationSessionDescriptor> locStates, boolean readOnly) {
        this.role = role;
        this.state = state;
        this.sesId = sesId;
        this.lastSuccessfullyAppliedCutId = lastSuccessfullyAppliedCutId;
        this.timeLag = timeLag;
        this.locStates = U.sealMap(locStates);
        this.readOnly = readOnly;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public ClusterRole role() {
        return this.role;
    }

    public ReplicationState state() {
        return this.state;
    }

    public long sessionId() {
        return this.sesId;
    }

    public long lastSuccessfullyAppliedCutId() {
        return this.lastSuccessfullyAppliedCutId;
    }

    public long timeLag() {
        return this.timeLag;
    }

    public Map<Object, ReplicationSessionDescriptor> localStates() {
        return this.locStates;
    }

    public Set<Object> laggingBehindNodes() {
        return this.localStates().entrySet().stream().filter(e -> ((ReplicationSessionDescriptor)e.getValue()).laggingBehind()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<Object, List<String>> essentialMessages() {
        return this.localStates().entrySet().stream().filter(e -> !((ReplicationSessionDescriptor)e.getValue()).essentialMessages().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReplicationSessionDescriptor)e.getValue()).essentialMessages()));
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.role);
        U.writeEnum(out, this.state);
        out.writeLong(this.sesId);
        out.writeLong(this.lastSuccessfullyAppliedCutId);
        out.writeLong(this.timeLag);
        U.writeMap(out, this.locStates);
        out.writeBoolean(this.readOnly);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.role = ClusterRole.fromOrdinal(in.readByte());
        this.state = ReplicationState.fromOrdinal(in.readByte());
        this.sesId = in.readLong();
        this.lastSuccessfullyAppliedCutId = in.readLong();
        this.timeLag = in.readLong();
        this.locStates = U.readMap(in);
        this.readOnly = in.readBoolean();
    }

    public String toString() {
        return S.toString(TransactionalDrGlobalStatus.class, this);
    }
}

