/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.txdr;

import java.io.File;
import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.persistentstore.SnapshotChainMode;

public class BootstrapMasterParameters
implements Serializable {
    private static final long serialVersionUID = 0L;
    private File snapshotFolder;
    private SnapshotCommonParameters snapshotCommonParameters;
    private SnapshotCreateParameters snapshotCreateParameters;
    private SnapshotUpdateOperationParameters snapshotUpdateOperationParameters;

    public SnapshotCreateParameters snapshotCreateParameters() {
        return this.snapshotCreateParameters;
    }

    public SnapshotUpdateOperationParameters snapshotUpdateOperationParameters() {
        return this.snapshotUpdateOperationParameters;
    }

    public File snapshotFolder() {
        return this.snapshotFolder;
    }

    public SnapshotCommonParameters snapshotCommonParameters() {
        return this.snapshotCommonParameters;
    }

    public String toString() {
        return S.toString(BootstrapMasterParameters.class, this);
    }

    public static final class Builder {
        private File snapshotFolder;
        private int parallelism = 2;
        private CompressionOption compressionOption = CompressionOption.ZIP;
        private int compressionLevel = 1;
        private int writeThrottlingThreshold;
        private boolean singleFileCopy;

        public Builder withSnapshotFolder(File folder) {
            this.snapshotFolder = folder;
            return this;
        }

        public Builder withSnapshotFolder(String folder) {
            this.snapshotFolder = new File(folder);
            return this;
        }

        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder withCompressionOption(CompressionOption compressionOption) {
            this.compressionOption = compressionOption;
            return this;
        }

        public Builder withCompressionLevel(int compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder withWriteThrottlingThreshold(int writeThrottlingThreshold) {
            this.writeThrottlingThreshold = writeThrottlingThreshold;
            return this;
        }

        public Builder withSingleFileCopy(boolean singleFileCopy) {
            this.singleFileCopy = singleFileCopy;
            return this;
        }

        public BootstrapMasterParameters build() {
            BootstrapMasterParameters res = new BootstrapMasterParameters();
            res.snapshotFolder = this.snapshotFolder;
            res.snapshotCommonParameters = new SnapshotCommonParameters(this.parallelism);
            res.snapshotCreateParameters = new SnapshotCreateParameters(this.compressionOption, this.compressionLevel, this.writeThrottlingThreshold);
            res.snapshotUpdateOperationParameters = new SnapshotUpdateOperationParameters.Builder().withChainMode(SnapshotChainMode.SINGLE).withSingleFileCopy(this.singleFileCopy).withParralelismLevel(this.parallelism).build();
            return res;
        }
    }
}

